/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.HttpRequestUtils;
import com.jsunsoft.http.TypeReference;
import com.jsunsoft.http.annotations.Beta;
import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;

public interface Response
extends CloseableHttpResponse {
    public <T> T readEntity(Class<T> var1);

    public <T> T readEntity(TypeReference<T> var1);

    @Beta
    public <T> T readEntityChecked(Class<T> var1) throws IOException;

    @Beta
    public <T> T readEntityChecked(TypeReference<T> var1) throws IOException;

    public URI getURI();

    default public boolean hasEntity() {
        return this.getEntity() != null;
    }

    default public ContentType getContentType() {
        return ContentType.get((HttpEntity)this.getEntity());
    }

    default public int getStatusCode() {
        return this.getStatusLine().getStatusCode();
    }

    default public boolean isSuccess() {
        return HttpRequestUtils.isSuccess(this.getStatusCode());
    }

    default public boolean isNonSuccess() {
        return !this.isSuccess();
    }
}

