/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.BasicWebTarget;
import com.jsunsoft.http.HttpMethod;
import com.jsunsoft.http.HttpRequestUtils;
import com.jsunsoft.http.HttpUriRequestBuilder;
import com.jsunsoft.http.Response;
import com.jsunsoft.http.ResponseBodyReaderConfig;
import com.jsunsoft.http.ResponseHandler;
import com.jsunsoft.http.TypeReference;
import com.jsunsoft.http.WebTarget;
import com.jsunsoft.http.annotations.Beta;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

@Beta
class ImmutableWebTarget
extends BasicWebTarget {
    ImmutableWebTarget(CloseableHttpClient closeableHttpClient, URI uri, Collection<Header> defaultHeaders, Collection<NameValuePair> defaultRequestParameters, ResponseBodyReaderConfig responseBodyReaderConfig) {
        super(closeableHttpClient, uri, defaultHeaders, defaultRequestParameters, responseBodyReaderConfig);
    }

    ImmutableWebTarget(CloseableHttpClient closeableHttpClient, String uri, Collection<Header> defaultHeaders, Collection<NameValuePair> defaultRequestParameters, ResponseBodyReaderConfig responseBodyReaderConfig) throws URISyntaxException {
        super(closeableHttpClient, uri, defaultHeaders, defaultRequestParameters, responseBodyReaderConfig);
    }

    private ImmutableWebTarget(CloseableHttpClient closeableHttpClient, URIBuilder uriBuilder, HttpUriRequestBuilder httpUriRequestBuilder, ResponseBodyReaderConfig responseBodyReaderConfig) {
        super(closeableHttpClient, uriBuilder, httpUriRequestBuilder, responseBodyReaderConfig);
    }

    private WebTarget toBasicWebTarget() {
        return new BasicWebTarget(this);
    }

    @Override
    public WebTarget path(String path) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), HttpRequestUtils.appendPath(this.getUriBuilder(), path), this.getHttpUriRequestBuilder(), this.getResponseBodyReaderConfig());
    }

    @Override
    public WebTarget setPath(String path) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), this.getUriBuilder().setPath(path), this.getHttpUriRequestBuilder(), this.getResponseBodyReaderConfig());
    }

    @Override
    public WebTarget removeHeader(Header header) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), this.getUriBuilder(), this.getHttpUriRequestBuilder().removeHeader(header), this.getResponseBodyReaderConfig());
    }

    @Override
    public WebTarget removeHeaders(String name) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), this.getUriBuilder(), this.getHttpUriRequestBuilder().removeHeaders(name), this.getResponseBodyReaderConfig());
    }

    @Override
    public WebTarget updateHeader(Header header) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), this.getUriBuilder(), this.getHttpUriRequestBuilder().setHeader(header), this.getResponseBodyReaderConfig());
    }

    @Override
    public WebTarget addHeader(Header header) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), this.getUriBuilder(), this.getHttpUriRequestBuilder().addHeader(header), this.getResponseBodyReaderConfig());
    }

    @Override
    public WebTarget setRequestConfig(RequestConfig requestConfig) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), this.getUriBuilder(), this.getHttpUriRequestBuilder().setConfig(requestConfig), this.getResponseBodyReaderConfig());
    }

    @Override
    public WebTarget addParameter(NameValuePair nameValuePair) {
        return new ImmutableWebTarget(this.getCloseableHttpClient(), this.getUriBuilder(), this.getHttpUriRequestBuilder().addParameter(nameValuePair), this.getResponseBodyReaderConfig());
    }

    @Override
    public Response request(HttpMethod method, HttpEntity httpEntity) {
        return new BasicWebTarget(this.getCloseableHttpClient(), this.getUriBuilder(), this.getHttpUriRequestBuilder(), this.getResponseBodyReaderConfig()).request(method, httpEntity);
    }

    @Override
    public <T> ResponseHandler<T> request(HttpMethod method, HttpEntity httpEntity, Class<T> responseType) {
        return this.toBasicWebTarget().request(method, httpEntity, responseType);
    }

    @Override
    public <T> ResponseHandler<T> request(HttpMethod method, HttpEntity httpEntity, TypeReference<T> responseType) {
        return this.toBasicWebTarget().request(method, httpEntity, responseType);
    }

    @Override
    public <T> ResponseHandler<T> request(HttpMethod method, Class<T> responseType) {
        return this.toBasicWebTarget().request(method, responseType);
    }

    @Override
    public Response request(HttpMethod method) {
        return this.toBasicWebTarget().request(method);
    }

    @Override
    public <T> ResponseHandler<T> request(HttpMethod method, TypeReference<T> typeReference) {
        return this.toBasicWebTarget().request(method, typeReference);
    }
}

