/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.jsunsoft.http.ArgsCheck;
import com.jsunsoft.http.DateDeserializeContext;
import com.jsunsoft.http.HttpRequestUtils;
import com.jsunsoft.http.InvalidMimeTypeException;
import com.jsunsoft.http.ResponseBodyReadableContext;
import com.jsunsoft.http.ResponseBodyReader;
import com.jsunsoft.http.ResponseBodyReaderContext;
import com.jsunsoft.http.ResponseBodyReaderException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.time.LocalDate;
import org.apache.http.entity.ContentType;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultResponseBodyReader<T>
implements ResponseBodyReader<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResponseBodyReader.class);
    private final ObjectMapper jsonSerializer;
    private final ObjectMapper xmlSerializer;
    private final DateDeserializeContext dateDeserializeContext;

    DefaultResponseBodyReader(DateDeserializeContext dateDeserializeContext) {
        this.dateDeserializeContext = dateDeserializeContext;
        this.jsonSerializer = this.defaultInit(new ObjectMapper());
        this.xmlSerializer = this.defaultInit((ObjectMapper)new XmlMapper());
    }

    @Override
    public boolean isReadable(ResponseBodyReadableContext bodyReadableContext) {
        return bodyReadableContext.hasEntity();
    }

    @Override
    public T read(ResponseBodyReaderContext<T> bodyReaderContext) throws IOException, ResponseBodyReaderException {
        Object result;
        String mimeType;
        ContentType contentType = bodyReaderContext.getContentType();
        String string = mimeType = contentType == null ? null : contentType.getMimeType();
        if (ContentType.APPLICATION_JSON.getMimeType().equals(mimeType)) {
            result = this.deserialize(bodyReaderContext, this.jsonSerializer);
        } else if (ContentType.APPLICATION_XML.getMimeType().equals(mimeType)) {
            result = this.deserialize(bodyReaderContext, this.xmlSerializer);
        } else if (bodyReaderContext.getType() == String.class) {
            result = ResponseBodyReader.stringReader().read(bodyReaderContext);
        } else {
            throw new InvalidMimeTypeException(mimeType, "DefaultDeserializer doesn't supported mimeType " + mimeType + " for converting response content to: " + bodyReaderContext.getType());
        }
        return result;
    }

    private T deserialize(ResponseBodyReaderContext<T> responseBodyReaderContext, ObjectMapper objectMapper) throws ResponseBodyReaderException {
        try {
            return DefaultResponseBodyReader.deserialize(responseBodyReaderContext.getContent(), responseBodyReaderContext.getGenericType(), objectMapper);
        }
        catch (IOException e) {
            throw new ResponseBodyReaderException(e);
        }
    }

    private static <T> T deserialize(InputStream inputStreamToDeserialize, Type type, ObjectMapper objectMapper) throws IOException {
        ArgsCheck.notNull(inputStreamToDeserialize, "inputStreamToDeserialize");
        ArgsCheck.notNull(type, "type");
        long startTime = System.currentTimeMillis();
        JavaType javaType = objectMapper.constructType(type);
        Object result = objectMapper.readValue(inputStreamToDeserialize, javaType);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time of deserialization inputStream to type: [{}] is {}", (Object)type, (Object)HttpRequestUtils.humanTime(startTime));
        }
        return (T)result;
    }

    private ObjectMapper defaultInit(ObjectMapper objectMapper) {
        objectMapper.configOverride(org.joda.time.LocalDate.class).setFormat(JsonFormat.Value.forPattern((String)this.dateDeserializeContext.getDatePattern()));
        objectMapper.configOverride(LocalTime.class).setFormat(JsonFormat.Value.forPattern((String)this.dateDeserializeContext.getTimePattern()));
        objectMapper.configOverride(LocalDateTime.class).setFormat(JsonFormat.Value.forPattern((String)this.dateDeserializeContext.getDateTimePattern()));
        objectMapper.configOverride(LocalDate.class).setFormat(JsonFormat.Value.forPattern((String)this.dateDeserializeContext.getDatePattern()));
        objectMapper.configOverride(java.time.LocalTime.class).setFormat(JsonFormat.Value.forPattern((String)this.dateDeserializeContext.getTimePattern()));
        objectMapper.configOverride(java.time.LocalDateTime.class).setFormat(JsonFormat.Value.forPattern((String)this.dateDeserializeContext.getDateTimePattern()));
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).registerModules(new Module[]{new JodaModule(), new ParameterNamesModule(JsonCreator.Mode.PROPERTIES), new Jdk8Module(), new JavaTimeModule()});
        return objectMapper;
    }
}

