/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.ArgsCheck;
import com.jsunsoft.http.HostPoolConfig;
import com.jsunsoft.http.HttpRequestBuildException;
import java.net.ProxySelector;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class ClientBuilder {
    private RedirectStrategy redirectStrategy;
    private RequestConfig.Builder defaultRequestConfigBuilder = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(5000).setConnectionRequestTimeout(30000);
    private Collection<Consumer<HttpClientBuilder>> httpClientBuilderCustomizers;
    private Collection<Consumer<RequestConfig.Builder>> defaultRequestConfigBuilderCustomizers;
    private Collection<Header> defaultHeaders;
    private HttpHost proxy;
    private boolean useDefaultProxy;
    private SSLContext sslContext;
    private HostnameVerifier hostnameVerifier;
    private HostPoolConfig hostPoolConfig = HostPoolConfig.create();

    ClientBuilder() {
    }

    public ClientBuilder setConnectTimeout(int connectTimeout) {
        this.defaultRequestConfigBuilder.setConnectTimeout(connectTimeout);
        return this;
    }

    public ClientBuilder socketTimeOut(int socketTimeOut) {
        this.defaultRequestConfigBuilder.setSocketTimeout(socketTimeOut);
        return this;
    }

    public ClientBuilder connectionRequestTimeout(int connectionRequestTimeout) {
        this.defaultRequestConfigBuilder.setConnectionRequestTimeout(connectionRequestTimeout);
        return this;
    }

    public ClientBuilder addDefaultRequestConfigCustomizer(Consumer<RequestConfig.Builder> defaultRequestConfigBuilderConsumer) {
        if (this.defaultRequestConfigBuilderCustomizers == null) {
            this.defaultRequestConfigBuilderCustomizers = new LinkedHashSet<Consumer<RequestConfig.Builder>>();
        }
        this.defaultRequestConfigBuilderCustomizers.add(defaultRequestConfigBuilderConsumer);
        return this;
    }

    public ClientBuilder addHttpClientCustomizer(Consumer<HttpClientBuilder> httpClientCustomizer) {
        if (this.httpClientBuilderCustomizers == null) {
            this.httpClientBuilderCustomizers = new LinkedHashSet<Consumer<HttpClientBuilder>>();
        }
        this.httpClientBuilderCustomizers.add(httpClientCustomizer);
        return this;
    }

    public ClientBuilder setMaxPoolSize(int maxPoolSize) {
        this.hostPoolConfig.setMaxPoolSize(maxPoolSize);
        return this;
    }

    public ClientBuilder setDefaultMaxPoolSizePerRoute(int defaultMaxPoolSizePerRoute) {
        this.hostPoolConfig.setDefaultMaxPoolSizePerRoute(defaultMaxPoolSizePerRoute);
        return this;
    }

    public ClientBuilder setMaxPoolSizePerRoute(HttpHost httpHost, int maxRoutePoolSize) {
        this.hostPoolConfig.setMaxPoolSizePerRoute(httpHost, maxRoutePoolSize);
        return this;
    }

    public ClientBuilder enableLaxRedirectStrategy() {
        this.redirectStrategy = LaxRedirectStrategy.INSTANCE;
        return this;
    }

    public ClientBuilder enableDefaultRedirectStrategy() {
        this.redirectStrategy = DefaultRedirectStrategy.INSTANCE;
        return this;
    }

    public ClientBuilder redirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
        return this;
    }

    public ClientBuilder addDefaultHeader(String name, String value) {
        ArgsCheck.notNull(name, "name");
        this.addDefaultHeader((Header)new BasicHeader(name, value));
        return this;
    }

    public ClientBuilder addDefaultHeader(Header header) {
        ArgsCheck.notNull(header, "header");
        if (this.defaultHeaders == null) {
            this.defaultHeaders = new ArrayList<Header>();
        }
        this.defaultHeaders.add((Header)new BasicHeader(header.getName(), header.getValue()));
        return this;
    }

    public ClientBuilder addDefaultHeaders(Header ... headers) {
        ArgsCheck.notNull(headers, "headers");
        Arrays.stream(headers).forEach(this::addDefaultHeader);
        return this;
    }

    public ClientBuilder addDefaultHeaders(Collection<? extends Header> headers) {
        ArgsCheck.notNull(headers, "headers");
        headers.forEach(this::addDefaultHeader);
        return this;
    }

    public ClientBuilder addContentType(ContentType contentType) {
        this.addDefaultHeader("Content-Type", contentType.toString());
        return this;
    }

    public ClientBuilder proxy(HttpHost proxy) {
        this.proxy = proxy;
        return this;
    }

    public ClientBuilder proxy(URI proxyUri) {
        return this.proxy(new HttpHost(proxyUri.getHost(), proxyUri.getPort(), proxyUri.getScheme()));
    }

    public ClientBuilder proxy(String host, int port) {
        return this.proxy(new HttpHost(host, port));
    }

    public ClientBuilder useDefaultProxy() {
        this.useDefaultProxy = true;
        return this;
    }

    public ClientBuilder sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public ClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public ClientBuilder trustAllCertificates() {
        try {
            this.sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new HttpRequestBuildException(e);
        }
        return this;
    }

    public ClientBuilder trustAllHosts() {
        this.hostnameVerifier = NoopHostnameVerifier.INSTANCE;
        return this;
    }

    public CloseableHttpClient build() {
        if (this.defaultRequestConfigBuilderCustomizers != null) {
            this.defaultRequestConfigBuilderCustomizers.forEach(defaultRequestConfigBuilderConsumer -> defaultRequestConfigBuilderConsumer.accept(this.defaultRequestConfigBuilder));
        }
        RequestConfig requestConfig = this.defaultRequestConfigBuilder.build();
        Registry socketFactoryRegistry = null;
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        SSLConnectionSocketFactory sslSocketFactory = null;
        if (this.sslContext != null) {
            clientBuilder.setSSLContext(this.sslContext);
            sslSocketFactory = new SSLConnectionSocketFactory(this.sslContext, this.hostnameVerifier);
        }
        if (this.hostnameVerifier != null) {
            clientBuilder.setSSLHostnameVerifier(this.hostnameVerifier);
            if (this.sslContext == null) {
                sslSocketFactory = new SSLConnectionSocketFactory(SSLContexts.createDefault(), this.hostnameVerifier);
            }
        }
        if (sslSocketFactory != null) {
            socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", sslSocketFactory).build();
        }
        PoolingHttpClientConnectionManager connectionManager = socketFactoryRegistry == null ? new PoolingHttpClientConnectionManager() : new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setDefaultMaxPerRoute(this.hostPoolConfig.getDefaultMaxPoolSizePerRoute());
        this.hostPoolConfig.getHttpHostToMaxPoolSize().forEach((httpHost, maxPerRoute) -> {
            HttpRoute httpRoute = new HttpRoute(httpHost);
            connectionManager.setMaxPerRoute(httpRoute, maxPerRoute.intValue());
        });
        connectionManager.setMaxTotal(this.hostPoolConfig.getMaxPoolSize());
        DefaultProxyRoutePlanner routePlanner = null;
        if (this.proxy != null) {
            routePlanner = new DefaultProxyRoutePlanner(this.proxy);
        } else if (this.useDefaultProxy) {
            routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        }
        clientBuilder.setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).disableCookieManagement().disableAutomaticRetries();
        if (routePlanner != null) {
            clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        if (this.defaultHeaders != null && !this.defaultHeaders.isEmpty()) {
            clientBuilder.setDefaultHeaders(this.defaultHeaders);
        }
        if (this.redirectStrategy == null) {
            clientBuilder.disableRedirectHandling();
        } else {
            clientBuilder.setRedirectStrategy(this.redirectStrategy);
        }
        if (this.httpClientBuilderCustomizers != null) {
            this.httpClientBuilderCustomizers.forEach(httpClientBuilderConsumer -> httpClientBuilderConsumer.accept(clientBuilder));
        }
        return clientBuilder.build();
    }

    public static ClientBuilder create() {
        return new ClientBuilder();
    }
}

