/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.ArgsCheck;
import com.jsunsoft.http.ResponseBodyReader;
import com.jsunsoft.http.ResponseBodyReaderContext;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.entity.ContentType;

final class BasicResponseBodyReaderContext<T>
implements ResponseBodyReaderContext<T> {
    private final HttpResponse httpResponse;
    private final Class<T> type;
    private final Type genericType;

    BasicResponseBodyReaderContext(HttpResponse httpResponse, Class<T> type, Type genericType) {
        this.httpResponse = ArgsCheck.notNull(httpResponse, "httpResponse");
        this.type = ArgsCheck.notNull(type, "type");
        this.genericType = ArgsCheck.notNull(genericType, "genericType");
    }

    @Override
    public InputStream getContent() throws IOException {
        return this.httpResponse.getEntity().getContent();
    }

    @Override
    public String getContentAsString() throws IOException {
        return ResponseBodyReader.stringReader().read(new BasicResponseBodyReaderContext<String>(this.httpResponse, String.class, (Type)((Object)String.class)));
    }

    @Override
    public ContentType getContentType() {
        return ContentType.get((HttpEntity)this.getHttpEntity());
    }

    @Override
    public long getContentLength() {
        return this.getHttpEntity().getContentLength();
    }

    @Override
    public HttpEntity getHttpEntity() {
        return this.httpResponse.getEntity();
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public StatusLine getStatusLine() {
        return this.httpResponse.getStatusLine();
    }

    @Override
    public boolean hasEntity() {
        return this.getHttpEntity() != null;
    }
}

