/*
 * Decompiled with CFR 0.152.
 */
package com.jsunsoft.http;

import com.jsunsoft.http.BasicResponseBodyReaderContext;
import com.jsunsoft.http.Response;
import com.jsunsoft.http.ResponseBodyProcessingException;
import com.jsunsoft.http.ResponseBodyReader;
import com.jsunsoft.http.ResponseBodyReaderConfig;
import com.jsunsoft.http.ResponseBodyReaderException;
import com.jsunsoft.http.ResponseBodyReaderNotFoundException;
import com.jsunsoft.http.TypeReference;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Locale;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

class BasicResponse
implements Response {
    private final CloseableHttpResponse closeableHttpResponse;
    private final ResponseBodyReaderConfig responseBodyReaderConfig;
    private final URI uri;

    public BasicResponse(CloseableHttpResponse closeableHttpResponse, ResponseBodyReaderConfig responseBodyReaderConfig, URI uri) {
        this.closeableHttpResponse = closeableHttpResponse;
        this.responseBodyReaderConfig = responseBodyReaderConfig;
        this.uri = uri;
    }

    public void close() throws IOException {
        try {
            EntityUtils.consume((HttpEntity)this.getEntity());
        }
        catch (IOException e) {
            this.closeableHttpResponse.close();
            throw e;
        }
        this.closeableHttpResponse.close();
    }

    public StatusLine getStatusLine() {
        return this.closeableHttpResponse.getStatusLine();
    }

    public void setStatusLine(StatusLine statusline) {
        this.closeableHttpResponse.setStatusLine(statusline);
    }

    public void setStatusLine(ProtocolVersion ver, int code) {
        this.closeableHttpResponse.setStatusLine(ver, code);
    }

    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        this.closeableHttpResponse.setStatusLine(ver, code, reason);
    }

    public void setStatusCode(int code) throws IllegalStateException {
        this.closeableHttpResponse.setStatusCode(code);
    }

    public void setReasonPhrase(String reason) throws IllegalStateException {
        this.closeableHttpResponse.setReasonPhrase(reason);
    }

    public HttpEntity getEntity() {
        return this.closeableHttpResponse.getEntity();
    }

    public void setEntity(HttpEntity entity) {
        this.closeableHttpResponse.setEntity(entity);
    }

    public Locale getLocale() {
        return this.closeableHttpResponse.getLocale();
    }

    public void setLocale(Locale loc) {
        this.closeableHttpResponse.setLocale(loc);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.closeableHttpResponse.getProtocolVersion();
    }

    public boolean containsHeader(String name) {
        return this.closeableHttpResponse.containsHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.closeableHttpResponse.getHeaders(name);
    }

    public Header getFirstHeader(String name) {
        return this.closeableHttpResponse.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.closeableHttpResponse.getLastHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.closeableHttpResponse.getAllHeaders();
    }

    public void addHeader(Header header) {
        this.closeableHttpResponse.addHeader(header);
    }

    public void addHeader(String name, String value) {
        this.closeableHttpResponse.addHeader(name, value);
    }

    public void setHeader(Header header) {
        this.closeableHttpResponse.setHeader(header);
    }

    public void setHeader(String name, String value) {
        this.closeableHttpResponse.setHeader(name, value);
    }

    public void setHeaders(Header[] headers) {
        this.closeableHttpResponse.setHeaders(headers);
    }

    public void removeHeader(Header header) {
        this.closeableHttpResponse.removeHeader(header);
    }

    public void removeHeaders(String name) {
        this.closeableHttpResponse.removeHeaders(name);
    }

    public HeaderIterator headerIterator() {
        return this.closeableHttpResponse.headerIterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.closeableHttpResponse.headerIterator(name);
    }

    @Deprecated
    public HttpParams getParams() {
        return this.closeableHttpResponse.getParams();
    }

    @Deprecated
    public void setParams(HttpParams params) {
        this.closeableHttpResponse.setParams(params);
    }

    @Override
    public <T> T readEntity(Class<T> responseType) {
        return this.readEntityUnChecked(responseType, responseType);
    }

    @Override
    public <T> T readEntity(TypeReference<T> responseType) {
        return (T)this.readEntityUnChecked(responseType.getRawType(), responseType.getType());
    }

    @Override
    public <T> T readEntityChecked(Class<T> responseType) throws IOException {
        return this.readEntityChecked(responseType, responseType);
    }

    @Override
    public <T> T readEntityChecked(TypeReference<T> responseType) throws IOException {
        return (T)this.readEntityChecked(responseType.getRawType(), responseType.getType());
    }

    private <T> T readEntityUnChecked(Class<T> type, Type genericType) {
        try {
            return this.readEntityChecked(type, genericType);
        }
        catch (ResponseBodyReaderException e) {
            throw new ResponseBodyProcessingException("Response deserialization failed. Cannot deserialize response to: [" + type + "].", e);
        }
        catch (IOException e) {
            throw new ResponseBodyProcessingException("Stream could not be created. Uri: [" + this.getURI() + "].", e);
        }
    }

    private <T> T readEntityChecked(Class<T> type, Type genericType) throws IOException {
        Object content;
        BasicResponseBodyReaderContext responseBodyReaderContext = new BasicResponseBodyReaderContext((HttpResponse)this, type, genericType);
        Optional<ResponseBodyReader> responseBodyReader = this.responseBodyReaderConfig.getResponseBodyReaders().stream().filter(rbr -> rbr.isReadable(responseBodyReaderContext)).findFirst();
        if (responseBodyReader.isPresent()) {
            content = responseBodyReader.get().read(responseBodyReaderContext);
        } else if (this.responseBodyReaderConfig.isUseDefaultReader() && this.responseBodyReaderConfig.getDefaultResponseBodyReader().isReadable(responseBodyReaderContext)) {
            content = this.responseBodyReaderConfig.getDefaultResponseBodyReader().read(responseBodyReaderContext);
        } else {
            String errMsg = this.hasEntity() ? "Can't found body reader for type: " + responseBodyReaderContext.getType() + " and content type: " + responseBodyReaderContext.getContentType() : "Can't found body reader for type: " + responseBodyReaderContext.getType() + " when http entity is null.";
            throw new ResponseBodyReaderNotFoundException(errMsg);
        }
        return content;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }
}

