-- BEGIN SECTION 1 --------------------------------------

create table EMPLOYEE
(
  ID        NUMBER not null,
  EMPLOYEE_NUMBER VARCHAR2(100),
  NAME      VARCHAR2(200),
  SURNAME   VARCHAR2(200),
  AGE	NUMBER not null,
  PRIMARY KEY (ID)
);

create table TEMP_TABLE 
(
  ID        NUMBER not null,
  NAME      VARCHAR2(200)
);

-- END SECTION 1 ----------------------------------------


-- BEGIN SECTION 2 --------------------------------------

-- Create table
create table PEOPLE
(
  id          number not null,
  firstname        varchar2(100),
  lastname     varchar2(100),
  birthdate timestamp(6),
  deathdate date,
  firstblob	BLOB ,
  secondblob BLOB, 
  firstclob CLOB
);

alter table PEOPLE  add constraint IDX_PEOPLE primary key (ID);

create sequence SEQ_PEOPLE
start with 1
increment by 1;

-- Create table
create table BLOBCLOB
(
  id          number not null,
  blob	BLOB ,
  clob CLOB
);

alter table BLOBCLOB add constraint IDX_BLOBCLOB primary key (ID);

create sequence SEQ_BLOBCLOB
start with 1
increment by 1;
-- END SECTION 2 ----------------------------------------


-- BEGIN SECTION 3 --------------------------------------

-- Create table
create table AUTHORS
(
  id          number not null,
  firstname        varchar2(100),
  lastname     varchar2(100),
  birthdate timestamp(6),
  PRIMARY KEY (ID)
);
  
  -- Create sequence 
create sequence SEQ_AUTHORS
start with 1
increment by 1;


-- Create table
create table PUBLICATIONS
(
  ID                NUMBER not null,
  IDAUTHOR	NUMBER not null,
  TITLE            VARCHAR2(200),
  PUBLICATIONDATE DATE,
  PRIMARY KEY (ID)
);

ALTER TABLE PUBLICATIONS ADD FOREIGN KEY (IDAUTHOR) REFERENCES AUTHORS (ID) on delete cascade;
  
  -- Create sequence 
create sequence SEQ_PUBLICATIONS
start with 1
increment by 1;  


-- Create table
create table ADDRESS
(
  ID                NUMBER not null,
  IDAUTHOR			NUMBER not null,
  ADDRESS            VARCHAR2(200),
  CITY            VARCHAR2(200),
  PRIMARY KEY (ID)
);

ALTER TABLE ADDRESS ADD FOREIGN KEY (IDAUTHOR) REFERENCES AUTHORS (ID) on delete cascade;

  -- Create sequence 
create sequence SEQ_ADDRESS
start with 1
increment by 1;  
-- END SECTION 3 ----------------------------------------


-- BEGIN SECTION 4 --------------------------------------
-- END SECTION 4 ----------------------------------------

