-- BEGIN SECTION 1 --------------------------------------
create table EMPLOYEE
(
  ID        BIGINT not null,
  EMPLOYEE_NUMBER VARCHAR(100),
  NAME      VARCHAR(200),
  SURNAME   VARCHAR(200),
  AGE	NUMERIC not null,
  PRIMARY KEY (ID)
);

create table TEMP_TABLE 
(
  ID        BIGINT not null,
  NAME      VARCHAR(200)
);

-- END SECTION 1 ----------------------------------------


-- BEGIN SECTION 2 --------------------------------------
-- Create table
create table PEOPLE
(
  ID          numeric not null,
  firstname        varchar(100),
  lastname     varchar(100),
  birthdate timestamp,
  deathdate date,
  firstblob	BLOB ,
  secondblob BLOB, 
  firstclob CLOB
);

alter table PEOPLE  add constraint IDX_PEOPLE primary key (ID);

create sequence SEQ_PEOPLE
start with 1
increment by 1;

-- Create table
create table BLOBCLOB
(
  id          numeric not null,
  blob	BLOB ,
  clob CLOB
);

alter table BLOBCLOB add constraint IDX_BLOBCLOB primary key (ID);

create sequence SEQ_BLOBCLOB
start with 1
increment by 1;
-- END SECTION 2 ----------------------------------------


-- BEGIN SECTION 3 --------------------------------------
-- Create table
create table AUTHORS
(
  id          numeric not null,
  firstname        varchar(100),
  lastname     varchar(100),
  birthdate timestamp,
  PRIMARY KEY (ID)
);
  
-- Create sequence 
create sequence SEQ_AUTHORS 
start with 1 
increment by 1;


-- Create table
create table PUBLICATIONS
(
  ID                NUMERIC not null,
  IDAUTHOR	NUMERIC not null,
  TITLE            VARCHAR(200),
  PUBLICATIONDATE DATE,
  PRIMARY KEY (ID)
);

ALTER TABLE PUBLICATIONS ADD FOREIGN KEY (IDAUTHOR) REFERENCES AUTHORS (ID) on delete cascade;
  
-- Create sequence 
create sequence SEQ_PUBLICATIONS
start with 1
increment by 1;  


-- Create table
create table ADDRESS
(
  ID                NUMERIC not null,
  IDAUTHOR			NUMERIC not null,
  ADDRESS            VARCHAR(200),
  CITY            VARCHAR(200),
  PRIMARY KEY (ID)
);

ALTER TABLE ADDRESS ADD FOREIGN KEY (IDAUTHOR) REFERENCES AUTHORS (ID) on delete cascade;

-- Create sequence 
create sequence SEQ_ADDRESS
start with 1
increment by 1;  
-- END SECTION 3 ----------------------------------------


-- BEGIN SECTION 4 --------------------------------------
-- Create schema 
create schema ZOO;

-- Create table
create table ZOO.PEOPLE
(
  id          numeric not null,
  firstname        varchar(100),
  lastname     varchar(100),
  birthdate timestamp,
  deathdate date,
  firstblob	BLOB ,
  secondblob BLOB, 
  firstclob CLOB
);

alter table ZOO.PEOPLE  add constraint ZOO_IDX_PEOPLE primary key (ID);

create sequence ZOO_SEQ_PEOPLE
start with 1
increment by 1;
-- END SECTION 4 ----------------------------------------


-- BEGIN SECTION 5 --------------------------------------

-- Create table with autogenerated pk
create table AUTO_ID
(
  ID int GENERATED BY DEFAULT AS IDENTITY (start with 100),
  VALUE varchar(100),
  PRIMARY KEY (ID)
);

-- END SECTION 5 ----------------------------------------


-- BEGIN SECTION 6 --------------------------------------
-- tables to test the @VERSION annotation

create table DATA_VERSION_INT
(
  ID int GENERATED BY DEFAULT AS IDENTITY (start with 100),
  DATA varchar(100),
  VERSION NUMERIC,
  PRIMARY KEY (ID)
);

create table DATA_VERSION_TIMESTAMP
(
  ID int GENERATED BY DEFAULT AS IDENTITY (start with 100),
  DATA varchar(100),
  VERSION timestamp,
  PRIMARY KEY (ID)
);

-- END SECTION 6 ----------------------------------------


-- BEGIN SECTION 7 --------------------------------------
-- tables to test queries using WrapperTypes

create table WRAPPER_TYPE_TABLE
(
  ID int GENERATED BY DEFAULT AS IDENTITY (start with 100),
  START_DATE timestamp,
  NOW timestamp,
  END_DATE timestamp,
  VALID numeric(1)
);

-- END SECTION 7 ----------------------------------------
