package com.jpattern.orm.test;

import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/**
 * Ignore a test if the related DB is not available
 * 
 * @author ufo
 * 
 */
public class SpringSkipTestRunner extends SpringJUnit4ClassRunner {

	private boolean init = true;
	private boolean isTestEnabled = true;

	public SpringSkipTestRunner(Class<?> clazz) throws InitializationError {
		super(clazz);
	}

	@Override
	public void run(RunNotifier notifier) {
		init();
		if (!isTestEnabled) {
			notifier.fireTestIgnored(getDescription());
			return;
		}
		super.run(notifier);
	}

	private void init() {
		if (init) {
			ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(
					IJpOrmTestsConstants.SPRING_TEST_ENABLER_XML_FILE);
			isTestEnabled = context.getBean(SpringSkipTestEnabler.class)
					.isTestEnabled();
			context.close();
			init = false;
		}
	}
}
