/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.log4j;

import com.jamonapi.JAMonBufferListener;
import com.jamonapi.JAMonListener;
import com.jamonapi.MonKey;
import com.jamonapi.Monitor;
import com.jamonapi.log4j.Log4jMonKey;
import com.jamonapi.utils.BufferList;
import com.jamonapi.utils.Misc;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jBufferListener
extends JAMonBufferListener {
    private boolean isLog4jMonKey = false;
    private static final String[] LOG4J_HEADER = new String[]{"LoggerName", "Level", "ThreadName", "FormattedMessage", "Date", "Exception"};

    public Log4jBufferListener() {
        super("Log4jBufferListener");
    }

    public Log4jBufferListener(String name) {
        super(name);
    }

    public Log4jBufferListener(String name, BufferList list) {
        super(name, list);
    }

    private Log4jBufferListener(String name, BufferList list, boolean isLog4jMonKey) {
        this(name, list);
        this.isLog4jMonKey = isLog4jMonKey;
    }

    public void processEvent(Monitor mon) {
        MonKey monKey = mon.getMonKey();
        if (monKey instanceof Log4jMonKey && !this.isLog4jMonKey) {
            this.isLog4jMonKey = true;
        }
        if (this.isLog4jMonKey) {
            Log4jMonKey key = (Log4jMonKey)monKey;
            this.getBufferList().addRow(this.toArray(key.getLoggingEvent(), mon));
        } else {
            super.processEvent(mon);
        }
    }

    protected Object[] toArray(LoggingEvent event, Monitor mon) {
        return new Object[]{event.getLoggerName(), event.getLevel().toString(), event.getThreadName(), mon.getMonKey().getDetails(), mon.getLastAccess(), event.getThrowableInformation() == null || event.getThrowableInformation().getThrowable() == null ? "" : Misc.getExceptionTrace(event.getThrowableInformation().getThrowable())};
    }

    protected String[] getDefaultHeader() {
        return LOG4J_HEADER;
    }

    public JAMonListener copy() {
        return new Log4jBufferListener(this.getName(), this.getBufferList().copy(), this.isLog4jMonKey);
    }

    public String[] getHeader() {
        if (this.isLog4jMonKey) {
            return this.getDefaultHeader();
        }
        return this.getBufferList().getHeader();
    }
}

