/*
 * Decompiled with CFR 0.152.
 */
package com.jamierf.rxtx;

import com.jamierf.rxtx.UnsupportedArchitectureException;
import com.jamierf.rxtx.UnsupportedOperatingSystemException;
import gnu.io.RXTXVersion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RXTXLoader {
    private static final Logger LOG = LoggerFactory.getLogger(RXTXLoader.class);
    private static final Pattern CPU_INFO_MODEL_INFO = Pattern.compile("model name\\s+:\\s+(.*)");
    private static final File CPU_INFO_FILE = new File("/proc/cpuinfo");

    public static void load() throws IOException {
        RXTXLoader.load(OperatingSystem.get(), Architecture.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(OperatingSystem os, Architecture arch) throws IOException {
        File tempDir = RXTXLoader.createTempDirectory();
        InputStream source = RXTXLoader.openResource(os, arch);
        if (source == null) {
            throw new IllegalStateException(String.format("Unable to find resource for %s %s", new Object[]{arch, os}));
        }
        File target = new File(tempDir, os.getLibPath());
        LOG.debug("Loading RXTX library for {} {}", (Object)arch, (Object)os);
        try {
            FileUtils.copyInputStreamToFile((InputStream)source, (File)target);
            RXTXLoader.addDirToLoadPath(tempDir);
        }
        finally {
            source.close();
        }
        String version = RXTXVersion.nativeGetVersion();
        LOG.info("Loaded RXTX native library {} for {} {}", new Object[]{version, arch, os});
    }

    private static InputStream openResource(OperatingSystem os, Architecture arch) throws IOException {
        String path = String.format("%s/%s/%s", os.getName(), arch.getName(), os.getLibPath());
        LOG.trace("Loading native library from {}", (Object)path);
        return RXTXLoader.class.getResourceAsStream(path);
    }

    private static File createTempDirectory() {
        File tempDir = new File(FileUtils.getTempDirectory(), "rxtx-loader");
        if (!tempDir.exists()) {
            tempDir.mkdir();
        }
        return tempDir;
    }

    private static void addDirToLoadPath(File dir) throws IOException {
        String path = dir.getPath();
        try {
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            String[] existingPaths = (String[])field.get(null);
            HashSet<String> newPaths = new HashSet<String>(existingPaths.length + 1);
            newPaths.addAll(Arrays.asList(existingPaths));
            if (newPaths.contains(path)) {
                return;
            }
            newPaths.add(path);
            field.set(null, newPaths.toArray(new String[newPaths.size()]));
            field.setAccessible(accessible);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failed to get permissions to set library path", e);
        }
        catch (NoSuchFieldException e) {
            throw new IOException("Failed to get field handle to set library path", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Architecture {
        X86_64("amd64", "x86_64"),
        X86("i386", "x86"),
        ARMv5("ARMv5"),
        ARMv6("ARMv6"),
        ARMv7("ARMv7"),
        ARM("arm");

        private final String[] keys;

        public static Architecture get() {
            String name = System.getProperty("os.arch");
            Architecture arch = Architecture.fromString(name);
            if (arch == ARM) {
                try {
                    if (CPU_INFO_FILE.exists()) {
                        String cpuInfo = FileUtils.readFileToString((File)CPU_INFO_FILE);
                        Matcher matcher = CPU_INFO_MODEL_INFO.matcher(cpuInfo);
                        if (matcher.find()) {
                            String modelInfo = matcher.group(1).trim();
                            return Architecture.fromString(modelInfo);
                        }
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to read {}", (Object)CPU_INFO_FILE.getAbsolutePath());
                }
                catch (UnsupportedArchitectureException e) {
                    LOG.debug("Unable to find architecture from {}", (Object)CPU_INFO_FILE.getName());
                }
            }
            return arch;
        }

        public static Architecture fromString(String name) {
            for (Architecture arch : Architecture.values()) {
                for (String key : arch.keys) {
                    if (!name.toLowerCase().contains(key.toLowerCase())) continue;
                    LOG.debug("Detected OS as {} ({})", (Object)arch, (Object)name);
                    return arch;
                }
            }
            throw new UnsupportedArchitectureException(name);
        }

        private Architecture(String ... keys) {
            this.keys = keys;
        }

        public String getName() {
            return this.name().toLowerCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperatingSystem {
        WINDOWS("Windows", "rxtxSerial.dll"),
        LINUX("Linux", "librxtxSerial.so"),
        MAC_OSX("Mac OS X", "librxtxSerial.jnilib");

        private final String key;
        private final String libPath;

        public static OperatingSystem get() {
            String name = System.getProperty("os.name");
            return OperatingSystem.fromString(name);
        }

        public static OperatingSystem fromString(String name) {
            for (OperatingSystem os : OperatingSystem.values()) {
                if (!name.toLowerCase().contains(os.key.toLowerCase())) continue;
                LOG.debug("Detected OS as {} ({})", (Object)os, (Object)name);
                return os;
            }
            throw new UnsupportedOperatingSystemException(name);
        }

        private OperatingSystem(String key, String libPath) {
            this.key = key;
            this.libPath = libPath;
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        public String getLibPath() {
            return this.libPath;
        }
    }
}

