/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.css.impl;

import com.itextpdf.io.util.DecimalFormatUtil;
import com.itextpdf.styledxmlparser.css.resolve.CssInheritance;
import com.itextpdf.styledxmlparser.css.resolve.CssPropertyMerger;
import com.itextpdf.styledxmlparser.css.resolve.IStyleInheritance;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.css.impl.SvgAttributeInheritance;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StyleResolverUtil {
    private Set<IStyleInheritance> inheritanceRules = new HashSet<IStyleInheritance>();
    private static final List<String> fontSizeDependentPercentage = new ArrayList<String>(2);

    public StyleResolverUtil() {
        this.inheritanceRules.add((IStyleInheritance)new CssInheritance());
        this.inheritanceRules.add(new SvgAttributeInheritance());
    }

    public void mergeParentStyleDeclaration(Map<String, String> styles, String styleProperty, String parentPropValue, String parentFontSizeString) {
        String childPropValue = styles.get(styleProperty);
        if (childPropValue == null && this.checkInheritance(styleProperty) || "inherit".equals(childPropValue)) {
            if (StyleResolverUtil.valueIsOfMeasurement(parentPropValue, "em") || StyleResolverUtil.valueIsOfMeasurement(parentPropValue, "ex") || StyleResolverUtil.valueIsOfMeasurement(parentPropValue, "%") && fontSizeDependentPercentage.contains(styleProperty)) {
                float absoluteParentFontSize = CssUtils.parseAbsoluteLength((String)parentFontSizeString);
                styles.put(styleProperty, DecimalFormatUtil.formatNumber((double)CssUtils.parseRelativeValue((String)parentPropValue, (float)absoluteParentFontSize), (String)"0.####") + "pt");
            } else {
                styles.put(styleProperty, parentPropValue);
            }
        } else if ("text-decoration".equals(styleProperty) && !"inline-block".equals(styles.get("display"))) {
            styles.put(styleProperty, CssPropertyMerger.mergeTextDecoration((String)childPropValue, (String)parentPropValue));
        }
    }

    private boolean checkInheritance(String styleProperty) {
        for (IStyleInheritance inheritanceRule : this.inheritanceRules) {
            if (!inheritanceRule.isInheritable(styleProperty)) continue;
            return true;
        }
        return false;
    }

    private static boolean valueIsOfMeasurement(String value, String measurement) {
        if (value == null) {
            return false;
        }
        return value.endsWith(measurement) && CssUtils.isNumericValue((String)value.substring(0, value.length() - measurement.length()).trim());
    }

    static {
        fontSizeDependentPercentage.add("font-size");
        fontSizeDependentPercentage.add("line-height");
    }
}

