/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.path.impl;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.path.impl.AbstractPathShape;
import java.util.Arrays;

public class MoveTo
extends AbstractPathShape {
    static final int ARGUMENT_SIZE = 2;

    public MoveTo() {
        this(false);
    }

    public MoveTo(boolean relative) {
        super(relative);
    }

    @Override
    public void draw(PdfCanvas canvas) {
        float x = CssUtils.parseAbsoluteLength((String)this.coordinates[0]);
        float y = CssUtils.parseAbsoluteLength((String)this.coordinates[1]);
        canvas.moveTo((double)x, (double)y);
    }

    @Override
    public void setCoordinates(String[] inputCoordinates, Point startPoint) {
        if (inputCoordinates.length != 2) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"(x y)+ parameters are expected for moveTo operator. Got: {0}", (Object[])new Object[]{Arrays.toString(this.coordinates)}));
        }
        this.coordinates = new String[]{inputCoordinates[0], inputCoordinates[1]};
        if (this.isRelative()) {
            this.coordinates = this.copier.makeCoordinatesAbsolute(this.coordinates, new double[]{startPoint.x, startPoint.y});
        }
    }
}

