/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.barcodes;

import com.itextpdf.barcodes.Barcode1D;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodeMSI
extends Barcode1D {
    private static final String CHARS = "0123456789";
    private static final byte[] BARS_START = new byte[]{1, 1, 0};
    private static final byte[] BARS_END = new byte[]{1, 0, 0, 1};
    private static final byte[][] BARS = new byte[][]{{1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0}, {1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0}, {1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0}, {1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0}, {1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0}, {1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0}, {1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0}, {1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0}, {1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0}, {1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0}};
    private static final int BARS_PER_CHARACTER = 12;

    protected BarcodeMSI(PdfDocument document) {
        super(document);
        this.x = 0.8f;
        this.n = 2.0f;
        this.font = document.getDefaultFont();
        this.baseline = this.size = 8.0f;
        this.barHeight = this.size * 3.0f;
        this.generateChecksum = false;
        this.checksumText = false;
    }

    @Override
    public Rectangle getBarcodeSize() {
        float fontX = 0.0f;
        float fontY = 0.0f;
        String fCode = this.code;
        if (this.font != null) {
            fontY = this.baseline > 0.0f ? this.baseline - this.getDescender() : -this.baseline + this.size;
            String fullCode = this.code;
            fontX = this.font.getWidth(this.altText != null ? this.altText : fullCode, this.size);
        }
        int len = fCode.length() + 2;
        if (this.generateChecksum) {
            ++len;
        }
        float fullWidth = (float)len * (6.0f * this.x + 3.0f * this.x * this.n) + (float)(len - 1) * this.x;
        fullWidth = Math.max(fullWidth, fontX);
        float fullHeight = this.barHeight + fontY;
        return new Rectangle(fullWidth, fullHeight);
    }

    @Override
    public Rectangle placeBarcode(PdfCanvas canvas, com.itextpdf.kernel.colors.Color barColor, com.itextpdf.kernel.colors.Color textColor) {
        String fullCode = this.code;
        if (this.checksumText) {
            fullCode = fullCode + Integer.toString(BarcodeMSI.getChecksum(this.code));
        }
        float fontX = 0.0f;
        if (this.font != null) {
            String var10001 = this.altText != null ? this.altText : fullCode;
            fullCode = this.altText != null ? this.altText : fullCode;
            fontX = this.font.getWidth(var10001, this.size);
        }
        String bCode = this.code;
        if (this.generateChecksum) {
            bCode = bCode + BarcodeMSI.getChecksum(bCode);
        }
        int idx = bCode.length();
        float fullWidth = (float)((idx + 2) * 11) * this.x + 2.0f * this.x;
        float barStartX = 0.0f;
        float textStartX = 0.0f;
        switch (this.textAlignment) {
            case 1: {
                break;
            }
            case 2: {
                if (fontX > fullWidth) {
                    barStartX = fontX - fullWidth;
                    break;
                }
                textStartX = fullWidth - fontX;
                break;
            }
            default: {
                if (fontX > fullWidth) {
                    barStartX = (fontX - fullWidth) / 2.0f;
                    break;
                }
                textStartX = (fullWidth - fontX) / 2.0f;
            }
        }
        float barStartY = 0.0f;
        float textStartY = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                textStartY = this.barHeight - this.baseline;
            } else {
                textStartY = -this.getDescender();
                barStartY = textStartY + this.baseline;
            }
        }
        byte[] bars = BarcodeMSI.getBarsMSI(bCode);
        if (barColor != null) {
            canvas.setFillColor(barColor);
        }
        for (int k = 0; k < bars.length; ++k) {
            float w = (float)bars[k] * this.x;
            if (bars[k] == 1) {
                canvas.rectangle((double)barStartX, (double)barStartY, (double)(w - this.inkSpreading), (double)this.barHeight);
            }
            barStartX += this.x;
        }
        canvas.fill();
        if (this.font != null) {
            if (textColor != null) {
                canvas.setFillColor(textColor);
            }
            canvas.beginText();
            canvas.setFontAndSize(this.font, this.size);
            canvas.setTextMatrix(textStartX, textStartY);
            canvas.showText(fullCode);
            canvas.endText();
        }
        return this.getBarcodeSize();
    }

    @Override
    public Image createAwtImage(Color foreground, Color background) {
        int foregroundColor = foreground == null ? this.DEFAULT_BAR_FOREGROUND_COLOR.getRGB() : foreground.getRGB();
        int backgroundColor = background == null ? this.DEFAULT_BAR_BACKGROUND_COLOR.getRGB() : background.getRGB();
        Canvas canvas = new Canvas();
        String bCode = this.code;
        if (this.generateChecksum) {
            bCode = bCode + Integer.toString(BarcodeMSI.getChecksum(this.code));
        }
        byte[] bars = BarcodeMSI.getBarsMSI(bCode);
        int fullWidth = bars.length;
        int fullHeight = (int)this.barHeight;
        int[] pix = new int[fullWidth * fullHeight];
        for (int x = 0; x < bars.length; ++x) {
            int color = bars[x] == 1 ? foregroundColor : backgroundColor;
            for (int y = 0; y < fullHeight; ++y) {
                int currentPixel = x + y * fullWidth;
                pix[currentPixel] = color;
            }
        }
        return canvas.createImage(new MemoryImageSource(fullWidth, fullHeight, pix, 0, fullWidth));
    }

    public static byte[] getBarsMSI(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Valid code required to generate MSI barcode.");
        }
        byte[] bars = new byte[text.length() * 12 + 7];
        System.arraycopy(BARS_START, 0, bars, 0, 3);
        for (int x = 0; x < text.length(); ++x) {
            char ch = text.charAt(x);
            int idx = CHARS.indexOf(ch);
            if (idx < 0) {
                throw new IllegalArgumentException("The character " + text.charAt(x) + " is illegal in MSI bar codes.");
            }
            System.arraycopy(BARS[idx], 0, bars, 3 + x * 12, 12);
        }
        System.arraycopy(BARS_END, 0, bars, bars.length - 4, 4);
        return bars;
    }

    public static int getChecksum(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Valid code required to generate checksum for MSI barcode");
        }
        int[] digits = new int[text.length()];
        for (int x = 0; x < text.length(); ++x) {
            digits[x] = text.charAt(x) - 48;
            if (digits[x] >= 0 && digits[x] <= 9) continue;
            throw new IllegalArgumentException("The character " + text.charAt(x) + " is illegal in MSI bar codes.");
        }
        int sum = 0;
        int length = digits.length;
        for (int i = 0; i < length; ++i) {
            int digit = digits[length - i - 1];
            if (i % 2 == 0) {
                digit *= 2;
            }
            sum += digit > 9 ? digit - 9 : digit;
        }
        return sum * 9 % 10;
    }
}

