/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.xfdf;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.utils.XmlProcessorCreator;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

final class XfdfFileUtils {
    private XfdfFileUtils() {
    }

    static Document createNewXfdfDocument() {
        try {
            DocumentBuilder db = XmlProcessorCreator.createSafeDocumentBuilder((boolean)false, (boolean)false);
            return db.newDocument();
        }
        catch (Exception e) {
            throw new PdfException(e.getMessage(), (Throwable)e);
        }
    }

    static Document createXfdfDocumentFromStream(InputStream inputStream) {
        try {
            DocumentBuilder db = XmlProcessorCreator.createSafeDocumentBuilder((boolean)false, (boolean)false);
            return db.parse(inputStream);
        }
        catch (Exception e) {
            throw new PdfException(e.getMessage(), (Throwable)e);
        }
    }

    static void saveXfdfDocumentToFile(Document document, OutputStream outputStream) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource domSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStream);
        transformer.transform(domSource, streamResult);
    }
}

