/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.junit4;

import com.intuit.karate.CallContext;
import com.intuit.karate.FileUtils;
import com.intuit.karate.cucumber.DummyFormatter;
import com.intuit.karate.cucumber.DummyReporter;
import com.intuit.karate.cucumber.KarateFeature;
import com.intuit.karate.cucumber.KarateHtmlReporter;
import com.intuit.karate.cucumber.KarateReporter;
import com.intuit.karate.cucumber.KarateRuntime;
import com.intuit.karate.cucumber.KarateRuntimeOptions;
import com.intuit.karate.junit4.KarateFeatureRunner;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.junit.FeatureRunner;
import cucumber.runtime.junit.JUnitOptions;
import cucumber.runtime.junit.JUnitReporter;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.Step;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Karate
extends ParentRunner<FeatureRunner> {
    private static final Logger logger = LoggerFactory.getLogger(Karate.class);
    private final List<FeatureRunner> children;
    private final JUnitReporter reporter;
    private final KarateHtmlReporter htmlReporter;
    private final Map<Integer, KarateFeatureRunner> featureMap;

    public Karate(Class clazz) throws InitializationError, IOException {
        super(clazz);
        List testMethods = this.getTestClass().getAnnotatedMethods(Test.class);
        if (!testMethods.isEmpty()) {
            logger.warn("WARNING: there are methods annotated with '@Test', they will NOT be run when using '@RunWith(Karate.class)'");
        }
        KarateRuntimeOptions kro = new KarateRuntimeOptions(clazz);
        RuntimeOptions ro = kro.getRuntimeOptions();
        JUnitOptions junitOptions = new JUnitOptions(ro.getJunitOptions());
        this.htmlReporter = new KarateHtmlReporter((Reporter)new DummyReporter(), (Formatter)new DummyFormatter());
        this.reporter = new JUnitReporter((Reporter)this.htmlReporter, (Formatter)this.htmlReporter, ro.isStrict(), junitOptions){
            final List<Step> steps;
            final List<Match> matches;
            {
                this.steps = new ArrayList<Step>();
                this.matches = new ArrayList<Match>();
            }

            public void startOfScenarioLifeCycle(Scenario scenario) {
                this.steps.clear();
                this.matches.clear();
                super.startOfScenarioLifeCycle(scenario);
            }

            public void step(Step step) {
                this.steps.add(step);
            }

            public void match(Match match) {
                this.matches.add(match);
            }

            public void result(Result result) {
                Step step = this.steps.remove(0);
                Match match = this.matches.remove(0);
                CallContext callContext = new CallContext(null, false);
                Karate.this.htmlReporter.karateStep(step, match, result, callContext, null);
                super.step(step);
                super.match(match);
                super.result(result);
            }

            public void eof() {
                try {
                    super.eof();
                }
                catch (Exception e) {
                    logger.warn("WARNING: cucumber native plugin / formatter failed: " + e.getMessage());
                }
            }
        };
        List list = KarateFeature.loadFeatures((KarateRuntimeOptions)kro);
        this.children = new ArrayList<FeatureRunner>(list.size());
        this.featureMap = new HashMap<Integer, KarateFeatureRunner>(list.size());
        logger.info("Karate version: {}", (Object)FileUtils.getKarateVersion());
        for (KarateFeature kf : list) {
            KarateRuntime kr = kf.getRuntime((KarateReporter)this.htmlReporter);
            FeatureRunner runner = new FeatureRunner(kf.getFeature(), (Runtime)kr, this.reporter);
            this.children.add(runner);
            this.featureMap.put(runner.hashCode(), new KarateFeatureRunner(kf, kr));
        }
    }

    public List<FeatureRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(FeatureRunner child) {
        return child.getDescription();
    }

    protected void runChild(FeatureRunner child, RunNotifier notifier) {
        KarateFeatureRunner kfr = this.featureMap.get(child.hashCode());
        KarateRuntime karateRuntime = kfr.runtime;
        this.htmlReporter.startKarateFeature(kfr.feature.getFeature());
        child.run(notifier);
        karateRuntime.afterFeature();
        karateRuntime.printSummary();
        this.htmlReporter.endKarateFeature();
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
        if (this.reporter != null) {
            this.reporter.done();
            this.reporter.close();
        }
    }
}

