/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http.apache;

import com.intuit.karate.FileUtils;
import com.intuit.karate.ScriptContext;
import com.intuit.karate.http.HttpRequestActual;
import com.intuit.karate.http.apache.ApacheHttpClient;
import com.intuit.karate.http.apache.LoggingEntityWrapper;
import com.intuit.karate.http.apache.LoggingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class RequestLoggingInterceptor
implements HttpRequestInterceptor {
    private final ScriptContext context;
    private final AtomicInteger counter;

    public RequestLoggingInterceptor(AtomicInteger counter, ScriptContext context) {
        this.context = context;
        this.counter = counter;
    }

    public void process(HttpRequest request, HttpContext httpContext) throws HttpException, IOException {
        HttpEntityEnclosingRequest entityRequest;
        HttpEntity entity;
        HttpRequestActual actual = new HttpRequestActual();
        int id = this.counter.incrementAndGet();
        String uri = (String)httpContext.getAttribute(ApacheHttpClient.URI_CONTEXT_KEY);
        String method = request.getRequestLine().getMethod();
        actual.setUri(uri);
        actual.setMethod(method);
        StringBuilder sb = new StringBuilder();
        sb.append('\n').append(id).append(" > ").append(method).append(' ').append(uri).append('\n');
        LoggingUtils.logHeaders(sb, id, '>', request, actual);
        if (request instanceof HttpEntityEnclosingRequest && LoggingUtils.isPrintable(entity = (entityRequest = (HttpEntityEnclosingRequest)request).getEntity())) {
            LoggingEntityWrapper wrapper = new LoggingEntityWrapper(entity);
            if (this.context.logger.isDebugEnabled()) {
                String buffer = FileUtils.toString((InputStream)wrapper.getContent());
                sb.append(buffer).append('\n');
            }
            actual.setBody(wrapper.getBytes());
            entityRequest.setEntity((HttpEntity)wrapper);
        }
        this.context.setPrevRequest(actual);
        if (this.context.logger.isDebugEnabled()) {
            this.context.logger.debug(sb.toString());
        }
    }
}

