package com.intellifylearning.sensor.spi.simple;

import com.intellifylearning.metrics.Measurement;
import com.intellifylearning.metrics.NullMeasurement;
import com.intellifylearning.metrics.ReadingMeasurement;
import com.intellifylearning.sensor.spi.ReadingSensorSPI;

public class SimpleReadingSensorSPI implements ReadingSensorSPI {

    private boolean active = false;

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public Measurement newMeasurement() {
        if (active) {
            return new ReadingMeasurement();
        } else {
            return new NullMeasurement();
        }
    }
}
