package com.intellifylearning.sensor;

import com.intellifylearning.metrics.Measurement;
import com.intellifylearning.sensor.spi.ReadingSensorSPI;
import com.intellifylearning.sensor.spi.simple.SimpleReadingSensorSPI;

/**
 * @author pnayak
 *
 */
public class ReadingSensor implements Sensor {

    private ReadingSensorSPI sensorSPI;

    public ReadingSensor(ReadingSensorSPI sensorSPI) {
        super();
        this.sensorSPI = sensorSPI;
    }

    public static final ReadingSensor getNew() {
        ReadingSensorSPI sensorSPI = new SimpleReadingSensorSPI();
        return new ReadingSensor(sensorSPI);
    }

    @Override
    public void activate() {
        sensorSPI.activate();
    }

    @Override
    public void deactivate() {
        sensorSPI.deactivate();
    }

    @Override
    public Measurement newMeasurement() {
        return sensorSPI.newMeasurement();
    }
}
