/**
 *
 */
package com.intellifylearning.models;

import org.joda.time.DateTime;

/**
 * @author pnayak
 *
 */
public class IdentifyAgent extends BasePayload {

    private String action = "identifyAgent";

    private String entityId;
    private String type;
    private Traits traits;

    public IdentifyAgent(String entityId,
            String type,
            Traits traits,
            DateTime timestamp,
            Context context,
            Callback callback) {
        super();
        this.entityId = entityId;
        this.type = type;

        if (traits != null) {
            this.traits = traits;
        } else {
            this.traits = new Traits();
        }
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getEntityId() {
        return entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Traits getTraits() {
        return traits;
    }

    public void setTraits(Traits traits) {
        this.traits = traits;
    }
}
