package com.intellifylearning.models;

/**
 * Response callback from the server.
 */
public interface Callback {

    /**
     * Called when a response is received from the server after sending a Event
     *
     * @param success if successful
     * @param event event sent
     */
    void onResponse(boolean success,
            com.intellify.api.caliper.impl.events.Event event);

    /**
     * Called when a response is received from the server after describing a
     * Entity
     *
     * @param success if successful
     * @param entity entity sent
     */
    void onResponse(boolean success,
            com.intellify.api.caliper.impl.entities.Entity entity);
}
