package com.intellifylearning.models;

import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.joda.time.DateTime;

/**
 * The base model for for Track / Identify payload
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS, include = JsonTypeInfo.As.PROPERTY, property = "class")
// @JsonSubTypes({
// @JsonSubTypes.Type(value=Identify.class, name="Identify"),
// @JsonSubTypes.Type(value=Track.class, name="Track")})
public class BasePayload {

    private String userId;
    private Context context;
    private DateTime timestamp;

    private String apiKey;
    private String il_sensorId;
    private String il_correlationId;

    private transient Callback callback;

    public BasePayload() {
        super();
    }

    public BasePayload(String userId,
            DateTime timestamp,
            Context context,
            Callback callback) {

        this.userId = userId;
        this.timestamp = timestamp;
        this.context = context;

        this.callback = callback;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public DateTime getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(DateTime timestamp) {
        this.timestamp = timestamp;
    }

    public Context getContext() {
        return context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Callback getCallback() {
        return callback;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    /**
     * @return the apiKey
     */
    public String getApiKey() {
        return apiKey;
    }

    /**
     * @param apiKey
     *            the apiKey to set
     */
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    /**
     * @return the il_sensorId
     */
    public String getIl_sensorId() {
        return il_sensorId;
    }

    /**
     * @param il_sensorId
     *            the il_sensorId to set
     */
    public void setIl_sensorId(String il_sensorId) {
        this.il_sensorId = il_sensorId;
    }

    /**
     * @return the il_correlationId
     */
    public String getIl_correlationId() {
        return il_correlationId;
    }

    /**
     * @param il_correlationId
     *            the il_correlationId to set
     */
    public void setIl_correlationId(String il_correlationId) {
        this.il_correlationId = il_correlationId;
    }

}
