package com.intellifylearning.metrics;

import java.util.Date;

/**
 * @author pnayak
 */
public abstract class Measurement {

    public abstract Measurement forAction(Action action);

    public abstract Measurement withActionContext(ActionContext actionContext);

    public abstract Measurement withActivityContext(ActivityContext activityContext);

    public abstract Measurement withValue(String value);

    public abstract Measurement withValue(long value);

    public abstract Measurement withValue(double value);

    public abstract Measurement withValue(boolean value);

    public abstract Measurement atTime(Date time);

    // TODO - change to track()?
    public abstract void record();
}
