package com.intellifylearning.metrics;

import com.intellifylearning.metrics.models.Course;
import com.intellifylearning.metrics.models.User;
import com.intellifylearning.models.Context;

public class ActionContext extends Context {

    private String actorId;
    private String sessionId;
    private String courseId;

    /**
     * @return the actorId
     */
    public String getActorId() {
        return actorId;
    }

    /**
     * @param actorId
     *            the actorId to set
     */
    public void setActorId(String actorId) {
        this.actorId = actorId;
    }

    /**
     * @return the sessionId
     */
    public String getSessionId() {
        return sessionId;
    }

    /**
     * @param sessionId
     *            the sessionId to set
     */
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    /**
     * @return the courseId
     */
    public String getCourseId() {
        return courseId;
    }

    /**
     * @param courseId
     *            the courseId to set
     */
    public void setCourseId(String courseId) {
        this.courseId = courseId;
    }

    public static ActionContext create() {
        return new ActionContext();
    }

    public ActionContext withCourse(Course course) {
        setCourseId(course.getId());
        return this;
    }

    public ActionContext withActor(User user) {
        setActorId(user.getId());
        return this;
    }

}
