package com.intellifylearning.gson;

import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.intellify.api.caliper.impl.events.Event;
import com.intellifylearning.Constants;

/**
 * @author pnayak
 */
public class IntellifyEventSerializer extends JsonSerializer<Event> {

    private static final Logger logger = LoggerFactory
            .getLogger(Constants.LOGGER);

    private static final String CLASSNAME = "@class";
    private static final String INSTANCE = "@instance";

    @Override
    public void serialize(Event value, JsonGenerator jgen,
            SerializerProvider provider) throws IOException,
            JsonProcessingException {

        jgen.writeStartObject();
        JsonSerializer<Object> serializer = provider.findValueSerializer(
                Event.class, null);
        // this is basically your 'writeAllFields()'-method:
        serializer.unwrappingSerializer(null).serialize(value, jgen, provider);

        String className = value.getClass().getCanonicalName();
        jgen.writeObjectField(CLASSNAME, className);

        jgen.writeEndObject();

    }
}
