package com.intellifylearning.gson;

import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.intellify.api.caliper.impl.entities.Entity;
import com.intellifylearning.Constants;

/**
 * @author pnayak
 *
 */
public class IntellifyEntitySerializer extends JsonSerializer<Entity> {

    private static final Logger logger = LoggerFactory
            .getLogger(Constants.LOGGER);

    private static final String CLASSNAME = "iType";
    private static final String INSTANCE = "@instance";

    @Override
    public void serialize(Entity value, JsonGenerator jgen,
            SerializerProvider provider) throws IOException,
            JsonProcessingException {

        logger.debug("%%%% Custom Serialization in progress");

        jgen.writeStartObject();
        JsonSerializer<Object> serializer = provider.findValueSerializer(
                Entity.class, null);
        // this is basically your 'writeAllFields()'-method:
        serializer.unwrappingSerializer(null).serialize(value, jgen, provider);

        String className = value.getClass().getCanonicalName();
        logger.debug("%%%% About to write custom property " + CLASSNAME + " = " + className);
        jgen.writeObjectField(CLASSNAME, className);

        jgen.writeEndObject();

    }
}
