package com.intellifylearning.gson;

import java.lang.reflect.Type;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.intellifylearning.models.BasePayload;

/**
 * @author pnayak
 *
 */
public class BasePayloadSerializer implements JsonSerializer<BasePayload> {

    private static final String CLASSNAME = "class";
    private static final String INSTANCE = "@instance";

    @Override
    public JsonElement serialize(BasePayload src, Type typeofSource,
            JsonSerializationContext context) {

        // JsonObject retValue = new JsonObject();
        String className = src.getClass().getCanonicalName();
        JsonElement elem = context.serialize(src);
        JsonObject retValue = elem.getAsJsonObject();
        retValue.addProperty(CLASSNAME, "class " + className);
        return retValue;
    }
}
