package com.intellifylearning.flush;

import java.util.List;

import com.intellify.api.caliper.CaliperEntity;
import com.intellify.api.caliper.impl.IntellifyBase;
import com.intellifylearning.models.Batch;
import com.intellifylearning.models.BatchIntellifyBase;

/**
 * A Factory that creates Batch objects
 *
 */
public interface IBatchFactory {

    /**
     * Creates a batch model around a list of items
     *
     * @param batch
     *            A list of items that represents the batch
     * @return {@link Batch}
     */
    Batch create(List<CaliperEntity> batch);

    BatchIntellifyBase createIntellifyBaseBatch(List<IntellifyBase> batch);

}
