/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.ing.data.cassandra.jdbc.ByteBufferUtil;
import com.ing.data.cassandra.jdbc.codec.AbstractCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

public class BigintToBigDecimalCodec
extends AbstractCodec<BigDecimal>
implements TypeCodec<BigDecimal> {
    @NonNull
    public GenericType<BigDecimal> getJavaType() {
        return GenericType.BIG_DECIMAL;
    }

    @NonNull
    public DataType getCqlType() {
        return DataTypes.BIGINT;
    }

    public ByteBuffer encode(BigDecimal value, @NonNull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        return ByteBufferUtil.bytes(value.longValue());
    }

    public BigDecimal decode(ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null) {
            return null;
        }
        long value = ByteBufferUtil.toLong(bytes.duplicate());
        return new BigDecimal(value);
    }

    @Override
    BigDecimal parseNonNull(@NonNull String value) {
        return BigDecimal.valueOf(Long.parseLong(value));
    }

    @Override
    String formatNonNull(@NonNull BigDecimal value) {
        return String.valueOf(value);
    }
}

