/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.WhatsAppAudioMessage;
import com.infobip.model.WhatsAppBulkMessage;
import com.infobip.model.WhatsAppBulkMessageInfo;
import com.infobip.model.WhatsAppBusinessInfoRequest;
import com.infobip.model.WhatsAppBusinessInfoResponse;
import com.infobip.model.WhatsAppContactsMessage;
import com.infobip.model.WhatsAppDocumentMessage;
import com.infobip.model.WhatsAppIdentityConfirmation;
import com.infobip.model.WhatsAppIdentityInfo;
import com.infobip.model.WhatsAppImageMessage;
import com.infobip.model.WhatsAppInteractiveButtonsMessage;
import com.infobip.model.WhatsAppInteractiveFlowMessage;
import com.infobip.model.WhatsAppInteractiveListMessage;
import com.infobip.model.WhatsAppInteractiveLocationRequestMessage;
import com.infobip.model.WhatsAppInteractiveMultiProductMessage;
import com.infobip.model.WhatsAppInteractiveOrderDetailsMessage;
import com.infobip.model.WhatsAppInteractiveOrderStatusMessage;
import com.infobip.model.WhatsAppInteractiveProductMessage;
import com.infobip.model.WhatsAppInteractiveUrlButtonMessage;
import com.infobip.model.WhatsAppLocationMessage;
import com.infobip.model.WhatsAppOtpRequest;
import com.infobip.model.WhatsAppPayment;
import com.infobip.model.WhatsAppPhoneNumberRequest;
import com.infobip.model.WhatsAppSenderQualityResponse;
import com.infobip.model.WhatsAppSenderRegistrationResponse;
import com.infobip.model.WhatsAppSingleMessageInfo;
import com.infobip.model.WhatsAppStickerMessage;
import com.infobip.model.WhatsAppTemplateApiResponse;
import com.infobip.model.WhatsAppTemplateEditPublicApiRequest;
import com.infobip.model.WhatsAppTemplatePublicApiRequest;
import com.infobip.model.WhatsAppTemplatesApiResponse;
import com.infobip.model.WhatsAppTextMessage;
import com.infobip.model.WhatsAppUrlDeletionRequest;
import com.infobip.model.WhatsAppVerifyCodeRequest;
import com.infobip.model.WhatsAppVideoMessage;
import java.io.File;
import java.util.List;
import java.util.Objects;
import okhttp3.Call;

public class WhatsAppApi {
    private final ApiClient apiClient;

    public WhatsAppApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition addWhatsappSenderDefinition(Long businessAccountId, WhatsAppPhoneNumberRequest whatsAppPhoneNumberRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/embedded-signup/registrations/business-account/{businessAccountId}/senders").body(whatsAppPhoneNumberRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (businessAccountId != null) {
            builder.addPathParameter(new Parameter("businessAccountId", businessAccountId));
        }
        return builder.build();
    }

    public AddWhatsappSenderRequest addWhatsappSender(Long businessAccountId, WhatsAppPhoneNumberRequest whatsAppPhoneNumberRequest) {
        return new AddWhatsappSenderRequest(businessAccountId, whatsAppPhoneNumberRequest);
    }

    private RequestDefinition confirmWhatsAppIdentityDefinition(String sender, String userNumber, WhatsAppIdentityConfirmation whatsAppIdentityConfirmation) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/whatsapp/1/{sender}/contacts/{userNumber}/identity").body(whatsAppIdentityConfirmation).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        if (userNumber != null) {
            builder.addPathParameter(new Parameter("userNumber", userNumber));
        }
        return builder.build();
    }

    public ConfirmWhatsAppIdentityRequest confirmWhatsAppIdentity(String sender, String userNumber, WhatsAppIdentityConfirmation whatsAppIdentityConfirmation) {
        return new ConfirmWhatsAppIdentityRequest(sender, userNumber, whatsAppIdentityConfirmation);
    }

    private RequestDefinition createWhatsAppTemplateDefinition(String sender, WhatsAppTemplatePublicApiRequest whatsAppTemplatePublicApiRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/2/senders/{sender}/templates").body(whatsAppTemplatePublicApiRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        return builder.build();
    }

    public CreateWhatsAppTemplateRequest createWhatsAppTemplate(String sender, WhatsAppTemplatePublicApiRequest whatsAppTemplatePublicApiRequest) {
        return new CreateWhatsAppTemplateRequest(sender, whatsAppTemplatePublicApiRequest);
    }

    private RequestDefinition deleteWhatsAppMediaDefinition(String sender, WhatsAppUrlDeletionRequest whatsAppUrlDeletionRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/whatsapp/1/senders/{sender}/media").body(whatsAppUrlDeletionRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        return builder.build();
    }

    public DeleteWhatsAppMediaRequest deleteWhatsAppMedia(String sender, WhatsAppUrlDeletionRequest whatsAppUrlDeletionRequest) {
        return new DeleteWhatsAppMediaRequest(sender, whatsAppUrlDeletionRequest);
    }

    private RequestDefinition deleteWhatsAppTemplateDefinition(String sender, String templateName) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/whatsapp/2/senders/{sender}/templates/{templateName}").requiresAuthentication(true).accept("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        if (templateName != null) {
            builder.addPathParameter(new Parameter("templateName", templateName));
        }
        return builder.build();
    }

    public DeleteWhatsAppTemplateRequest deleteWhatsAppTemplate(String sender, String templateName) {
        return new DeleteWhatsAppTemplateRequest(sender, templateName);
    }

    private RequestDefinition downloadWhatsAppInboundMediaDefinition(String sender, String mediaId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/whatsapp/1/senders/{sender}/media/{mediaId}").requiresAuthentication(true).accept("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        if (mediaId != null) {
            builder.addPathParameter(new Parameter("mediaId", mediaId));
        }
        return builder.build();
    }

    public DownloadWhatsAppInboundMediaRequest downloadWhatsAppInboundMedia(String sender, String mediaId) {
        return new DownloadWhatsAppInboundMediaRequest(sender, mediaId);
    }

    private RequestDefinition editWhatsappTemplateDefinition(String sender, String id, WhatsAppTemplateEditPublicApiRequest whatsAppTemplateEditPublicApiRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PATCH", "/whatsapp/2/senders/{sender}/templates/{id}").body(whatsAppTemplateEditPublicApiRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public EditWhatsappTemplateRequest editWhatsappTemplate(String sender, String id, WhatsAppTemplateEditPublicApiRequest whatsAppTemplateEditPublicApiRequest) {
        return new EditWhatsappTemplateRequest(sender, id, whatsAppTemplateEditPublicApiRequest);
    }

    private RequestDefinition getWhatsAppIdentityDefinition(String sender, String userNumber) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/whatsapp/1/{sender}/contacts/{userNumber}/identity").requiresAuthentication(true).accept("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        if (userNumber != null) {
            builder.addPathParameter(new Parameter("userNumber", userNumber));
        }
        return builder.build();
    }

    public GetWhatsAppIdentityRequest getWhatsAppIdentity(String sender, String userNumber) {
        return new GetWhatsAppIdentityRequest(sender, userNumber);
    }

    private RequestDefinition getWhatsAppMediaMetadataDefinition(String sender, String mediaId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("HEAD", "/whatsapp/1/senders/{sender}/media/{mediaId}").requiresAuthentication(true).accept("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        if (mediaId != null) {
            builder.addPathParameter(new Parameter("mediaId", mediaId));
        }
        return builder.build();
    }

    public GetWhatsAppMediaMetadataRequest getWhatsAppMediaMetadata(String sender, String mediaId) {
        return new GetWhatsAppMediaMetadataRequest(sender, mediaId);
    }

    private RequestDefinition getWhatsAppTemplatesDefinition(String sender) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/whatsapp/2/senders/{sender}/templates").requiresAuthentication(true).accept("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        return builder.build();
    }

    public GetWhatsAppTemplatesRequest getWhatsAppTemplates(String sender) {
        return new GetWhatsAppTemplatesRequest(sender);
    }

    private RequestDefinition getWhatsappBrazilPaymentStatusDefinition(String sender, String paymentId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/whatsapp/1/senders/{sender}/payments/br/{paymentId}").requiresAuthentication(true).accept("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        if (paymentId != null) {
            builder.addPathParameter(new Parameter("paymentId", paymentId));
        }
        return builder.build();
    }

    public GetWhatsappBrazilPaymentStatusRequest getWhatsappBrazilPaymentStatus(String sender, String paymentId) {
        return new GetWhatsappBrazilPaymentStatusRequest(sender, paymentId);
    }

    private RequestDefinition getWhatsappSenderBusinessInfoDefinition(String sender) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/whatsapp/1/senders/{sender}/business-info").requiresAuthentication(true).accept("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        return builder.build();
    }

    public GetWhatsappSenderBusinessInfoRequest getWhatsappSenderBusinessInfo(String sender) {
        return new GetWhatsappSenderBusinessInfoRequest(sender);
    }

    private RequestDefinition getWhatsappSenderBusinessLogoDefinition(String sender) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/whatsapp/1/senders/{sender}/business-info/logo").requiresAuthentication(true).accept("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        return builder.build();
    }

    public GetWhatsappSenderBusinessLogoRequest getWhatsappSenderBusinessLogo(String sender) {
        return new GetWhatsappSenderBusinessLogoRequest(sender);
    }

    private RequestDefinition getWhatsappSendersQualityDefinition(List<String> senders) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/whatsapp/1/senders/quality").requiresAuthentication(true).accept("application/json");
        if (senders != null) {
            for (String parameterItem : senders) {
                builder.addQueryParameter(new Parameter("senders", parameterItem));
            }
        }
        return builder.build();
    }

    public GetWhatsappSendersQualityRequest getWhatsappSendersQuality(List<String> senders) {
        return new GetWhatsappSendersQualityRequest(senders);
    }

    private RequestDefinition getWhatsappTemplateDefinition(String sender, String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/whatsapp/2/senders/{sender}/templates/{id}").requiresAuthentication(true).accept("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public GetWhatsappTemplateRequest getWhatsappTemplate(String sender, String id) {
        return new GetWhatsappTemplateRequest(sender, id);
    }

    private RequestDefinition getWhatsappUpiPaymentStatusDefinition(String sender, String paymentId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/whatsapp/1/senders/{sender}/payments/upi/{paymentId}").requiresAuthentication(true).accept("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        if (paymentId != null) {
            builder.addPathParameter(new Parameter("paymentId", paymentId));
        }
        return builder.build();
    }

    public GetWhatsappUpiPaymentStatusRequest getWhatsappUpiPaymentStatus(String sender, String paymentId) {
        return new GetWhatsappUpiPaymentStatusRequest(sender, paymentId);
    }

    private RequestDefinition getWhatsappUpiPayuPaymentStatusDefinition(String sender, String paymentId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/whatsapp/1/senders/{sender}/payments/upi/payu/{paymentId}").requiresAuthentication(true).accept("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        if (paymentId != null) {
            builder.addPathParameter(new Parameter("paymentId", paymentId));
        }
        return builder.build();
    }

    public GetWhatsappUpiPayuPaymentStatusRequest getWhatsappUpiPayuPaymentStatus(String sender, String paymentId) {
        return new GetWhatsappUpiPayuPaymentStatusRequest(sender, paymentId);
    }

    private RequestDefinition markWhatsAppMessageAsReadDefinition(String sender, String messageId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/senders/{sender}/message/{messageId}/read").requiresAuthentication(true).accept("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        if (messageId != null) {
            builder.addPathParameter(new Parameter("messageId", messageId));
        }
        return builder.build();
    }

    public MarkWhatsAppMessageAsReadRequest markWhatsAppMessageAsRead(String sender, String messageId) {
        return new MarkWhatsAppMessageAsReadRequest(sender, messageId);
    }

    private RequestDefinition retryWhatsappSenderVerificationDefinition(String sender, WhatsAppOtpRequest whatsAppOtpRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/whatsapp/1/embedded-signup/registrations/senders/{sender}/verification").body(whatsAppOtpRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        return builder.build();
    }

    public RetryWhatsappSenderVerificationRequest retryWhatsappSenderVerification(String sender, WhatsAppOtpRequest whatsAppOtpRequest) {
        return new RetryWhatsappSenderVerificationRequest(sender, whatsAppOtpRequest);
    }

    private RequestDefinition sendWhatsAppAudioMessageDefinition(WhatsAppAudioMessage whatsAppAudioMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/audio").body(whatsAppAudioMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsAppAudioMessageRequest sendWhatsAppAudioMessage(WhatsAppAudioMessage whatsAppAudioMessage) {
        return new SendWhatsAppAudioMessageRequest(whatsAppAudioMessage);
    }

    private RequestDefinition sendWhatsAppContactMessageDefinition(WhatsAppContactsMessage whatsAppContactsMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/contact").body(whatsAppContactsMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsAppContactMessageRequest sendWhatsAppContactMessage(WhatsAppContactsMessage whatsAppContactsMessage) {
        return new SendWhatsAppContactMessageRequest(whatsAppContactsMessage);
    }

    private RequestDefinition sendWhatsAppDocumentMessageDefinition(WhatsAppDocumentMessage whatsAppDocumentMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/document").body(whatsAppDocumentMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsAppDocumentMessageRequest sendWhatsAppDocumentMessage(WhatsAppDocumentMessage whatsAppDocumentMessage) {
        return new SendWhatsAppDocumentMessageRequest(whatsAppDocumentMessage);
    }

    private RequestDefinition sendWhatsAppImageMessageDefinition(WhatsAppImageMessage whatsAppImageMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/image").body(whatsAppImageMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsAppImageMessageRequest sendWhatsAppImageMessage(WhatsAppImageMessage whatsAppImageMessage) {
        return new SendWhatsAppImageMessageRequest(whatsAppImageMessage);
    }

    private RequestDefinition sendWhatsAppInteractiveButtonsMessageDefinition(WhatsAppInteractiveButtonsMessage whatsAppInteractiveButtonsMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/interactive/buttons").body(whatsAppInteractiveButtonsMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsAppInteractiveButtonsMessageRequest sendWhatsAppInteractiveButtonsMessage(WhatsAppInteractiveButtonsMessage whatsAppInteractiveButtonsMessage) {
        return new SendWhatsAppInteractiveButtonsMessageRequest(whatsAppInteractiveButtonsMessage);
    }

    private RequestDefinition sendWhatsAppInteractiveListMessageDefinition(WhatsAppInteractiveListMessage whatsAppInteractiveListMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/interactive/list").body(whatsAppInteractiveListMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsAppInteractiveListMessageRequest sendWhatsAppInteractiveListMessage(WhatsAppInteractiveListMessage whatsAppInteractiveListMessage) {
        return new SendWhatsAppInteractiveListMessageRequest(whatsAppInteractiveListMessage);
    }

    private RequestDefinition sendWhatsAppInteractiveMultiProductMessageDefinition(WhatsAppInteractiveMultiProductMessage whatsAppInteractiveMultiProductMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/interactive/multi-product").body(whatsAppInteractiveMultiProductMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsAppInteractiveMultiProductMessageRequest sendWhatsAppInteractiveMultiProductMessage(WhatsAppInteractiveMultiProductMessage whatsAppInteractiveMultiProductMessage) {
        return new SendWhatsAppInteractiveMultiProductMessageRequest(whatsAppInteractiveMultiProductMessage);
    }

    private RequestDefinition sendWhatsAppInteractiveProductMessageDefinition(WhatsAppInteractiveProductMessage whatsAppInteractiveProductMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/interactive/product").body(whatsAppInteractiveProductMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsAppInteractiveProductMessageRequest sendWhatsAppInteractiveProductMessage(WhatsAppInteractiveProductMessage whatsAppInteractiveProductMessage) {
        return new SendWhatsAppInteractiveProductMessageRequest(whatsAppInteractiveProductMessage);
    }

    private RequestDefinition sendWhatsAppLocationMessageDefinition(WhatsAppLocationMessage whatsAppLocationMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/location").body(whatsAppLocationMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsAppLocationMessageRequest sendWhatsAppLocationMessage(WhatsAppLocationMessage whatsAppLocationMessage) {
        return new SendWhatsAppLocationMessageRequest(whatsAppLocationMessage);
    }

    private RequestDefinition sendWhatsAppStickerMessageDefinition(WhatsAppStickerMessage whatsAppStickerMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/sticker").body(whatsAppStickerMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsAppStickerMessageRequest sendWhatsAppStickerMessage(WhatsAppStickerMessage whatsAppStickerMessage) {
        return new SendWhatsAppStickerMessageRequest(whatsAppStickerMessage);
    }

    private RequestDefinition sendWhatsAppTemplateMessageDefinition(WhatsAppBulkMessage whatsAppBulkMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/template").body(whatsAppBulkMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsAppTemplateMessageRequest sendWhatsAppTemplateMessage(WhatsAppBulkMessage whatsAppBulkMessage) {
        return new SendWhatsAppTemplateMessageRequest(whatsAppBulkMessage);
    }

    private RequestDefinition sendWhatsAppTextMessageDefinition(WhatsAppTextMessage whatsAppTextMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/text").body(whatsAppTextMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsAppTextMessageRequest sendWhatsAppTextMessage(WhatsAppTextMessage whatsAppTextMessage) {
        return new SendWhatsAppTextMessageRequest(whatsAppTextMessage);
    }

    private RequestDefinition sendWhatsAppVideoMessageDefinition(WhatsAppVideoMessage whatsAppVideoMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/video").body(whatsAppVideoMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsAppVideoMessageRequest sendWhatsAppVideoMessage(WhatsAppVideoMessage whatsAppVideoMessage) {
        return new SendWhatsAppVideoMessageRequest(whatsAppVideoMessage);
    }

    private RequestDefinition sendWhatsappInteractiveFlowMessageDefinition(WhatsAppInteractiveFlowMessage whatsAppInteractiveFlowMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/interactive/flow").body(whatsAppInteractiveFlowMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsappInteractiveFlowMessageRequest sendWhatsappInteractiveFlowMessage(WhatsAppInteractiveFlowMessage whatsAppInteractiveFlowMessage) {
        return new SendWhatsappInteractiveFlowMessageRequest(whatsAppInteractiveFlowMessage);
    }

    private RequestDefinition sendWhatsappInteractiveLocationRequestMessageDefinition(WhatsAppInteractiveLocationRequestMessage whatsAppInteractiveLocationRequestMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/interactive/location-request").body(whatsAppInteractiveLocationRequestMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsappInteractiveLocationRequestMessageRequest sendWhatsappInteractiveLocationRequestMessage(WhatsAppInteractiveLocationRequestMessage whatsAppInteractiveLocationRequestMessage) {
        return new SendWhatsappInteractiveLocationRequestMessageRequest(whatsAppInteractiveLocationRequestMessage);
    }

    private RequestDefinition sendWhatsappInteractiveOrderDetailsMessageDefinition(WhatsAppInteractiveOrderDetailsMessage whatsAppInteractiveOrderDetailsMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/interactive/order-details").body(whatsAppInteractiveOrderDetailsMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsappInteractiveOrderDetailsMessageRequest sendWhatsappInteractiveOrderDetailsMessage(WhatsAppInteractiveOrderDetailsMessage whatsAppInteractiveOrderDetailsMessage) {
        return new SendWhatsappInteractiveOrderDetailsMessageRequest(whatsAppInteractiveOrderDetailsMessage);
    }

    private RequestDefinition sendWhatsappInteractiveOrderStatusMessageDefinition(WhatsAppInteractiveOrderStatusMessage whatsAppInteractiveOrderStatusMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/interactive/order-status").body(whatsAppInteractiveOrderStatusMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsappInteractiveOrderStatusMessageRequest sendWhatsappInteractiveOrderStatusMessage(WhatsAppInteractiveOrderStatusMessage whatsAppInteractiveOrderStatusMessage) {
        return new SendWhatsappInteractiveOrderStatusMessageRequest(whatsAppInteractiveOrderStatusMessage);
    }

    private RequestDefinition sendWhatsappInteractiveUrlButtonMessageDefinition(WhatsAppInteractiveUrlButtonMessage whatsAppInteractiveUrlButtonMessage) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/message/interactive/url-button").body(whatsAppInteractiveUrlButtonMessage).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendWhatsappInteractiveUrlButtonMessageRequest sendWhatsappInteractiveUrlButtonMessage(WhatsAppInteractiveUrlButtonMessage whatsAppInteractiveUrlButtonMessage) {
        return new SendWhatsappInteractiveUrlButtonMessageRequest(whatsAppInteractiveUrlButtonMessage);
    }

    private RequestDefinition updateWhatsappSenderBusinessInfoDefinition(String sender, WhatsAppBusinessInfoRequest whatsAppBusinessInfoRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PATCH", "/whatsapp/1/senders/{sender}/business-info").body(whatsAppBusinessInfoRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        return builder.build();
    }

    public UpdateWhatsappSenderBusinessInfoRequest updateWhatsappSenderBusinessInfo(String sender, WhatsAppBusinessInfoRequest whatsAppBusinessInfoRequest) {
        return new UpdateWhatsappSenderBusinessInfoRequest(sender, whatsAppBusinessInfoRequest);
    }

    private RequestDefinition verifyWhatsappSenderDefinition(String sender, WhatsAppVerifyCodeRequest whatsAppVerifyCodeRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/whatsapp/1/embedded-signup/registrations/senders/{sender}/verification").body(whatsAppVerifyCodeRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (sender != null) {
            builder.addPathParameter(new Parameter("sender", sender));
        }
        return builder.build();
    }

    public VerifyWhatsappSenderRequest verifyWhatsappSender(String sender, WhatsAppVerifyCodeRequest whatsAppVerifyCodeRequest) {
        return new VerifyWhatsappSenderRequest(sender, whatsAppVerifyCodeRequest);
    }

    public class VerifyWhatsappSenderRequest {
        private final String sender;
        private final WhatsAppVerifyCodeRequest whatsAppVerifyCodeRequest;

        private VerifyWhatsappSenderRequest(String sender, WhatsAppVerifyCodeRequest whatsAppVerifyCodeRequest) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.whatsAppVerifyCodeRequest = Objects.requireNonNull(whatsAppVerifyCodeRequest, "The required parameter 'whatsAppVerifyCodeRequest' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition verifyWhatsappSenderDefinition = WhatsAppApi.this.verifyWhatsappSenderDefinition(this.sender, this.whatsAppVerifyCodeRequest);
            WhatsAppApi.this.apiClient.execute(verifyWhatsappSenderDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition verifyWhatsappSenderDefinition = WhatsAppApi.this.verifyWhatsappSenderDefinition(this.sender, this.whatsAppVerifyCodeRequest);
            return WhatsAppApi.this.apiClient.executeAsync(verifyWhatsappSenderDefinition, callback);
        }
    }

    public class UpdateWhatsappSenderBusinessInfoRequest {
        private final String sender;
        private final WhatsAppBusinessInfoRequest whatsAppBusinessInfoRequest;

        private UpdateWhatsappSenderBusinessInfoRequest(String sender, WhatsAppBusinessInfoRequest whatsAppBusinessInfoRequest) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.whatsAppBusinessInfoRequest = Objects.requireNonNull(whatsAppBusinessInfoRequest, "The required parameter 'whatsAppBusinessInfoRequest' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition updateWhatsappSenderBusinessInfoDefinition = WhatsAppApi.this.updateWhatsappSenderBusinessInfoDefinition(this.sender, this.whatsAppBusinessInfoRequest);
            WhatsAppApi.this.apiClient.execute(updateWhatsappSenderBusinessInfoDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition updateWhatsappSenderBusinessInfoDefinition = WhatsAppApi.this.updateWhatsappSenderBusinessInfoDefinition(this.sender, this.whatsAppBusinessInfoRequest);
            return WhatsAppApi.this.apiClient.executeAsync(updateWhatsappSenderBusinessInfoDefinition, callback);
        }
    }

    public class SendWhatsappInteractiveUrlButtonMessageRequest {
        private final WhatsAppInteractiveUrlButtonMessage whatsAppInteractiveUrlButtonMessage;

        private SendWhatsappInteractiveUrlButtonMessageRequest(WhatsAppInteractiveUrlButtonMessage whatsAppInteractiveUrlButtonMessage) {
            this.whatsAppInteractiveUrlButtonMessage = Objects.requireNonNull(whatsAppInteractiveUrlButtonMessage, "The required parameter 'whatsAppInteractiveUrlButtonMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsappInteractiveUrlButtonMessageDefinition = WhatsAppApi.this.sendWhatsappInteractiveUrlButtonMessageDefinition(this.whatsAppInteractiveUrlButtonMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsappInteractiveUrlButtonMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsappInteractiveUrlButtonMessageDefinition = WhatsAppApi.this.sendWhatsappInteractiveUrlButtonMessageDefinition(this.whatsAppInteractiveUrlButtonMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsappInteractiveUrlButtonMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsappInteractiveOrderStatusMessageRequest {
        private final WhatsAppInteractiveOrderStatusMessage whatsAppInteractiveOrderStatusMessage;

        private SendWhatsappInteractiveOrderStatusMessageRequest(WhatsAppInteractiveOrderStatusMessage whatsAppInteractiveOrderStatusMessage) {
            this.whatsAppInteractiveOrderStatusMessage = Objects.requireNonNull(whatsAppInteractiveOrderStatusMessage, "The required parameter 'whatsAppInteractiveOrderStatusMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsappInteractiveOrderStatusMessageDefinition = WhatsAppApi.this.sendWhatsappInteractiveOrderStatusMessageDefinition(this.whatsAppInteractiveOrderStatusMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsappInteractiveOrderStatusMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsappInteractiveOrderStatusMessageDefinition = WhatsAppApi.this.sendWhatsappInteractiveOrderStatusMessageDefinition(this.whatsAppInteractiveOrderStatusMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsappInteractiveOrderStatusMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsappInteractiveOrderDetailsMessageRequest {
        private final WhatsAppInteractiveOrderDetailsMessage whatsAppInteractiveOrderDetailsMessage;

        private SendWhatsappInteractiveOrderDetailsMessageRequest(WhatsAppInteractiveOrderDetailsMessage whatsAppInteractiveOrderDetailsMessage) {
            this.whatsAppInteractiveOrderDetailsMessage = Objects.requireNonNull(whatsAppInteractiveOrderDetailsMessage, "The required parameter 'whatsAppInteractiveOrderDetailsMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsappInteractiveOrderDetailsMessageDefinition = WhatsAppApi.this.sendWhatsappInteractiveOrderDetailsMessageDefinition(this.whatsAppInteractiveOrderDetailsMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsappInteractiveOrderDetailsMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsappInteractiveOrderDetailsMessageDefinition = WhatsAppApi.this.sendWhatsappInteractiveOrderDetailsMessageDefinition(this.whatsAppInteractiveOrderDetailsMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsappInteractiveOrderDetailsMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsappInteractiveLocationRequestMessageRequest {
        private final WhatsAppInteractiveLocationRequestMessage whatsAppInteractiveLocationRequestMessage;

        private SendWhatsappInteractiveLocationRequestMessageRequest(WhatsAppInteractiveLocationRequestMessage whatsAppInteractiveLocationRequestMessage) {
            this.whatsAppInteractiveLocationRequestMessage = Objects.requireNonNull(whatsAppInteractiveLocationRequestMessage, "The required parameter 'whatsAppInteractiveLocationRequestMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsappInteractiveLocationRequestMessageDefinition = WhatsAppApi.this.sendWhatsappInteractiveLocationRequestMessageDefinition(this.whatsAppInteractiveLocationRequestMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsappInteractiveLocationRequestMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsappInteractiveLocationRequestMessageDefinition = WhatsAppApi.this.sendWhatsappInteractiveLocationRequestMessageDefinition(this.whatsAppInteractiveLocationRequestMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsappInteractiveLocationRequestMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsappInteractiveFlowMessageRequest {
        private final WhatsAppInteractiveFlowMessage whatsAppInteractiveFlowMessage;

        private SendWhatsappInteractiveFlowMessageRequest(WhatsAppInteractiveFlowMessage whatsAppInteractiveFlowMessage) {
            this.whatsAppInteractiveFlowMessage = Objects.requireNonNull(whatsAppInteractiveFlowMessage, "The required parameter 'whatsAppInteractiveFlowMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsappInteractiveFlowMessageDefinition = WhatsAppApi.this.sendWhatsappInteractiveFlowMessageDefinition(this.whatsAppInteractiveFlowMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsappInteractiveFlowMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsappInteractiveFlowMessageDefinition = WhatsAppApi.this.sendWhatsappInteractiveFlowMessageDefinition(this.whatsAppInteractiveFlowMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsappInteractiveFlowMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsAppVideoMessageRequest {
        private final WhatsAppVideoMessage whatsAppVideoMessage;

        private SendWhatsAppVideoMessageRequest(WhatsAppVideoMessage whatsAppVideoMessage) {
            this.whatsAppVideoMessage = Objects.requireNonNull(whatsAppVideoMessage, "The required parameter 'whatsAppVideoMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsAppVideoMessageDefinition = WhatsAppApi.this.sendWhatsAppVideoMessageDefinition(this.whatsAppVideoMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsAppVideoMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsAppVideoMessageDefinition = WhatsAppApi.this.sendWhatsAppVideoMessageDefinition(this.whatsAppVideoMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsAppVideoMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsAppTextMessageRequest {
        private final WhatsAppTextMessage whatsAppTextMessage;

        private SendWhatsAppTextMessageRequest(WhatsAppTextMessage whatsAppTextMessage) {
            this.whatsAppTextMessage = Objects.requireNonNull(whatsAppTextMessage, "The required parameter 'whatsAppTextMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsAppTextMessageDefinition = WhatsAppApi.this.sendWhatsAppTextMessageDefinition(this.whatsAppTextMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsAppTextMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsAppTextMessageDefinition = WhatsAppApi.this.sendWhatsAppTextMessageDefinition(this.whatsAppTextMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsAppTextMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsAppTemplateMessageRequest {
        private final WhatsAppBulkMessage whatsAppBulkMessage;

        private SendWhatsAppTemplateMessageRequest(WhatsAppBulkMessage whatsAppBulkMessage) {
            this.whatsAppBulkMessage = Objects.requireNonNull(whatsAppBulkMessage, "The required parameter 'whatsAppBulkMessage' is missing.");
        }

        public WhatsAppBulkMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsAppTemplateMessageDefinition = WhatsAppApi.this.sendWhatsAppTemplateMessageDefinition(this.whatsAppBulkMessage);
            return (WhatsAppBulkMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsAppTemplateMessageDefinition, new TypeReference<WhatsAppBulkMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppBulkMessageInfo> callback) {
            RequestDefinition sendWhatsAppTemplateMessageDefinition = WhatsAppApi.this.sendWhatsAppTemplateMessageDefinition(this.whatsAppBulkMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsAppTemplateMessageDefinition, new TypeReference<WhatsAppBulkMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsAppStickerMessageRequest {
        private final WhatsAppStickerMessage whatsAppStickerMessage;

        private SendWhatsAppStickerMessageRequest(WhatsAppStickerMessage whatsAppStickerMessage) {
            this.whatsAppStickerMessage = Objects.requireNonNull(whatsAppStickerMessage, "The required parameter 'whatsAppStickerMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsAppStickerMessageDefinition = WhatsAppApi.this.sendWhatsAppStickerMessageDefinition(this.whatsAppStickerMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsAppStickerMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsAppStickerMessageDefinition = WhatsAppApi.this.sendWhatsAppStickerMessageDefinition(this.whatsAppStickerMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsAppStickerMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsAppLocationMessageRequest {
        private final WhatsAppLocationMessage whatsAppLocationMessage;

        private SendWhatsAppLocationMessageRequest(WhatsAppLocationMessage whatsAppLocationMessage) {
            this.whatsAppLocationMessage = Objects.requireNonNull(whatsAppLocationMessage, "The required parameter 'whatsAppLocationMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsAppLocationMessageDefinition = WhatsAppApi.this.sendWhatsAppLocationMessageDefinition(this.whatsAppLocationMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsAppLocationMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsAppLocationMessageDefinition = WhatsAppApi.this.sendWhatsAppLocationMessageDefinition(this.whatsAppLocationMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsAppLocationMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsAppInteractiveProductMessageRequest {
        private final WhatsAppInteractiveProductMessage whatsAppInteractiveProductMessage;

        private SendWhatsAppInteractiveProductMessageRequest(WhatsAppInteractiveProductMessage whatsAppInteractiveProductMessage) {
            this.whatsAppInteractiveProductMessage = Objects.requireNonNull(whatsAppInteractiveProductMessage, "The required parameter 'whatsAppInteractiveProductMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsAppInteractiveProductMessageDefinition = WhatsAppApi.this.sendWhatsAppInteractiveProductMessageDefinition(this.whatsAppInteractiveProductMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsAppInteractiveProductMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsAppInteractiveProductMessageDefinition = WhatsAppApi.this.sendWhatsAppInteractiveProductMessageDefinition(this.whatsAppInteractiveProductMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsAppInteractiveProductMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsAppInteractiveMultiProductMessageRequest {
        private final WhatsAppInteractiveMultiProductMessage whatsAppInteractiveMultiProductMessage;

        private SendWhatsAppInteractiveMultiProductMessageRequest(WhatsAppInteractiveMultiProductMessage whatsAppInteractiveMultiProductMessage) {
            this.whatsAppInteractiveMultiProductMessage = Objects.requireNonNull(whatsAppInteractiveMultiProductMessage, "The required parameter 'whatsAppInteractiveMultiProductMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsAppInteractiveMultiProductMessageDefinition = WhatsAppApi.this.sendWhatsAppInteractiveMultiProductMessageDefinition(this.whatsAppInteractiveMultiProductMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsAppInteractiveMultiProductMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsAppInteractiveMultiProductMessageDefinition = WhatsAppApi.this.sendWhatsAppInteractiveMultiProductMessageDefinition(this.whatsAppInteractiveMultiProductMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsAppInteractiveMultiProductMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsAppInteractiveListMessageRequest {
        private final WhatsAppInteractiveListMessage whatsAppInteractiveListMessage;

        private SendWhatsAppInteractiveListMessageRequest(WhatsAppInteractiveListMessage whatsAppInteractiveListMessage) {
            this.whatsAppInteractiveListMessage = Objects.requireNonNull(whatsAppInteractiveListMessage, "The required parameter 'whatsAppInteractiveListMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsAppInteractiveListMessageDefinition = WhatsAppApi.this.sendWhatsAppInteractiveListMessageDefinition(this.whatsAppInteractiveListMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsAppInteractiveListMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsAppInteractiveListMessageDefinition = WhatsAppApi.this.sendWhatsAppInteractiveListMessageDefinition(this.whatsAppInteractiveListMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsAppInteractiveListMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsAppInteractiveButtonsMessageRequest {
        private final WhatsAppInteractiveButtonsMessage whatsAppInteractiveButtonsMessage;

        private SendWhatsAppInteractiveButtonsMessageRequest(WhatsAppInteractiveButtonsMessage whatsAppInteractiveButtonsMessage) {
            this.whatsAppInteractiveButtonsMessage = Objects.requireNonNull(whatsAppInteractiveButtonsMessage, "The required parameter 'whatsAppInteractiveButtonsMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsAppInteractiveButtonsMessageDefinition = WhatsAppApi.this.sendWhatsAppInteractiveButtonsMessageDefinition(this.whatsAppInteractiveButtonsMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsAppInteractiveButtonsMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsAppInteractiveButtonsMessageDefinition = WhatsAppApi.this.sendWhatsAppInteractiveButtonsMessageDefinition(this.whatsAppInteractiveButtonsMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsAppInteractiveButtonsMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsAppImageMessageRequest {
        private final WhatsAppImageMessage whatsAppImageMessage;

        private SendWhatsAppImageMessageRequest(WhatsAppImageMessage whatsAppImageMessage) {
            this.whatsAppImageMessage = Objects.requireNonNull(whatsAppImageMessage, "The required parameter 'whatsAppImageMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsAppImageMessageDefinition = WhatsAppApi.this.sendWhatsAppImageMessageDefinition(this.whatsAppImageMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsAppImageMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsAppImageMessageDefinition = WhatsAppApi.this.sendWhatsAppImageMessageDefinition(this.whatsAppImageMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsAppImageMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsAppDocumentMessageRequest {
        private final WhatsAppDocumentMessage whatsAppDocumentMessage;

        private SendWhatsAppDocumentMessageRequest(WhatsAppDocumentMessage whatsAppDocumentMessage) {
            this.whatsAppDocumentMessage = Objects.requireNonNull(whatsAppDocumentMessage, "The required parameter 'whatsAppDocumentMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsAppDocumentMessageDefinition = WhatsAppApi.this.sendWhatsAppDocumentMessageDefinition(this.whatsAppDocumentMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsAppDocumentMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsAppDocumentMessageDefinition = WhatsAppApi.this.sendWhatsAppDocumentMessageDefinition(this.whatsAppDocumentMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsAppDocumentMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsAppContactMessageRequest {
        private final WhatsAppContactsMessage whatsAppContactsMessage;

        private SendWhatsAppContactMessageRequest(WhatsAppContactsMessage whatsAppContactsMessage) {
            this.whatsAppContactsMessage = Objects.requireNonNull(whatsAppContactsMessage, "The required parameter 'whatsAppContactsMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsAppContactMessageDefinition = WhatsAppApi.this.sendWhatsAppContactMessageDefinition(this.whatsAppContactsMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsAppContactMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsAppContactMessageDefinition = WhatsAppApi.this.sendWhatsAppContactMessageDefinition(this.whatsAppContactsMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsAppContactMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class SendWhatsAppAudioMessageRequest {
        private final WhatsAppAudioMessage whatsAppAudioMessage;

        private SendWhatsAppAudioMessageRequest(WhatsAppAudioMessage whatsAppAudioMessage) {
            this.whatsAppAudioMessage = Objects.requireNonNull(whatsAppAudioMessage, "The required parameter 'whatsAppAudioMessage' is missing.");
        }

        public WhatsAppSingleMessageInfo execute() throws ApiException {
            RequestDefinition sendWhatsAppAudioMessageDefinition = WhatsAppApi.this.sendWhatsAppAudioMessageDefinition(this.whatsAppAudioMessage);
            return (WhatsAppSingleMessageInfo)WhatsAppApi.this.apiClient.execute(sendWhatsAppAudioMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSingleMessageInfo> callback) {
            RequestDefinition sendWhatsAppAudioMessageDefinition = WhatsAppApi.this.sendWhatsAppAudioMessageDefinition(this.whatsAppAudioMessage);
            return WhatsAppApi.this.apiClient.executeAsync(sendWhatsAppAudioMessageDefinition, new TypeReference<WhatsAppSingleMessageInfo>(){}.getType(), callback);
        }
    }

    public class RetryWhatsappSenderVerificationRequest {
        private final String sender;
        private final WhatsAppOtpRequest whatsAppOtpRequest;

        private RetryWhatsappSenderVerificationRequest(String sender, WhatsAppOtpRequest whatsAppOtpRequest) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.whatsAppOtpRequest = Objects.requireNonNull(whatsAppOtpRequest, "The required parameter 'whatsAppOtpRequest' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition retryWhatsappSenderVerificationDefinition = WhatsAppApi.this.retryWhatsappSenderVerificationDefinition(this.sender, this.whatsAppOtpRequest);
            WhatsAppApi.this.apiClient.execute(retryWhatsappSenderVerificationDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition retryWhatsappSenderVerificationDefinition = WhatsAppApi.this.retryWhatsappSenderVerificationDefinition(this.sender, this.whatsAppOtpRequest);
            return WhatsAppApi.this.apiClient.executeAsync(retryWhatsappSenderVerificationDefinition, callback);
        }
    }

    public class MarkWhatsAppMessageAsReadRequest {
        private final String sender;
        private final String messageId;

        private MarkWhatsAppMessageAsReadRequest(String sender, String messageId) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.messageId = Objects.requireNonNull(messageId, "The required parameter 'messageId' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition markWhatsAppMessageAsReadDefinition = WhatsAppApi.this.markWhatsAppMessageAsReadDefinition(this.sender, this.messageId);
            WhatsAppApi.this.apiClient.execute(markWhatsAppMessageAsReadDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition markWhatsAppMessageAsReadDefinition = WhatsAppApi.this.markWhatsAppMessageAsReadDefinition(this.sender, this.messageId);
            return WhatsAppApi.this.apiClient.executeAsync(markWhatsAppMessageAsReadDefinition, callback);
        }
    }

    public class GetWhatsappUpiPayuPaymentStatusRequest {
        private final String sender;
        private final String paymentId;

        private GetWhatsappUpiPayuPaymentStatusRequest(String sender, String paymentId) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.paymentId = Objects.requireNonNull(paymentId, "The required parameter 'paymentId' is missing.");
        }

        public WhatsAppPayment execute() throws ApiException {
            RequestDefinition getWhatsappUpiPayuPaymentStatusDefinition = WhatsAppApi.this.getWhatsappUpiPayuPaymentStatusDefinition(this.sender, this.paymentId);
            return (WhatsAppPayment)WhatsAppApi.this.apiClient.execute(getWhatsappUpiPayuPaymentStatusDefinition, new TypeReference<WhatsAppPayment>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppPayment> callback) {
            RequestDefinition getWhatsappUpiPayuPaymentStatusDefinition = WhatsAppApi.this.getWhatsappUpiPayuPaymentStatusDefinition(this.sender, this.paymentId);
            return WhatsAppApi.this.apiClient.executeAsync(getWhatsappUpiPayuPaymentStatusDefinition, new TypeReference<WhatsAppPayment>(){}.getType(), callback);
        }
    }

    public class GetWhatsappUpiPaymentStatusRequest {
        private final String sender;
        private final String paymentId;

        private GetWhatsappUpiPaymentStatusRequest(String sender, String paymentId) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.paymentId = Objects.requireNonNull(paymentId, "The required parameter 'paymentId' is missing.");
        }

        public WhatsAppPayment execute() throws ApiException {
            RequestDefinition getWhatsappUpiPaymentStatusDefinition = WhatsAppApi.this.getWhatsappUpiPaymentStatusDefinition(this.sender, this.paymentId);
            return (WhatsAppPayment)WhatsAppApi.this.apiClient.execute(getWhatsappUpiPaymentStatusDefinition, new TypeReference<WhatsAppPayment>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppPayment> callback) {
            RequestDefinition getWhatsappUpiPaymentStatusDefinition = WhatsAppApi.this.getWhatsappUpiPaymentStatusDefinition(this.sender, this.paymentId);
            return WhatsAppApi.this.apiClient.executeAsync(getWhatsappUpiPaymentStatusDefinition, new TypeReference<WhatsAppPayment>(){}.getType(), callback);
        }
    }

    public class GetWhatsappTemplateRequest {
        private final String sender;
        private final String id;

        private GetWhatsappTemplateRequest(String sender, String id) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public WhatsAppTemplateApiResponse execute() throws ApiException {
            RequestDefinition getWhatsappTemplateDefinition = WhatsAppApi.this.getWhatsappTemplateDefinition(this.sender, this.id);
            return (WhatsAppTemplateApiResponse)WhatsAppApi.this.apiClient.execute(getWhatsappTemplateDefinition, new TypeReference<WhatsAppTemplateApiResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppTemplateApiResponse> callback) {
            RequestDefinition getWhatsappTemplateDefinition = WhatsAppApi.this.getWhatsappTemplateDefinition(this.sender, this.id);
            return WhatsAppApi.this.apiClient.executeAsync(getWhatsappTemplateDefinition, new TypeReference<WhatsAppTemplateApiResponse>(){}.getType(), callback);
        }
    }

    public class GetWhatsappSendersQualityRequest {
        private final List<String> senders;

        private GetWhatsappSendersQualityRequest(List<String> senders) {
            this.senders = Objects.requireNonNull(senders, "The required parameter 'senders' is missing.");
        }

        public WhatsAppSenderQualityResponse execute() throws ApiException {
            RequestDefinition getWhatsappSendersQualityDefinition = WhatsAppApi.this.getWhatsappSendersQualityDefinition(this.senders);
            return (WhatsAppSenderQualityResponse)WhatsAppApi.this.apiClient.execute(getWhatsappSendersQualityDefinition, new TypeReference<WhatsAppSenderQualityResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSenderQualityResponse> callback) {
            RequestDefinition getWhatsappSendersQualityDefinition = WhatsAppApi.this.getWhatsappSendersQualityDefinition(this.senders);
            return WhatsAppApi.this.apiClient.executeAsync(getWhatsappSendersQualityDefinition, new TypeReference<WhatsAppSenderQualityResponse>(){}.getType(), callback);
        }
    }

    public class GetWhatsappSenderBusinessLogoRequest {
        private final String sender;

        private GetWhatsappSenderBusinessLogoRequest(String sender) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
        }

        public File execute() throws ApiException {
            RequestDefinition getWhatsappSenderBusinessLogoDefinition = WhatsAppApi.this.getWhatsappSenderBusinessLogoDefinition(this.sender);
            return (File)WhatsAppApi.this.apiClient.execute(getWhatsappSenderBusinessLogoDefinition, new TypeReference<File>(){}.getType());
        }

        public Call executeAsync(ApiCallback<File> callback) {
            RequestDefinition getWhatsappSenderBusinessLogoDefinition = WhatsAppApi.this.getWhatsappSenderBusinessLogoDefinition(this.sender);
            return WhatsAppApi.this.apiClient.executeAsync(getWhatsappSenderBusinessLogoDefinition, new TypeReference<File>(){}.getType(), callback);
        }
    }

    public class GetWhatsappSenderBusinessInfoRequest {
        private final String sender;

        private GetWhatsappSenderBusinessInfoRequest(String sender) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
        }

        public WhatsAppBusinessInfoResponse execute() throws ApiException {
            RequestDefinition getWhatsappSenderBusinessInfoDefinition = WhatsAppApi.this.getWhatsappSenderBusinessInfoDefinition(this.sender);
            return (WhatsAppBusinessInfoResponse)WhatsAppApi.this.apiClient.execute(getWhatsappSenderBusinessInfoDefinition, new TypeReference<WhatsAppBusinessInfoResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppBusinessInfoResponse> callback) {
            RequestDefinition getWhatsappSenderBusinessInfoDefinition = WhatsAppApi.this.getWhatsappSenderBusinessInfoDefinition(this.sender);
            return WhatsAppApi.this.apiClient.executeAsync(getWhatsappSenderBusinessInfoDefinition, new TypeReference<WhatsAppBusinessInfoResponse>(){}.getType(), callback);
        }
    }

    public class GetWhatsappBrazilPaymentStatusRequest {
        private final String sender;
        private final String paymentId;

        private GetWhatsappBrazilPaymentStatusRequest(String sender, String paymentId) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.paymentId = Objects.requireNonNull(paymentId, "The required parameter 'paymentId' is missing.");
        }

        public WhatsAppPayment execute() throws ApiException {
            RequestDefinition getWhatsappBrazilPaymentStatusDefinition = WhatsAppApi.this.getWhatsappBrazilPaymentStatusDefinition(this.sender, this.paymentId);
            return (WhatsAppPayment)WhatsAppApi.this.apiClient.execute(getWhatsappBrazilPaymentStatusDefinition, new TypeReference<WhatsAppPayment>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppPayment> callback) {
            RequestDefinition getWhatsappBrazilPaymentStatusDefinition = WhatsAppApi.this.getWhatsappBrazilPaymentStatusDefinition(this.sender, this.paymentId);
            return WhatsAppApi.this.apiClient.executeAsync(getWhatsappBrazilPaymentStatusDefinition, new TypeReference<WhatsAppPayment>(){}.getType(), callback);
        }
    }

    public class GetWhatsAppTemplatesRequest {
        private final String sender;

        private GetWhatsAppTemplatesRequest(String sender) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
        }

        public WhatsAppTemplatesApiResponse execute() throws ApiException {
            RequestDefinition getWhatsAppTemplatesDefinition = WhatsAppApi.this.getWhatsAppTemplatesDefinition(this.sender);
            return (WhatsAppTemplatesApiResponse)WhatsAppApi.this.apiClient.execute(getWhatsAppTemplatesDefinition, new TypeReference<WhatsAppTemplatesApiResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppTemplatesApiResponse> callback) {
            RequestDefinition getWhatsAppTemplatesDefinition = WhatsAppApi.this.getWhatsAppTemplatesDefinition(this.sender);
            return WhatsAppApi.this.apiClient.executeAsync(getWhatsAppTemplatesDefinition, new TypeReference<WhatsAppTemplatesApiResponse>(){}.getType(), callback);
        }
    }

    public class GetWhatsAppMediaMetadataRequest {
        private final String sender;
        private final String mediaId;

        private GetWhatsAppMediaMetadataRequest(String sender, String mediaId) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.mediaId = Objects.requireNonNull(mediaId, "The required parameter 'mediaId' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition getWhatsAppMediaMetadataDefinition = WhatsAppApi.this.getWhatsAppMediaMetadataDefinition(this.sender, this.mediaId);
            WhatsAppApi.this.apiClient.execute(getWhatsAppMediaMetadataDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition getWhatsAppMediaMetadataDefinition = WhatsAppApi.this.getWhatsAppMediaMetadataDefinition(this.sender, this.mediaId);
            return WhatsAppApi.this.apiClient.executeAsync(getWhatsAppMediaMetadataDefinition, callback);
        }
    }

    public class GetWhatsAppIdentityRequest {
        private final String sender;
        private final String userNumber;

        private GetWhatsAppIdentityRequest(String sender, String userNumber) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.userNumber = Objects.requireNonNull(userNumber, "The required parameter 'userNumber' is missing.");
        }

        public WhatsAppIdentityInfo execute() throws ApiException {
            RequestDefinition getWhatsAppIdentityDefinition = WhatsAppApi.this.getWhatsAppIdentityDefinition(this.sender, this.userNumber);
            return (WhatsAppIdentityInfo)WhatsAppApi.this.apiClient.execute(getWhatsAppIdentityDefinition, new TypeReference<WhatsAppIdentityInfo>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppIdentityInfo> callback) {
            RequestDefinition getWhatsAppIdentityDefinition = WhatsAppApi.this.getWhatsAppIdentityDefinition(this.sender, this.userNumber);
            return WhatsAppApi.this.apiClient.executeAsync(getWhatsAppIdentityDefinition, new TypeReference<WhatsAppIdentityInfo>(){}.getType(), callback);
        }
    }

    public class EditWhatsappTemplateRequest {
        private final String sender;
        private final String id;
        private final WhatsAppTemplateEditPublicApiRequest whatsAppTemplateEditPublicApiRequest;

        private EditWhatsappTemplateRequest(String sender, String id, WhatsAppTemplateEditPublicApiRequest whatsAppTemplateEditPublicApiRequest) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
            this.whatsAppTemplateEditPublicApiRequest = Objects.requireNonNull(whatsAppTemplateEditPublicApiRequest, "The required parameter 'whatsAppTemplateEditPublicApiRequest' is missing.");
        }

        public WhatsAppTemplateApiResponse execute() throws ApiException {
            RequestDefinition editWhatsappTemplateDefinition = WhatsAppApi.this.editWhatsappTemplateDefinition(this.sender, this.id, this.whatsAppTemplateEditPublicApiRequest);
            return (WhatsAppTemplateApiResponse)WhatsAppApi.this.apiClient.execute(editWhatsappTemplateDefinition, new TypeReference<WhatsAppTemplateApiResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppTemplateApiResponse> callback) {
            RequestDefinition editWhatsappTemplateDefinition = WhatsAppApi.this.editWhatsappTemplateDefinition(this.sender, this.id, this.whatsAppTemplateEditPublicApiRequest);
            return WhatsAppApi.this.apiClient.executeAsync(editWhatsappTemplateDefinition, new TypeReference<WhatsAppTemplateApiResponse>(){}.getType(), callback);
        }
    }

    public class DownloadWhatsAppInboundMediaRequest {
        private final String sender;
        private final String mediaId;

        private DownloadWhatsAppInboundMediaRequest(String sender, String mediaId) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.mediaId = Objects.requireNonNull(mediaId, "The required parameter 'mediaId' is missing.");
        }

        public File execute() throws ApiException {
            RequestDefinition downloadWhatsAppInboundMediaDefinition = WhatsAppApi.this.downloadWhatsAppInboundMediaDefinition(this.sender, this.mediaId);
            return (File)WhatsAppApi.this.apiClient.execute(downloadWhatsAppInboundMediaDefinition, new TypeReference<File>(){}.getType());
        }

        public Call executeAsync(ApiCallback<File> callback) {
            RequestDefinition downloadWhatsAppInboundMediaDefinition = WhatsAppApi.this.downloadWhatsAppInboundMediaDefinition(this.sender, this.mediaId);
            return WhatsAppApi.this.apiClient.executeAsync(downloadWhatsAppInboundMediaDefinition, new TypeReference<File>(){}.getType(), callback);
        }
    }

    public class DeleteWhatsAppTemplateRequest {
        private final String sender;
        private final String templateName;

        private DeleteWhatsAppTemplateRequest(String sender, String templateName) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.templateName = Objects.requireNonNull(templateName, "The required parameter 'templateName' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition deleteWhatsAppTemplateDefinition = WhatsAppApi.this.deleteWhatsAppTemplateDefinition(this.sender, this.templateName);
            WhatsAppApi.this.apiClient.execute(deleteWhatsAppTemplateDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition deleteWhatsAppTemplateDefinition = WhatsAppApi.this.deleteWhatsAppTemplateDefinition(this.sender, this.templateName);
            return WhatsAppApi.this.apiClient.executeAsync(deleteWhatsAppTemplateDefinition, callback);
        }
    }

    public class DeleteWhatsAppMediaRequest {
        private final String sender;
        private final WhatsAppUrlDeletionRequest whatsAppUrlDeletionRequest;

        private DeleteWhatsAppMediaRequest(String sender, WhatsAppUrlDeletionRequest whatsAppUrlDeletionRequest) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.whatsAppUrlDeletionRequest = Objects.requireNonNull(whatsAppUrlDeletionRequest, "The required parameter 'whatsAppUrlDeletionRequest' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition deleteWhatsAppMediaDefinition = WhatsAppApi.this.deleteWhatsAppMediaDefinition(this.sender, this.whatsAppUrlDeletionRequest);
            WhatsAppApi.this.apiClient.execute(deleteWhatsAppMediaDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition deleteWhatsAppMediaDefinition = WhatsAppApi.this.deleteWhatsAppMediaDefinition(this.sender, this.whatsAppUrlDeletionRequest);
            return WhatsAppApi.this.apiClient.executeAsync(deleteWhatsAppMediaDefinition, callback);
        }
    }

    public class CreateWhatsAppTemplateRequest {
        private final String sender;
        private final WhatsAppTemplatePublicApiRequest whatsAppTemplatePublicApiRequest;

        private CreateWhatsAppTemplateRequest(String sender, WhatsAppTemplatePublicApiRequest whatsAppTemplatePublicApiRequest) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.whatsAppTemplatePublicApiRequest = Objects.requireNonNull(whatsAppTemplatePublicApiRequest, "The required parameter 'whatsAppTemplatePublicApiRequest' is missing.");
        }

        public WhatsAppTemplateApiResponse execute() throws ApiException {
            RequestDefinition createWhatsAppTemplateDefinition = WhatsAppApi.this.createWhatsAppTemplateDefinition(this.sender, this.whatsAppTemplatePublicApiRequest);
            return (WhatsAppTemplateApiResponse)WhatsAppApi.this.apiClient.execute(createWhatsAppTemplateDefinition, new TypeReference<WhatsAppTemplateApiResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppTemplateApiResponse> callback) {
            RequestDefinition createWhatsAppTemplateDefinition = WhatsAppApi.this.createWhatsAppTemplateDefinition(this.sender, this.whatsAppTemplatePublicApiRequest);
            return WhatsAppApi.this.apiClient.executeAsync(createWhatsAppTemplateDefinition, new TypeReference<WhatsAppTemplateApiResponse>(){}.getType(), callback);
        }
    }

    public class ConfirmWhatsAppIdentityRequest {
        private final String sender;
        private final String userNumber;
        private final WhatsAppIdentityConfirmation whatsAppIdentityConfirmation;

        private ConfirmWhatsAppIdentityRequest(String sender, String userNumber, WhatsAppIdentityConfirmation whatsAppIdentityConfirmation) {
            this.sender = Objects.requireNonNull(sender, "The required parameter 'sender' is missing.");
            this.userNumber = Objects.requireNonNull(userNumber, "The required parameter 'userNumber' is missing.");
            this.whatsAppIdentityConfirmation = Objects.requireNonNull(whatsAppIdentityConfirmation, "The required parameter 'whatsAppIdentityConfirmation' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition confirmWhatsAppIdentityDefinition = WhatsAppApi.this.confirmWhatsAppIdentityDefinition(this.sender, this.userNumber, this.whatsAppIdentityConfirmation);
            WhatsAppApi.this.apiClient.execute(confirmWhatsAppIdentityDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition confirmWhatsAppIdentityDefinition = WhatsAppApi.this.confirmWhatsAppIdentityDefinition(this.sender, this.userNumber, this.whatsAppIdentityConfirmation);
            return WhatsAppApi.this.apiClient.executeAsync(confirmWhatsAppIdentityDefinition, callback);
        }
    }

    public class AddWhatsappSenderRequest {
        private final Long businessAccountId;
        private final WhatsAppPhoneNumberRequest whatsAppPhoneNumberRequest;

        private AddWhatsappSenderRequest(Long businessAccountId, WhatsAppPhoneNumberRequest whatsAppPhoneNumberRequest) {
            this.businessAccountId = Objects.requireNonNull(businessAccountId, "The required parameter 'businessAccountId' is missing.");
            this.whatsAppPhoneNumberRequest = Objects.requireNonNull(whatsAppPhoneNumberRequest, "The required parameter 'whatsAppPhoneNumberRequest' is missing.");
        }

        public WhatsAppSenderRegistrationResponse execute() throws ApiException {
            RequestDefinition addWhatsappSenderDefinition = WhatsAppApi.this.addWhatsappSenderDefinition(this.businessAccountId, this.whatsAppPhoneNumberRequest);
            return (WhatsAppSenderRegistrationResponse)WhatsAppApi.this.apiClient.execute(addWhatsappSenderDefinition, new TypeReference<WhatsAppSenderRegistrationResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<WhatsAppSenderRegistrationResponse> callback) {
            RequestDefinition addWhatsappSenderDefinition = WhatsAppApi.this.addWhatsappSenderDefinition(this.businessAccountId, this.whatsAppPhoneNumberRequest);
            return WhatsAppApi.this.apiClient.executeAsync(addWhatsappSenderDefinition, new TypeReference<WhatsAppSenderRegistrationResponse>(){}.getType(), callback);
        }
    }
}

