/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.CallsAdvancedBody;
import com.infobip.model.CallsBulkRequest;
import com.infobip.model.CallsBulkResponse;
import com.infobip.model.CallsBulkStatusResponse;
import com.infobip.model.CallsGetVoicesResponse;
import com.infobip.model.CallsIpCoreGeneralStatus;
import com.infobip.model.CallsLaunchScenarioRequest;
import com.infobip.model.CallsLogsResponse;
import com.infobip.model.CallsMultiBody;
import com.infobip.model.CallsRecordedAudioFilesResponse;
import com.infobip.model.CallsReportResponse;
import com.infobip.model.CallsSearchResponse;
import com.infobip.model.CallsSingleBody;
import com.infobip.model.CallsUpdateScenarioRequest;
import com.infobip.model.CallsUpdateScenarioResponse;
import com.infobip.model.CallsUpdateStatusRequest;
import com.infobip.model.CallsVoiceResponse;
import java.io.File;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import okhttp3.Call;

public class VoiceApi {
    private final ApiClient apiClient;

    public VoiceApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition createAVoiceIvrScenarioDefinition(CallsUpdateScenarioRequest callsUpdateScenarioRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/voice/ivr/1/scenarios").body(callsUpdateScenarioRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateAVoiceIvrScenarioRequest createAVoiceIvrScenario(CallsUpdateScenarioRequest callsUpdateScenarioRequest) {
        return new CreateAVoiceIvrScenarioRequest(callsUpdateScenarioRequest);
    }

    private RequestDefinition deleteAVoiceIvrScenarioDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/voice/ivr/1/scenarios/{id}").requiresAuthentication(true).accept("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public DeleteAVoiceIvrScenarioRequest deleteAVoiceIvrScenario(String id) {
        return new DeleteAVoiceIvrScenarioRequest(id);
    }

    private RequestDefinition downloadVoiceIvrRecordedFileDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/voice/ivr/1/files/{id}").requiresAuthentication(true).accept("application/octet-stream");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public DownloadVoiceIvrRecordedFileRequest downloadVoiceIvrRecordedFile(String id) {
        return new DownloadVoiceIvrRecordedFileRequest(id);
    }

    private RequestDefinition getAVoiceIvrScenarioDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/voice/ivr/1/scenarios/{id}").requiresAuthentication(true).accept("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public GetAVoiceIvrScenarioRequest getAVoiceIvrScenario(String id) {
        return new GetAVoiceIvrScenarioRequest(id);
    }

    private RequestDefinition getSentBulksDefinition(String bulkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/tts/3/bulks").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public GetSentBulksRequest getSentBulks(String bulkId) {
        return new GetSentBulksRequest(bulkId);
    }

    private RequestDefinition getSentBulksStatusDefinition(String bulkId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/tts/3/bulks/status").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public GetSentBulksStatusRequest getSentBulksStatus(String bulkId) {
        return new GetSentBulksStatusRequest(bulkId);
    }

    private RequestDefinition getSentVoiceLogsDefinition(String from, String to, List<String> bulkId, List<String> messageId, CallsIpCoreGeneralStatus generalStatus, OffsetDateTime sentSince, OffsetDateTime sentUntil, Integer limit, String mcc, String mnc) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/tts/3/logs").requiresAuthentication(true).accept("application/json");
        if (from != null) {
            builder.addQueryParameter(new Parameter("from", from));
        }
        if (to != null) {
            builder.addQueryParameter(new Parameter("to", to));
        }
        if (bulkId != null) {
            for (String parameterItem : bulkId) {
                builder.addQueryParameter(new Parameter("bulkId", parameterItem));
            }
        }
        if (messageId != null) {
            for (String parameterItem : messageId) {
                builder.addQueryParameter(new Parameter("messageId", parameterItem));
            }
        }
        if (generalStatus != null) {
            builder.addQueryParameter(new Parameter("generalStatus", (Object)generalStatus));
        }
        if (sentSince != null) {
            builder.addQueryParameter(new Parameter("sentSince", sentSince));
        }
        if (sentUntil != null) {
            builder.addQueryParameter(new Parameter("sentUntil", sentUntil));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (mcc != null) {
            builder.addQueryParameter(new Parameter("mcc", mcc));
        }
        if (mnc != null) {
            builder.addQueryParameter(new Parameter("mnc", mnc));
        }
        return builder.build();
    }

    public GetSentVoiceLogsRequest getSentVoiceLogs() {
        return new GetSentVoiceLogsRequest();
    }

    private RequestDefinition getVoiceDeliveryReportsDefinition(String bulkId, String messageId, Integer limit) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/voice/1/reports").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        if (messageId != null) {
            builder.addQueryParameter(new Parameter("messageId", messageId));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        return builder.build();
    }

    public GetVoiceDeliveryReportsRequest getVoiceDeliveryReports() {
        return new GetVoiceDeliveryReportsRequest();
    }

    private RequestDefinition getVoicesDefinition(String language, Boolean includeNeural) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/tts/3/voices/{language}").requiresAuthentication(true).accept("application/json");
        if (language != null) {
            builder.addPathParameter(new Parameter("language", language));
        }
        if (includeNeural != null) {
            builder.addQueryParameter(new Parameter("includeNeural", includeNeural));
        }
        return builder.build();
    }

    public GetVoicesRequest getVoices(String language) {
        return new GetVoicesRequest(language);
    }

    private RequestDefinition manageSentBulksStatusDefinition(String bulkId, CallsUpdateStatusRequest callsUpdateStatusRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/tts/3/bulks/status").body(callsUpdateStatusRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public ManageSentBulksStatusRequest manageSentBulksStatus(String bulkId, CallsUpdateStatusRequest callsUpdateStatusRequest) {
        return new ManageSentBulksStatusRequest(bulkId, callsUpdateStatusRequest);
    }

    private RequestDefinition rescheduleSentBulkDefinition(String bulkId, CallsBulkRequest callsBulkRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/tts/3/bulks").body(callsBulkRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        return builder.build();
    }

    public RescheduleSentBulkRequest rescheduleSentBulk(String bulkId, CallsBulkRequest callsBulkRequest) {
        return new RescheduleSentBulkRequest(bulkId, callsBulkRequest);
    }

    private RequestDefinition searchVoiceIvrRecordedFilesDefinition(Integer page, Integer pageSize, String messageId, String number) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/voice/ivr/1/files").requiresAuthentication(true).accept("application/json");
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (pageSize != null) {
            builder.addQueryParameter(new Parameter("pageSize", pageSize));
        }
        if (messageId != null) {
            builder.addQueryParameter(new Parameter("messageId", messageId));
        }
        if (number != null) {
            builder.addQueryParameter(new Parameter("number", number));
        }
        return builder.build();
    }

    public SearchVoiceIvrRecordedFilesRequest searchVoiceIvrRecordedFiles() {
        return new SearchVoiceIvrRecordedFilesRequest();
    }

    private RequestDefinition searchVoiceIvrScenariosDefinition(Integer page, Integer pageSize, String name, String label, LocalDate lastUsageDateSince, LocalDate lastUsageDateUntil) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/voice/ivr/1/scenarios").requiresAuthentication(true).accept("application/json");
        if (page != null) {
            builder.addQueryParameter(new Parameter("page", page));
        }
        if (pageSize != null) {
            builder.addQueryParameter(new Parameter("pageSize", pageSize));
        }
        if (name != null) {
            builder.addQueryParameter(new Parameter("name", name));
        }
        if (label != null) {
            builder.addQueryParameter(new Parameter("label", label));
        }
        if (lastUsageDateSince != null) {
            builder.addQueryParameter(new Parameter("lastUsageDateSince", lastUsageDateSince));
        }
        if (lastUsageDateUntil != null) {
            builder.addQueryParameter(new Parameter("lastUsageDateUntil", lastUsageDateUntil));
        }
        return builder.build();
    }

    public SearchVoiceIvrScenariosRequest searchVoiceIvrScenarios() {
        return new SearchVoiceIvrScenariosRequest();
    }

    private RequestDefinition sendAdvancedVoiceTtsDefinition(CallsAdvancedBody callsAdvancedBody) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/tts/3/advanced").body(callsAdvancedBody).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendAdvancedVoiceTtsRequest sendAdvancedVoiceTts(CallsAdvancedBody callsAdvancedBody) {
        return new SendAdvancedVoiceTtsRequest(callsAdvancedBody);
    }

    private RequestDefinition sendMultipleVoiceTtsDefinition(CallsMultiBody callsMultiBody) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/tts/3/multi").body(callsMultiBody).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendMultipleVoiceTtsRequest sendMultipleVoiceTts(CallsMultiBody callsMultiBody) {
        return new SendMultipleVoiceTtsRequest(callsMultiBody);
    }

    private RequestDefinition sendSingleVoiceTtsDefinition(CallsSingleBody callsSingleBody) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/tts/3/single").body(callsSingleBody).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendSingleVoiceTtsRequest sendSingleVoiceTts(CallsSingleBody callsSingleBody) {
        return new SendSingleVoiceTtsRequest(callsSingleBody);
    }

    private RequestDefinition sendVoiceMessagesWithAnIvrScenarioDefinition(CallsLaunchScenarioRequest callsLaunchScenarioRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/voice/ivr/1/messages").body(callsLaunchScenarioRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendVoiceMessagesWithAnIvrScenarioRequest sendVoiceMessagesWithAnIvrScenario(CallsLaunchScenarioRequest callsLaunchScenarioRequest) {
        return new SendVoiceMessagesWithAnIvrScenarioRequest(callsLaunchScenarioRequest);
    }

    private RequestDefinition updateVoiceIvrScenarioDefinition(String id, CallsUpdateScenarioRequest callsUpdateScenarioRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/voice/ivr/1/scenarios/{id}").body(callsUpdateScenarioRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public UpdateVoiceIvrScenarioRequest updateVoiceIvrScenario(String id, CallsUpdateScenarioRequest callsUpdateScenarioRequest) {
        return new UpdateVoiceIvrScenarioRequest(id, callsUpdateScenarioRequest);
    }

    public class UpdateVoiceIvrScenarioRequest {
        private final String id;
        private final CallsUpdateScenarioRequest callsUpdateScenarioRequest;

        private UpdateVoiceIvrScenarioRequest(String id, CallsUpdateScenarioRequest callsUpdateScenarioRequest) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
            this.callsUpdateScenarioRequest = Objects.requireNonNull(callsUpdateScenarioRequest, "The required parameter 'callsUpdateScenarioRequest' is missing.");
        }

        public CallsUpdateScenarioResponse execute() throws ApiException {
            RequestDefinition updateVoiceIvrScenarioDefinition = VoiceApi.this.updateVoiceIvrScenarioDefinition(this.id, this.callsUpdateScenarioRequest);
            return (CallsUpdateScenarioResponse)VoiceApi.this.apiClient.execute(updateVoiceIvrScenarioDefinition, new TypeReference<CallsUpdateScenarioResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsUpdateScenarioResponse> callback) {
            RequestDefinition updateVoiceIvrScenarioDefinition = VoiceApi.this.updateVoiceIvrScenarioDefinition(this.id, this.callsUpdateScenarioRequest);
            return VoiceApi.this.apiClient.executeAsync(updateVoiceIvrScenarioDefinition, new TypeReference<CallsUpdateScenarioResponse>(){}.getType(), callback);
        }
    }

    public class SendVoiceMessagesWithAnIvrScenarioRequest {
        private final CallsLaunchScenarioRequest callsLaunchScenarioRequest;

        private SendVoiceMessagesWithAnIvrScenarioRequest(CallsLaunchScenarioRequest callsLaunchScenarioRequest) {
            this.callsLaunchScenarioRequest = Objects.requireNonNull(callsLaunchScenarioRequest, "The required parameter 'callsLaunchScenarioRequest' is missing.");
        }

        public CallsVoiceResponse execute() throws ApiException {
            RequestDefinition sendVoiceMessagesWithAnIvrScenarioDefinition = VoiceApi.this.sendVoiceMessagesWithAnIvrScenarioDefinition(this.callsLaunchScenarioRequest);
            return (CallsVoiceResponse)VoiceApi.this.apiClient.execute(sendVoiceMessagesWithAnIvrScenarioDefinition, new TypeReference<CallsVoiceResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsVoiceResponse> callback) {
            RequestDefinition sendVoiceMessagesWithAnIvrScenarioDefinition = VoiceApi.this.sendVoiceMessagesWithAnIvrScenarioDefinition(this.callsLaunchScenarioRequest);
            return VoiceApi.this.apiClient.executeAsync(sendVoiceMessagesWithAnIvrScenarioDefinition, new TypeReference<CallsVoiceResponse>(){}.getType(), callback);
        }
    }

    public class SendSingleVoiceTtsRequest {
        private final CallsSingleBody callsSingleBody;

        private SendSingleVoiceTtsRequest(CallsSingleBody callsSingleBody) {
            this.callsSingleBody = Objects.requireNonNull(callsSingleBody, "The required parameter 'callsSingleBody' is missing.");
        }

        public CallsVoiceResponse execute() throws ApiException {
            RequestDefinition sendSingleVoiceTtsDefinition = VoiceApi.this.sendSingleVoiceTtsDefinition(this.callsSingleBody);
            return (CallsVoiceResponse)VoiceApi.this.apiClient.execute(sendSingleVoiceTtsDefinition, new TypeReference<CallsVoiceResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsVoiceResponse> callback) {
            RequestDefinition sendSingleVoiceTtsDefinition = VoiceApi.this.sendSingleVoiceTtsDefinition(this.callsSingleBody);
            return VoiceApi.this.apiClient.executeAsync(sendSingleVoiceTtsDefinition, new TypeReference<CallsVoiceResponse>(){}.getType(), callback);
        }
    }

    public class SendMultipleVoiceTtsRequest {
        private final CallsMultiBody callsMultiBody;

        private SendMultipleVoiceTtsRequest(CallsMultiBody callsMultiBody) {
            this.callsMultiBody = Objects.requireNonNull(callsMultiBody, "The required parameter 'callsMultiBody' is missing.");
        }

        public CallsVoiceResponse execute() throws ApiException {
            RequestDefinition sendMultipleVoiceTtsDefinition = VoiceApi.this.sendMultipleVoiceTtsDefinition(this.callsMultiBody);
            return (CallsVoiceResponse)VoiceApi.this.apiClient.execute(sendMultipleVoiceTtsDefinition, new TypeReference<CallsVoiceResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsVoiceResponse> callback) {
            RequestDefinition sendMultipleVoiceTtsDefinition = VoiceApi.this.sendMultipleVoiceTtsDefinition(this.callsMultiBody);
            return VoiceApi.this.apiClient.executeAsync(sendMultipleVoiceTtsDefinition, new TypeReference<CallsVoiceResponse>(){}.getType(), callback);
        }
    }

    public class SendAdvancedVoiceTtsRequest {
        private final CallsAdvancedBody callsAdvancedBody;

        private SendAdvancedVoiceTtsRequest(CallsAdvancedBody callsAdvancedBody) {
            this.callsAdvancedBody = Objects.requireNonNull(callsAdvancedBody, "The required parameter 'callsAdvancedBody' is missing.");
        }

        public CallsVoiceResponse execute() throws ApiException {
            RequestDefinition sendAdvancedVoiceTtsDefinition = VoiceApi.this.sendAdvancedVoiceTtsDefinition(this.callsAdvancedBody);
            return (CallsVoiceResponse)VoiceApi.this.apiClient.execute(sendAdvancedVoiceTtsDefinition, new TypeReference<CallsVoiceResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsVoiceResponse> callback) {
            RequestDefinition sendAdvancedVoiceTtsDefinition = VoiceApi.this.sendAdvancedVoiceTtsDefinition(this.callsAdvancedBody);
            return VoiceApi.this.apiClient.executeAsync(sendAdvancedVoiceTtsDefinition, new TypeReference<CallsVoiceResponse>(){}.getType(), callback);
        }
    }

    public class SearchVoiceIvrScenariosRequest {
        private Integer page;
        private Integer pageSize;
        private String name;
        private String label;
        private LocalDate lastUsageDateSince;
        private LocalDate lastUsageDateUntil;

        private SearchVoiceIvrScenariosRequest() {
        }

        public SearchVoiceIvrScenariosRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public SearchVoiceIvrScenariosRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public SearchVoiceIvrScenariosRequest name(String name) {
            this.name = name;
            return this;
        }

        public SearchVoiceIvrScenariosRequest label(String label) {
            this.label = label;
            return this;
        }

        public SearchVoiceIvrScenariosRequest lastUsageDateSince(LocalDate lastUsageDateSince) {
            this.lastUsageDateSince = lastUsageDateSince;
            return this;
        }

        public SearchVoiceIvrScenariosRequest lastUsageDateUntil(LocalDate lastUsageDateUntil) {
            this.lastUsageDateUntil = lastUsageDateUntil;
            return this;
        }

        public List<CallsSearchResponse> execute() throws ApiException {
            RequestDefinition searchVoiceIvrScenariosDefinition = VoiceApi.this.searchVoiceIvrScenariosDefinition(this.page, this.pageSize, this.name, this.label, this.lastUsageDateSince, this.lastUsageDateUntil);
            return (List)VoiceApi.this.apiClient.execute(searchVoiceIvrScenariosDefinition, new TypeReference<List<CallsSearchResponse>>(){}.getType());
        }

        public Call executeAsync(ApiCallback<List<CallsSearchResponse>> callback) {
            RequestDefinition searchVoiceIvrScenariosDefinition = VoiceApi.this.searchVoiceIvrScenariosDefinition(this.page, this.pageSize, this.name, this.label, this.lastUsageDateSince, this.lastUsageDateUntil);
            return VoiceApi.this.apiClient.executeAsync(searchVoiceIvrScenariosDefinition, new TypeReference<List<CallsSearchResponse>>(){}.getType(), callback);
        }
    }

    public class SearchVoiceIvrRecordedFilesRequest {
        private Integer page;
        private Integer pageSize;
        private String messageId;
        private String number;

        private SearchVoiceIvrRecordedFilesRequest() {
        }

        public SearchVoiceIvrRecordedFilesRequest page(Integer page) {
            this.page = page;
            return this;
        }

        public SearchVoiceIvrRecordedFilesRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public SearchVoiceIvrRecordedFilesRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public SearchVoiceIvrRecordedFilesRequest number(String number) {
            this.number = number;
            return this;
        }

        public CallsRecordedAudioFilesResponse execute() throws ApiException {
            RequestDefinition searchVoiceIvrRecordedFilesDefinition = VoiceApi.this.searchVoiceIvrRecordedFilesDefinition(this.page, this.pageSize, this.messageId, this.number);
            return (CallsRecordedAudioFilesResponse)VoiceApi.this.apiClient.execute(searchVoiceIvrRecordedFilesDefinition, new TypeReference<CallsRecordedAudioFilesResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsRecordedAudioFilesResponse> callback) {
            RequestDefinition searchVoiceIvrRecordedFilesDefinition = VoiceApi.this.searchVoiceIvrRecordedFilesDefinition(this.page, this.pageSize, this.messageId, this.number);
            return VoiceApi.this.apiClient.executeAsync(searchVoiceIvrRecordedFilesDefinition, new TypeReference<CallsRecordedAudioFilesResponse>(){}.getType(), callback);
        }
    }

    public class RescheduleSentBulkRequest {
        private final String bulkId;
        private final CallsBulkRequest callsBulkRequest;

        private RescheduleSentBulkRequest(String bulkId, CallsBulkRequest callsBulkRequest) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
            this.callsBulkRequest = Objects.requireNonNull(callsBulkRequest, "The required parameter 'callsBulkRequest' is missing.");
        }

        public CallsBulkResponse execute() throws ApiException {
            RequestDefinition rescheduleSentBulkDefinition = VoiceApi.this.rescheduleSentBulkDefinition(this.bulkId, this.callsBulkRequest);
            return (CallsBulkResponse)VoiceApi.this.apiClient.execute(rescheduleSentBulkDefinition, new TypeReference<CallsBulkResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsBulkResponse> callback) {
            RequestDefinition rescheduleSentBulkDefinition = VoiceApi.this.rescheduleSentBulkDefinition(this.bulkId, this.callsBulkRequest);
            return VoiceApi.this.apiClient.executeAsync(rescheduleSentBulkDefinition, new TypeReference<CallsBulkResponse>(){}.getType(), callback);
        }
    }

    public class ManageSentBulksStatusRequest {
        private final String bulkId;
        private final CallsUpdateStatusRequest callsUpdateStatusRequest;

        private ManageSentBulksStatusRequest(String bulkId, CallsUpdateStatusRequest callsUpdateStatusRequest) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
            this.callsUpdateStatusRequest = Objects.requireNonNull(callsUpdateStatusRequest, "The required parameter 'callsUpdateStatusRequest' is missing.");
        }

        public CallsBulkStatusResponse execute() throws ApiException {
            RequestDefinition manageSentBulksStatusDefinition = VoiceApi.this.manageSentBulksStatusDefinition(this.bulkId, this.callsUpdateStatusRequest);
            return (CallsBulkStatusResponse)VoiceApi.this.apiClient.execute(manageSentBulksStatusDefinition, new TypeReference<CallsBulkStatusResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsBulkStatusResponse> callback) {
            RequestDefinition manageSentBulksStatusDefinition = VoiceApi.this.manageSentBulksStatusDefinition(this.bulkId, this.callsUpdateStatusRequest);
            return VoiceApi.this.apiClient.executeAsync(manageSentBulksStatusDefinition, new TypeReference<CallsBulkStatusResponse>(){}.getType(), callback);
        }
    }

    public class GetVoicesRequest {
        private final String language;
        private Boolean includeNeural;

        private GetVoicesRequest(String language) {
            this.language = Objects.requireNonNull(language, "The required parameter 'language' is missing.");
        }

        public GetVoicesRequest includeNeural(Boolean includeNeural) {
            this.includeNeural = includeNeural;
            return this;
        }

        public CallsGetVoicesResponse execute() throws ApiException {
            RequestDefinition getVoicesDefinition = VoiceApi.this.getVoicesDefinition(this.language, this.includeNeural);
            return (CallsGetVoicesResponse)VoiceApi.this.apiClient.execute(getVoicesDefinition, new TypeReference<CallsGetVoicesResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsGetVoicesResponse> callback) {
            RequestDefinition getVoicesDefinition = VoiceApi.this.getVoicesDefinition(this.language, this.includeNeural);
            return VoiceApi.this.apiClient.executeAsync(getVoicesDefinition, new TypeReference<CallsGetVoicesResponse>(){}.getType(), callback);
        }
    }

    public class GetVoiceDeliveryReportsRequest {
        private String bulkId;
        private String messageId;
        private Integer limit;

        private GetVoiceDeliveryReportsRequest() {
        }

        public GetVoiceDeliveryReportsRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetVoiceDeliveryReportsRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetVoiceDeliveryReportsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public CallsReportResponse execute() throws ApiException {
            RequestDefinition getVoiceDeliveryReportsDefinition = VoiceApi.this.getVoiceDeliveryReportsDefinition(this.bulkId, this.messageId, this.limit);
            return (CallsReportResponse)VoiceApi.this.apiClient.execute(getVoiceDeliveryReportsDefinition, new TypeReference<CallsReportResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsReportResponse> callback) {
            RequestDefinition getVoiceDeliveryReportsDefinition = VoiceApi.this.getVoiceDeliveryReportsDefinition(this.bulkId, this.messageId, this.limit);
            return VoiceApi.this.apiClient.executeAsync(getVoiceDeliveryReportsDefinition, new TypeReference<CallsReportResponse>(){}.getType(), callback);
        }
    }

    public class GetSentVoiceLogsRequest {
        private String from;
        private String to;
        private List<String> bulkId;
        private List<String> messageId;
        private CallsIpCoreGeneralStatus generalStatus;
        private OffsetDateTime sentSince;
        private OffsetDateTime sentUntil;
        private Integer limit;
        private String mcc;
        private String mnc;

        private GetSentVoiceLogsRequest() {
        }

        public GetSentVoiceLogsRequest from(String from) {
            this.from = from;
            return this;
        }

        public GetSentVoiceLogsRequest to(String to) {
            this.to = to;
            return this;
        }

        public GetSentVoiceLogsRequest bulkId(List<String> bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetSentVoiceLogsRequest messageId(List<String> messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetSentVoiceLogsRequest generalStatus(CallsIpCoreGeneralStatus generalStatus) {
            this.generalStatus = generalStatus;
            return this;
        }

        public GetSentVoiceLogsRequest sentSince(OffsetDateTime sentSince) {
            this.sentSince = sentSince;
            return this;
        }

        public GetSentVoiceLogsRequest sentUntil(OffsetDateTime sentUntil) {
            this.sentUntil = sentUntil;
            return this;
        }

        public GetSentVoiceLogsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetSentVoiceLogsRequest mcc(String mcc) {
            this.mcc = mcc;
            return this;
        }

        public GetSentVoiceLogsRequest mnc(String mnc) {
            this.mnc = mnc;
            return this;
        }

        public CallsLogsResponse execute() throws ApiException {
            RequestDefinition getSentVoiceLogsDefinition = VoiceApi.this.getSentVoiceLogsDefinition(this.from, this.to, this.bulkId, this.messageId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.mcc, this.mnc);
            return (CallsLogsResponse)VoiceApi.this.apiClient.execute(getSentVoiceLogsDefinition, new TypeReference<CallsLogsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsLogsResponse> callback) {
            RequestDefinition getSentVoiceLogsDefinition = VoiceApi.this.getSentVoiceLogsDefinition(this.from, this.to, this.bulkId, this.messageId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.mcc, this.mnc);
            return VoiceApi.this.apiClient.executeAsync(getSentVoiceLogsDefinition, new TypeReference<CallsLogsResponse>(){}.getType(), callback);
        }
    }

    public class GetSentBulksStatusRequest {
        private final String bulkId;

        private GetSentBulksStatusRequest(String bulkId) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
        }

        public CallsBulkStatusResponse execute() throws ApiException {
            RequestDefinition getSentBulksStatusDefinition = VoiceApi.this.getSentBulksStatusDefinition(this.bulkId);
            return (CallsBulkStatusResponse)VoiceApi.this.apiClient.execute(getSentBulksStatusDefinition, new TypeReference<CallsBulkStatusResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsBulkStatusResponse> callback) {
            RequestDefinition getSentBulksStatusDefinition = VoiceApi.this.getSentBulksStatusDefinition(this.bulkId);
            return VoiceApi.this.apiClient.executeAsync(getSentBulksStatusDefinition, new TypeReference<CallsBulkStatusResponse>(){}.getType(), callback);
        }
    }

    public class GetSentBulksRequest {
        private final String bulkId;

        private GetSentBulksRequest(String bulkId) {
            this.bulkId = Objects.requireNonNull(bulkId, "The required parameter 'bulkId' is missing.");
        }

        public CallsBulkResponse execute() throws ApiException {
            RequestDefinition getSentBulksDefinition = VoiceApi.this.getSentBulksDefinition(this.bulkId);
            return (CallsBulkResponse)VoiceApi.this.apiClient.execute(getSentBulksDefinition, new TypeReference<CallsBulkResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsBulkResponse> callback) {
            RequestDefinition getSentBulksDefinition = VoiceApi.this.getSentBulksDefinition(this.bulkId);
            return VoiceApi.this.apiClient.executeAsync(getSentBulksDefinition, new TypeReference<CallsBulkResponse>(){}.getType(), callback);
        }
    }

    public class GetAVoiceIvrScenarioRequest {
        private final String id;

        private GetAVoiceIvrScenarioRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public CallsUpdateScenarioResponse execute() throws ApiException {
            RequestDefinition getAVoiceIvrScenarioDefinition = VoiceApi.this.getAVoiceIvrScenarioDefinition(this.id);
            return (CallsUpdateScenarioResponse)VoiceApi.this.apiClient.execute(getAVoiceIvrScenarioDefinition, new TypeReference<CallsUpdateScenarioResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsUpdateScenarioResponse> callback) {
            RequestDefinition getAVoiceIvrScenarioDefinition = VoiceApi.this.getAVoiceIvrScenarioDefinition(this.id);
            return VoiceApi.this.apiClient.executeAsync(getAVoiceIvrScenarioDefinition, new TypeReference<CallsUpdateScenarioResponse>(){}.getType(), callback);
        }
    }

    public class DownloadVoiceIvrRecordedFileRequest {
        private final String id;

        private DownloadVoiceIvrRecordedFileRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public File execute() throws ApiException {
            RequestDefinition downloadVoiceIvrRecordedFileDefinition = VoiceApi.this.downloadVoiceIvrRecordedFileDefinition(this.id);
            return (File)VoiceApi.this.apiClient.execute(downloadVoiceIvrRecordedFileDefinition, new TypeReference<File>(){}.getType());
        }

        public Call executeAsync(ApiCallback<File> callback) {
            RequestDefinition downloadVoiceIvrRecordedFileDefinition = VoiceApi.this.downloadVoiceIvrRecordedFileDefinition(this.id);
            return VoiceApi.this.apiClient.executeAsync(downloadVoiceIvrRecordedFileDefinition, new TypeReference<File>(){}.getType(), callback);
        }
    }

    public class DeleteAVoiceIvrScenarioRequest {
        private final String id;

        private DeleteAVoiceIvrScenarioRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition deleteAVoiceIvrScenarioDefinition = VoiceApi.this.deleteAVoiceIvrScenarioDefinition(this.id);
            VoiceApi.this.apiClient.execute(deleteAVoiceIvrScenarioDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition deleteAVoiceIvrScenarioDefinition = VoiceApi.this.deleteAVoiceIvrScenarioDefinition(this.id);
            return VoiceApi.this.apiClient.executeAsync(deleteAVoiceIvrScenarioDefinition, callback);
        }
    }

    public class CreateAVoiceIvrScenarioRequest {
        private final CallsUpdateScenarioRequest callsUpdateScenarioRequest;

        private CreateAVoiceIvrScenarioRequest(CallsUpdateScenarioRequest callsUpdateScenarioRequest) {
            this.callsUpdateScenarioRequest = Objects.requireNonNull(callsUpdateScenarioRequest, "The required parameter 'callsUpdateScenarioRequest' is missing.");
        }

        public CallsUpdateScenarioResponse execute() throws ApiException {
            RequestDefinition createAVoiceIvrScenarioDefinition = VoiceApi.this.createAVoiceIvrScenarioDefinition(this.callsUpdateScenarioRequest);
            return (CallsUpdateScenarioResponse)VoiceApi.this.apiClient.execute(createAVoiceIvrScenarioDefinition, new TypeReference<CallsUpdateScenarioResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<CallsUpdateScenarioResponse> callback) {
            RequestDefinition createAVoiceIvrScenarioDefinition = VoiceApi.this.createAVoiceIvrScenarioDefinition(this.callsUpdateScenarioRequest);
            return VoiceApi.this.apiClient.executeAsync(createAVoiceIvrScenarioDefinition, new TypeReference<CallsUpdateScenarioResponse>(){}.getType(), callback);
        }
    }
}

