/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.MessageGeneralStatus;
import com.infobip.model.MessageResponse;
import com.infobip.model.ViberLogsResponse;
import com.infobip.model.ViberRequest;
import com.infobip.model.ViberWebhookReportsResponse;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import okhttp3.Call;

public class ViberApi {
    private final ApiClient apiClient;

    public ViberApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition getOutboundViberMessageDeliveryReportsDefinition(String bulkId, String messageId, Integer limit, String entityId, String applicationId, String campaignReferenceId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/viber/2/reports").requiresAuthentication(true).accept("application/json");
        if (bulkId != null) {
            builder.addQueryParameter(new Parameter("bulkId", bulkId));
        }
        if (messageId != null) {
            builder.addQueryParameter(new Parameter("messageId", messageId));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (campaignReferenceId != null) {
            builder.addQueryParameter(new Parameter("campaignReferenceId", campaignReferenceId));
        }
        return builder.build();
    }

    public GetOutboundViberMessageDeliveryReportsRequest getOutboundViberMessageDeliveryReports() {
        return new GetOutboundViberMessageDeliveryReportsRequest();
    }

    private RequestDefinition getOutboundViberMessageLogsDefinition(String sender, String destination, List<String> bulkId, List<String> messageId, MessageGeneralStatus generalStatus, OffsetDateTime sentSince, OffsetDateTime sentUntil, Integer limit, String entityId, String applicationId, List<String> campaignReferenceId, Boolean useCursor, String cursor) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/viber/2/logs").requiresAuthentication(true).accept("application/json");
        if (sender != null) {
            builder.addQueryParameter(new Parameter("sender", sender));
        }
        if (destination != null) {
            builder.addQueryParameter(new Parameter("destination", destination));
        }
        if (bulkId != null) {
            for (String parameterItem : bulkId) {
                builder.addQueryParameter(new Parameter("bulkId", parameterItem));
            }
        }
        if (messageId != null) {
            for (String parameterItem : messageId) {
                builder.addQueryParameter(new Parameter("messageId", parameterItem));
            }
        }
        if (generalStatus != null) {
            builder.addQueryParameter(new Parameter("generalStatus", (Object)generalStatus));
        }
        if (sentSince != null) {
            builder.addQueryParameter(new Parameter("sentSince", sentSince));
        }
        if (sentUntil != null) {
            builder.addQueryParameter(new Parameter("sentUntil", sentUntil));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (entityId != null) {
            builder.addQueryParameter(new Parameter("entityId", entityId));
        }
        if (applicationId != null) {
            builder.addQueryParameter(new Parameter("applicationId", applicationId));
        }
        if (campaignReferenceId != null) {
            for (String parameterItem : campaignReferenceId) {
                builder.addQueryParameter(new Parameter("campaignReferenceId", parameterItem));
            }
        }
        if (useCursor != null) {
            builder.addQueryParameter(new Parameter("useCursor", useCursor));
        }
        if (cursor != null) {
            builder.addQueryParameter(new Parameter("cursor", cursor));
        }
        return builder.build();
    }

    public GetOutboundViberMessageLogsRequest getOutboundViberMessageLogs() {
        return new GetOutboundViberMessageLogsRequest();
    }

    private RequestDefinition sendViberMessagesDefinition(ViberRequest viberRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/viber/2/messages").body(viberRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendViberMessagesRequest sendViberMessages(ViberRequest viberRequest) {
        return new SendViberMessagesRequest(viberRequest);
    }

    public class SendViberMessagesRequest {
        private final ViberRequest viberRequest;

        private SendViberMessagesRequest(ViberRequest viberRequest) {
            this.viberRequest = Objects.requireNonNull(viberRequest, "The required parameter 'viberRequest' is missing.");
        }

        public MessageResponse execute() throws ApiException {
            RequestDefinition sendViberMessagesDefinition = ViberApi.this.sendViberMessagesDefinition(this.viberRequest);
            return (MessageResponse)ViberApi.this.apiClient.execute(sendViberMessagesDefinition, new TypeReference<MessageResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MessageResponse> callback) {
            RequestDefinition sendViberMessagesDefinition = ViberApi.this.sendViberMessagesDefinition(this.viberRequest);
            return ViberApi.this.apiClient.executeAsync(sendViberMessagesDefinition, new TypeReference<MessageResponse>(){}.getType(), callback);
        }
    }

    public class GetOutboundViberMessageLogsRequest {
        private String sender;
        private String destination;
        private List<String> bulkId;
        private List<String> messageId;
        private MessageGeneralStatus generalStatus;
        private OffsetDateTime sentSince;
        private OffsetDateTime sentUntil;
        private Integer limit;
        private String entityId;
        private String applicationId;
        private List<String> campaignReferenceId;
        private Boolean useCursor;
        private String cursor;

        private GetOutboundViberMessageLogsRequest() {
        }

        public GetOutboundViberMessageLogsRequest sender(String sender) {
            this.sender = sender;
            return this;
        }

        public GetOutboundViberMessageLogsRequest destination(String destination) {
            this.destination = destination;
            return this;
        }

        public GetOutboundViberMessageLogsRequest bulkId(List<String> bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetOutboundViberMessageLogsRequest messageId(List<String> messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetOutboundViberMessageLogsRequest generalStatus(MessageGeneralStatus generalStatus) {
            this.generalStatus = generalStatus;
            return this;
        }

        public GetOutboundViberMessageLogsRequest sentSince(OffsetDateTime sentSince) {
            this.sentSince = sentSince;
            return this;
        }

        public GetOutboundViberMessageLogsRequest sentUntil(OffsetDateTime sentUntil) {
            this.sentUntil = sentUntil;
            return this;
        }

        public GetOutboundViberMessageLogsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetOutboundViberMessageLogsRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public GetOutboundViberMessageLogsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetOutboundViberMessageLogsRequest campaignReferenceId(List<String> campaignReferenceId) {
            this.campaignReferenceId = campaignReferenceId;
            return this;
        }

        public GetOutboundViberMessageLogsRequest useCursor(Boolean useCursor) {
            this.useCursor = useCursor;
            return this;
        }

        public GetOutboundViberMessageLogsRequest cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ViberLogsResponse execute() throws ApiException {
            RequestDefinition getOutboundViberMessageLogsDefinition = ViberApi.this.getOutboundViberMessageLogsDefinition(this.sender, this.destination, this.bulkId, this.messageId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.entityId, this.applicationId, this.campaignReferenceId, this.useCursor, this.cursor);
            return (ViberLogsResponse)ViberApi.this.apiClient.execute(getOutboundViberMessageLogsDefinition, new TypeReference<ViberLogsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<ViberLogsResponse> callback) {
            RequestDefinition getOutboundViberMessageLogsDefinition = ViberApi.this.getOutboundViberMessageLogsDefinition(this.sender, this.destination, this.bulkId, this.messageId, this.generalStatus, this.sentSince, this.sentUntil, this.limit, this.entityId, this.applicationId, this.campaignReferenceId, this.useCursor, this.cursor);
            return ViberApi.this.apiClient.executeAsync(getOutboundViberMessageLogsDefinition, new TypeReference<ViberLogsResponse>(){}.getType(), callback);
        }
    }

    public class GetOutboundViberMessageDeliveryReportsRequest {
        private String bulkId;
        private String messageId;
        private Integer limit;
        private String entityId;
        private String applicationId;
        private String campaignReferenceId;

        private GetOutboundViberMessageDeliveryReportsRequest() {
        }

        public GetOutboundViberMessageDeliveryReportsRequest bulkId(String bulkId) {
            this.bulkId = bulkId;
            return this;
        }

        public GetOutboundViberMessageDeliveryReportsRequest messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public GetOutboundViberMessageDeliveryReportsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetOutboundViberMessageDeliveryReportsRequest entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public GetOutboundViberMessageDeliveryReportsRequest applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public GetOutboundViberMessageDeliveryReportsRequest campaignReferenceId(String campaignReferenceId) {
            this.campaignReferenceId = campaignReferenceId;
            return this;
        }

        public ViberWebhookReportsResponse execute() throws ApiException {
            RequestDefinition getOutboundViberMessageDeliveryReportsDefinition = ViberApi.this.getOutboundViberMessageDeliveryReportsDefinition(this.bulkId, this.messageId, this.limit, this.entityId, this.applicationId, this.campaignReferenceId);
            return (ViberWebhookReportsResponse)ViberApi.this.apiClient.execute(getOutboundViberMessageDeliveryReportsDefinition, new TypeReference<ViberWebhookReportsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<ViberWebhookReportsResponse> callback) {
            RequestDefinition getOutboundViberMessageDeliveryReportsDefinition = ViberApi.this.getOutboundViberMessageDeliveryReportsDefinition(this.bulkId, this.messageId, this.limit, this.entityId, this.applicationId, this.campaignReferenceId);
            return ViberApi.this.apiClient.executeAsync(getOutboundViberMessageDeliveryReportsDefinition, new TypeReference<ViberWebhookReportsResponse>(){}.getType(), callback);
        }
    }
}

