/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.NumberMaskingCredentialsBody;
import com.infobip.model.NumberMaskingCredentialsResponse;
import com.infobip.model.NumberMaskingSetupBody;
import com.infobip.model.NumberMaskingSetupResponse;
import com.infobip.model.NumberMaskingUploadBody;
import com.infobip.model.NumberMaskingUploadResponse;
import java.util.List;
import java.util.Objects;
import okhttp3.Call;

public class NumberMaskingApi {
    private final ApiClient apiClient;

    public NumberMaskingApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition createNumberMaskingConfigurationDefinition(NumberMaskingSetupBody numberMaskingSetupBody) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/voice/masking/2/config").body(numberMaskingSetupBody).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateNumberMaskingConfigurationRequest createNumberMaskingConfiguration(NumberMaskingSetupBody numberMaskingSetupBody) {
        return new CreateNumberMaskingConfigurationRequest(numberMaskingSetupBody);
    }

    private RequestDefinition createNumberMaskingCredentialsDefinition(NumberMaskingCredentialsBody numberMaskingCredentialsBody) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/voice/masking/2/credentials").body(numberMaskingCredentialsBody).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public CreateNumberMaskingCredentialsRequest createNumberMaskingCredentials(NumberMaskingCredentialsBody numberMaskingCredentialsBody) {
        return new CreateNumberMaskingCredentialsRequest(numberMaskingCredentialsBody);
    }

    private RequestDefinition deleteNumberMaskingConfigurationDefinition(String key) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/voice/masking/2/config/{key}").requiresAuthentication(true).accept("application/json");
        if (key != null) {
            builder.addPathParameter(new Parameter("key", key));
        }
        return builder.build();
    }

    public DeleteNumberMaskingConfigurationRequest deleteNumberMaskingConfiguration(String key) {
        return new DeleteNumberMaskingConfigurationRequest(key);
    }

    private RequestDefinition deleteNumberMaskingCredentialsDefinition() {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/voice/masking/2/credentials").requiresAuthentication(true).accept("application/json");
        return builder.build();
    }

    public DeleteNumberMaskingCredentialsRequest deleteNumberMaskingCredentials() {
        return new DeleteNumberMaskingCredentialsRequest();
    }

    private RequestDefinition getNumberMaskingConfigurationDefinition(String key) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/voice/masking/2/config/{key}").requiresAuthentication(true).accept("application/json");
        if (key != null) {
            builder.addPathParameter(new Parameter("key", key));
        }
        return builder.build();
    }

    public GetNumberMaskingConfigurationRequest getNumberMaskingConfiguration(String key) {
        return new GetNumberMaskingConfigurationRequest(key);
    }

    private RequestDefinition getNumberMaskingConfigurationsDefinition() {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/voice/masking/2/config").requiresAuthentication(true).accept("application/json");
        return builder.build();
    }

    public GetNumberMaskingConfigurationsRequest getNumberMaskingConfigurations() {
        return new GetNumberMaskingConfigurationsRequest();
    }

    private RequestDefinition getNumberMaskingCredentialsDefinition() {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/voice/masking/2/credentials").requiresAuthentication(true).accept("application/json");
        return builder.build();
    }

    public GetNumberMaskingCredentialsRequest getNumberMaskingCredentials() {
        return new GetNumberMaskingCredentialsRequest();
    }

    private RequestDefinition updateNumberMaskingConfigurationDefinition(String key, NumberMaskingSetupBody numberMaskingSetupBody) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/voice/masking/2/config/{key}").body(numberMaskingSetupBody).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (key != null) {
            builder.addPathParameter(new Parameter("key", key));
        }
        return builder.build();
    }

    public UpdateNumberMaskingConfigurationRequest updateNumberMaskingConfiguration(String key, NumberMaskingSetupBody numberMaskingSetupBody) {
        return new UpdateNumberMaskingConfigurationRequest(key, numberMaskingSetupBody);
    }

    private RequestDefinition updateNumberMaskingCredentialsDefinition(NumberMaskingCredentialsBody numberMaskingCredentialsBody) {
        RequestDefinition.Builder builder = RequestDefinition.builder("PUT", "/voice/masking/2/credentials").body(numberMaskingCredentialsBody).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public UpdateNumberMaskingCredentialsRequest updateNumberMaskingCredentials(NumberMaskingCredentialsBody numberMaskingCredentialsBody) {
        return new UpdateNumberMaskingCredentialsRequest(numberMaskingCredentialsBody);
    }

    private RequestDefinition uploadAudioFilesDefinition(NumberMaskingUploadBody numberMaskingUploadBody) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/voice/masking/1/upload").body(numberMaskingUploadBody).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public UploadAudioFilesRequest uploadAudioFiles(NumberMaskingUploadBody numberMaskingUploadBody) {
        return new UploadAudioFilesRequest(numberMaskingUploadBody);
    }

    public class UploadAudioFilesRequest {
        private final NumberMaskingUploadBody numberMaskingUploadBody;

        private UploadAudioFilesRequest(NumberMaskingUploadBody numberMaskingUploadBody) {
            this.numberMaskingUploadBody = Objects.requireNonNull(numberMaskingUploadBody, "The required parameter 'numberMaskingUploadBody' is missing.");
        }

        public NumberMaskingUploadResponse execute() throws ApiException {
            RequestDefinition uploadAudioFilesDefinition = NumberMaskingApi.this.uploadAudioFilesDefinition(this.numberMaskingUploadBody);
            return (NumberMaskingUploadResponse)NumberMaskingApi.this.apiClient.execute(uploadAudioFilesDefinition, new TypeReference<NumberMaskingUploadResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<NumberMaskingUploadResponse> callback) {
            RequestDefinition uploadAudioFilesDefinition = NumberMaskingApi.this.uploadAudioFilesDefinition(this.numberMaskingUploadBody);
            return NumberMaskingApi.this.apiClient.executeAsync(uploadAudioFilesDefinition, new TypeReference<NumberMaskingUploadResponse>(){}.getType(), callback);
        }
    }

    public class UpdateNumberMaskingCredentialsRequest {
        private final NumberMaskingCredentialsBody numberMaskingCredentialsBody;

        private UpdateNumberMaskingCredentialsRequest(NumberMaskingCredentialsBody numberMaskingCredentialsBody) {
            this.numberMaskingCredentialsBody = Objects.requireNonNull(numberMaskingCredentialsBody, "The required parameter 'numberMaskingCredentialsBody' is missing.");
        }

        public NumberMaskingCredentialsResponse execute() throws ApiException {
            RequestDefinition updateNumberMaskingCredentialsDefinition = NumberMaskingApi.this.updateNumberMaskingCredentialsDefinition(this.numberMaskingCredentialsBody);
            return (NumberMaskingCredentialsResponse)NumberMaskingApi.this.apiClient.execute(updateNumberMaskingCredentialsDefinition, new TypeReference<NumberMaskingCredentialsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<NumberMaskingCredentialsResponse> callback) {
            RequestDefinition updateNumberMaskingCredentialsDefinition = NumberMaskingApi.this.updateNumberMaskingCredentialsDefinition(this.numberMaskingCredentialsBody);
            return NumberMaskingApi.this.apiClient.executeAsync(updateNumberMaskingCredentialsDefinition, new TypeReference<NumberMaskingCredentialsResponse>(){}.getType(), callback);
        }
    }

    public class UpdateNumberMaskingConfigurationRequest {
        private final String key;
        private final NumberMaskingSetupBody numberMaskingSetupBody;

        private UpdateNumberMaskingConfigurationRequest(String key, NumberMaskingSetupBody numberMaskingSetupBody) {
            this.key = Objects.requireNonNull(key, "The required parameter 'key' is missing.");
            this.numberMaskingSetupBody = Objects.requireNonNull(numberMaskingSetupBody, "The required parameter 'numberMaskingSetupBody' is missing.");
        }

        public NumberMaskingSetupResponse execute() throws ApiException {
            RequestDefinition updateNumberMaskingConfigurationDefinition = NumberMaskingApi.this.updateNumberMaskingConfigurationDefinition(this.key, this.numberMaskingSetupBody);
            return (NumberMaskingSetupResponse)NumberMaskingApi.this.apiClient.execute(updateNumberMaskingConfigurationDefinition, new TypeReference<NumberMaskingSetupResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<NumberMaskingSetupResponse> callback) {
            RequestDefinition updateNumberMaskingConfigurationDefinition = NumberMaskingApi.this.updateNumberMaskingConfigurationDefinition(this.key, this.numberMaskingSetupBody);
            return NumberMaskingApi.this.apiClient.executeAsync(updateNumberMaskingConfigurationDefinition, new TypeReference<NumberMaskingSetupResponse>(){}.getType(), callback);
        }
    }

    public class GetNumberMaskingCredentialsRequest {
        private GetNumberMaskingCredentialsRequest() {
        }

        public NumberMaskingCredentialsResponse execute() throws ApiException {
            RequestDefinition getNumberMaskingCredentialsDefinition = NumberMaskingApi.this.getNumberMaskingCredentialsDefinition();
            return (NumberMaskingCredentialsResponse)NumberMaskingApi.this.apiClient.execute(getNumberMaskingCredentialsDefinition, new TypeReference<NumberMaskingCredentialsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<NumberMaskingCredentialsResponse> callback) {
            RequestDefinition getNumberMaskingCredentialsDefinition = NumberMaskingApi.this.getNumberMaskingCredentialsDefinition();
            return NumberMaskingApi.this.apiClient.executeAsync(getNumberMaskingCredentialsDefinition, new TypeReference<NumberMaskingCredentialsResponse>(){}.getType(), callback);
        }
    }

    public class GetNumberMaskingConfigurationsRequest {
        private GetNumberMaskingConfigurationsRequest() {
        }

        public List<NumberMaskingSetupResponse> execute() throws ApiException {
            RequestDefinition getNumberMaskingConfigurationsDefinition = NumberMaskingApi.this.getNumberMaskingConfigurationsDefinition();
            return (List)NumberMaskingApi.this.apiClient.execute(getNumberMaskingConfigurationsDefinition, new TypeReference<List<NumberMaskingSetupResponse>>(){}.getType());
        }

        public Call executeAsync(ApiCallback<List<NumberMaskingSetupResponse>> callback) {
            RequestDefinition getNumberMaskingConfigurationsDefinition = NumberMaskingApi.this.getNumberMaskingConfigurationsDefinition();
            return NumberMaskingApi.this.apiClient.executeAsync(getNumberMaskingConfigurationsDefinition, new TypeReference<List<NumberMaskingSetupResponse>>(){}.getType(), callback);
        }
    }

    public class GetNumberMaskingConfigurationRequest {
        private final String key;

        private GetNumberMaskingConfigurationRequest(String key) {
            this.key = Objects.requireNonNull(key, "The required parameter 'key' is missing.");
        }

        public NumberMaskingSetupResponse execute() throws ApiException {
            RequestDefinition getNumberMaskingConfigurationDefinition = NumberMaskingApi.this.getNumberMaskingConfigurationDefinition(this.key);
            return (NumberMaskingSetupResponse)NumberMaskingApi.this.apiClient.execute(getNumberMaskingConfigurationDefinition, new TypeReference<NumberMaskingSetupResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<NumberMaskingSetupResponse> callback) {
            RequestDefinition getNumberMaskingConfigurationDefinition = NumberMaskingApi.this.getNumberMaskingConfigurationDefinition(this.key);
            return NumberMaskingApi.this.apiClient.executeAsync(getNumberMaskingConfigurationDefinition, new TypeReference<NumberMaskingSetupResponse>(){}.getType(), callback);
        }
    }

    public class DeleteNumberMaskingCredentialsRequest {
        private DeleteNumberMaskingCredentialsRequest() {
        }

        public void execute() throws ApiException {
            RequestDefinition deleteNumberMaskingCredentialsDefinition = NumberMaskingApi.this.deleteNumberMaskingCredentialsDefinition();
            NumberMaskingApi.this.apiClient.execute(deleteNumberMaskingCredentialsDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition deleteNumberMaskingCredentialsDefinition = NumberMaskingApi.this.deleteNumberMaskingCredentialsDefinition();
            return NumberMaskingApi.this.apiClient.executeAsync(deleteNumberMaskingCredentialsDefinition, callback);
        }
    }

    public class DeleteNumberMaskingConfigurationRequest {
        private final String key;

        private DeleteNumberMaskingConfigurationRequest(String key) {
            this.key = Objects.requireNonNull(key, "The required parameter 'key' is missing.");
        }

        public void execute() throws ApiException {
            RequestDefinition deleteNumberMaskingConfigurationDefinition = NumberMaskingApi.this.deleteNumberMaskingConfigurationDefinition(this.key);
            NumberMaskingApi.this.apiClient.execute(deleteNumberMaskingConfigurationDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition deleteNumberMaskingConfigurationDefinition = NumberMaskingApi.this.deleteNumberMaskingConfigurationDefinition(this.key);
            return NumberMaskingApi.this.apiClient.executeAsync(deleteNumberMaskingConfigurationDefinition, callback);
        }
    }

    public class CreateNumberMaskingCredentialsRequest {
        private final NumberMaskingCredentialsBody numberMaskingCredentialsBody;

        private CreateNumberMaskingCredentialsRequest(NumberMaskingCredentialsBody numberMaskingCredentialsBody) {
            this.numberMaskingCredentialsBody = Objects.requireNonNull(numberMaskingCredentialsBody, "The required parameter 'numberMaskingCredentialsBody' is missing.");
        }

        public NumberMaskingCredentialsResponse execute() throws ApiException {
            RequestDefinition createNumberMaskingCredentialsDefinition = NumberMaskingApi.this.createNumberMaskingCredentialsDefinition(this.numberMaskingCredentialsBody);
            return (NumberMaskingCredentialsResponse)NumberMaskingApi.this.apiClient.execute(createNumberMaskingCredentialsDefinition, new TypeReference<NumberMaskingCredentialsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<NumberMaskingCredentialsResponse> callback) {
            RequestDefinition createNumberMaskingCredentialsDefinition = NumberMaskingApi.this.createNumberMaskingCredentialsDefinition(this.numberMaskingCredentialsBody);
            return NumberMaskingApi.this.apiClient.executeAsync(createNumberMaskingCredentialsDefinition, new TypeReference<NumberMaskingCredentialsResponse>(){}.getType(), callback);
        }
    }

    public class CreateNumberMaskingConfigurationRequest {
        private final NumberMaskingSetupBody numberMaskingSetupBody;

        private CreateNumberMaskingConfigurationRequest(NumberMaskingSetupBody numberMaskingSetupBody) {
            this.numberMaskingSetupBody = Objects.requireNonNull(numberMaskingSetupBody, "The required parameter 'numberMaskingSetupBody' is missing.");
        }

        public NumberMaskingSetupResponse execute() throws ApiException {
            RequestDefinition createNumberMaskingConfigurationDefinition = NumberMaskingApi.this.createNumberMaskingConfigurationDefinition(this.numberMaskingSetupBody);
            return (NumberMaskingSetupResponse)NumberMaskingApi.this.apiClient.execute(createNumberMaskingConfigurationDefinition, new TypeReference<NumberMaskingSetupResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<NumberMaskingSetupResponse> callback) {
            RequestDefinition createNumberMaskingConfigurationDefinition = NumberMaskingApi.this.createNumberMaskingConfigurationDefinition(this.numberMaskingSetupBody);
            return NumberMaskingApi.this.apiClient.executeAsync(createNumberMaskingConfigurationDefinition, new TypeReference<NumberMaskingSetupResponse>(){}.getType(), callback);
        }
    }
}

