/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.RequestDefinition;
import com.infobip.model.MessageResponse;
import com.infobip.model.MessagesApiEventRequest;
import com.infobip.model.MessagesApiRequest;
import com.infobip.model.MessagesApiValidationOkResponse;
import java.util.Objects;
import okhttp3.Call;

public class MessagesApi {
    private final ApiClient apiClient;

    public MessagesApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition sendMessagesApiEventsDefinition(MessagesApiEventRequest messagesApiEventRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/messages-api/1/events").body(messagesApiEventRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendMessagesApiEventsRequest sendMessagesApiEvents(MessagesApiEventRequest messagesApiEventRequest) {
        return new SendMessagesApiEventsRequest(messagesApiEventRequest);
    }

    private RequestDefinition sendMessagesApiMessageDefinition(MessagesApiRequest messagesApiRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/messages-api/1/messages").body(messagesApiRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public SendMessagesApiMessageRequest sendMessagesApiMessage(MessagesApiRequest messagesApiRequest) {
        return new SendMessagesApiMessageRequest(messagesApiRequest);
    }

    private RequestDefinition validateMessagesApiMessageDefinition(MessagesApiRequest messagesApiRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/messages-api/1/messages/validate").body(messagesApiRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        return builder.build();
    }

    public ValidateMessagesApiMessageRequest validateMessagesApiMessage(MessagesApiRequest messagesApiRequest) {
        return new ValidateMessagesApiMessageRequest(messagesApiRequest);
    }

    public class ValidateMessagesApiMessageRequest {
        private final MessagesApiRequest messagesApiRequest;

        private ValidateMessagesApiMessageRequest(MessagesApiRequest messagesApiRequest) {
            this.messagesApiRequest = Objects.requireNonNull(messagesApiRequest, "The required parameter 'messagesApiRequest' is missing.");
        }

        public MessagesApiValidationOkResponse execute() throws ApiException {
            RequestDefinition validateMessagesApiMessageDefinition = MessagesApi.this.validateMessagesApiMessageDefinition(this.messagesApiRequest);
            return (MessagesApiValidationOkResponse)MessagesApi.this.apiClient.execute(validateMessagesApiMessageDefinition, new TypeReference<MessagesApiValidationOkResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MessagesApiValidationOkResponse> callback) {
            RequestDefinition validateMessagesApiMessageDefinition = MessagesApi.this.validateMessagesApiMessageDefinition(this.messagesApiRequest);
            return MessagesApi.this.apiClient.executeAsync(validateMessagesApiMessageDefinition, new TypeReference<MessagesApiValidationOkResponse>(){}.getType(), callback);
        }
    }

    public class SendMessagesApiMessageRequest {
        private final MessagesApiRequest messagesApiRequest;

        private SendMessagesApiMessageRequest(MessagesApiRequest messagesApiRequest) {
            this.messagesApiRequest = Objects.requireNonNull(messagesApiRequest, "The required parameter 'messagesApiRequest' is missing.");
        }

        public MessageResponse execute() throws ApiException {
            RequestDefinition sendMessagesApiMessageDefinition = MessagesApi.this.sendMessagesApiMessageDefinition(this.messagesApiRequest);
            return (MessageResponse)MessagesApi.this.apiClient.execute(sendMessagesApiMessageDefinition, new TypeReference<MessageResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MessageResponse> callback) {
            RequestDefinition sendMessagesApiMessageDefinition = MessagesApi.this.sendMessagesApiMessageDefinition(this.messagesApiRequest);
            return MessagesApi.this.apiClient.executeAsync(sendMessagesApiMessageDefinition, new TypeReference<MessageResponse>(){}.getType(), callback);
        }
    }

    public class SendMessagesApiEventsRequest {
        private final MessagesApiEventRequest messagesApiEventRequest;

        private SendMessagesApiEventsRequest(MessagesApiEventRequest messagesApiEventRequest) {
            this.messagesApiEventRequest = Objects.requireNonNull(messagesApiEventRequest, "The required parameter 'messagesApiEventRequest' is missing.");
        }

        public MessageResponse execute() throws ApiException {
            RequestDefinition sendMessagesApiEventsDefinition = MessagesApi.this.sendMessagesApiEventsDefinition(this.messagesApiEventRequest);
            return (MessageResponse)MessagesApi.this.apiClient.execute(sendMessagesApiEventsDefinition, new TypeReference<MessageResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<MessageResponse> callback) {
            RequestDefinition sendMessagesApiEventsDefinition = MessagesApi.this.sendMessagesApiEventsDefinition(this.messagesApiEventRequest);
            return MessagesApi.this.apiClient.executeAsync(sendMessagesApiEventsDefinition, new TypeReference<MessageResponse>(){}.getType(), callback);
        }
    }
}

