/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.FormsResponse;
import com.infobip.model.FormsResponseContent;
import com.infobip.model.FormsStatus;
import com.infobip.model.FormsStatusResponse;
import java.util.Map;
import java.util.Objects;
import okhttp3.Call;

public class FormsApi {
    private final ApiClient apiClient;

    public FormsApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition getFormDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/forms/1/forms/{id}").requiresAuthentication(true).accept("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public GetFormRequest getForm(String id) {
        return new GetFormRequest(id);
    }

    private RequestDefinition getFormsDefinition(Integer offset, Integer limit, String formType, FormsStatus formStatus) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/forms/1/forms").requiresAuthentication(true).accept("application/json");
        if (offset != null) {
            builder.addQueryParameter(new Parameter("offset", offset));
        }
        if (limit != null) {
            builder.addQueryParameter(new Parameter("limit", limit));
        }
        if (formType != null) {
            builder.addQueryParameter(new Parameter("formType", formType));
        }
        if (formStatus != null) {
            builder.addQueryParameter(new Parameter("formStatus", (Object)formStatus));
        }
        return builder.build();
    }

    public GetFormsRequest getForms() {
        return new GetFormsRequest();
    }

    private RequestDefinition incrementViewCountDefinition(String id) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/forms/1/forms/{id}/views").requiresAuthentication(true).accept("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        return builder.build();
    }

    public IncrementViewCountRequest incrementViewCount(String id) {
        return new IncrementViewCountRequest(id);
    }

    private RequestDefinition submitFormDataDefinition(String id, Map<String, Object> requestBody, String ibSubmissionSource, String ibSubmissionFormCampaign) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/forms/1/forms/{id}/data").body(requestBody).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (id != null) {
            builder.addPathParameter(new Parameter("id", id));
        }
        if (ibSubmissionSource != null) {
            builder.addHeaderParameter(new Parameter("ib-submission-source", ibSubmissionSource));
        }
        if (ibSubmissionFormCampaign != null) {
            builder.addHeaderParameter(new Parameter("ib-submission-form-campaign", ibSubmissionFormCampaign));
        }
        return builder.build();
    }

    public SubmitFormDataRequest submitFormData(String id, Map<String, Object> requestBody) {
        return new SubmitFormDataRequest(id, requestBody);
    }

    public class SubmitFormDataRequest {
        private final String id;
        private final Map<String, Object> requestBody;
        private String ibSubmissionSource;
        private String ibSubmissionFormCampaign;

        private SubmitFormDataRequest(String id, Map<String, Object> requestBody) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
            this.requestBody = Objects.requireNonNull(requestBody, "The required parameter 'requestBody' is missing.");
        }

        public SubmitFormDataRequest ibSubmissionSource(String ibSubmissionSource) {
            this.ibSubmissionSource = ibSubmissionSource;
            return this;
        }

        public SubmitFormDataRequest ibSubmissionFormCampaign(String ibSubmissionFormCampaign) {
            this.ibSubmissionFormCampaign = ibSubmissionFormCampaign;
            return this;
        }

        public FormsStatusResponse execute() throws ApiException {
            RequestDefinition submitFormDataDefinition = FormsApi.this.submitFormDataDefinition(this.id, this.requestBody, this.ibSubmissionSource, this.ibSubmissionFormCampaign);
            return (FormsStatusResponse)FormsApi.this.apiClient.execute(submitFormDataDefinition, new TypeReference<FormsStatusResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<FormsStatusResponse> callback) {
            RequestDefinition submitFormDataDefinition = FormsApi.this.submitFormDataDefinition(this.id, this.requestBody, this.ibSubmissionSource, this.ibSubmissionFormCampaign);
            return FormsApi.this.apiClient.executeAsync(submitFormDataDefinition, new TypeReference<FormsStatusResponse>(){}.getType(), callback);
        }
    }

    public class IncrementViewCountRequest {
        private final String id;

        private IncrementViewCountRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public FormsStatusResponse execute() throws ApiException {
            RequestDefinition incrementViewCountDefinition = FormsApi.this.incrementViewCountDefinition(this.id);
            return (FormsStatusResponse)FormsApi.this.apiClient.execute(incrementViewCountDefinition, new TypeReference<FormsStatusResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<FormsStatusResponse> callback) {
            RequestDefinition incrementViewCountDefinition = FormsApi.this.incrementViewCountDefinition(this.id);
            return FormsApi.this.apiClient.executeAsync(incrementViewCountDefinition, new TypeReference<FormsStatusResponse>(){}.getType(), callback);
        }
    }

    public class GetFormsRequest {
        private Integer offset;
        private Integer limit;
        private String formType;
        private FormsStatus formStatus;

        private GetFormsRequest() {
        }

        public GetFormsRequest offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public GetFormsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public GetFormsRequest formType(String formType) {
            this.formType = formType;
            return this;
        }

        public GetFormsRequest formStatus(FormsStatus formStatus) {
            this.formStatus = formStatus;
            return this;
        }

        public FormsResponse execute() throws ApiException {
            RequestDefinition getFormsDefinition = FormsApi.this.getFormsDefinition(this.offset, this.limit, this.formType, this.formStatus);
            return (FormsResponse)FormsApi.this.apiClient.execute(getFormsDefinition, new TypeReference<FormsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<FormsResponse> callback) {
            RequestDefinition getFormsDefinition = FormsApi.this.getFormsDefinition(this.offset, this.limit, this.formType, this.formStatus);
            return FormsApi.this.apiClient.executeAsync(getFormsDefinition, new TypeReference<FormsResponse>(){}.getType(), callback);
        }
    }

    public class GetFormRequest {
        private final String id;

        private GetFormRequest(String id) {
            this.id = Objects.requireNonNull(id, "The required parameter 'id' is missing.");
        }

        public FormsResponseContent execute() throws ApiException {
            RequestDefinition getFormDefinition = FormsApi.this.getFormDefinition(this.id);
            return (FormsResponseContent)FormsApi.this.apiClient.execute(getFormDefinition, new TypeReference<FormsResponseContent>(){}.getType());
        }

        public Call executeAsync(ApiCallback<FormsResponseContent> callback) {
            RequestDefinition getFormDefinition = FormsApi.this.getFormDefinition(this.id);
            return FormsApi.this.apiClient.executeAsync(getFormDefinition, new TypeReference<FormsResponseContent>(){}.getType(), callback);
        }
    }
}

