/*
 * Decompiled with CFR 0.152.
 */
package com.infobip.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.infobip.ApiCallback;
import com.infobip.ApiClient;
import com.infobip.ApiException;
import com.infobip.Parameter;
import com.infobip.RequestDefinition;
import com.infobip.model.FlowAddFlowParticipantsRequest;
import com.infobip.model.FlowAddFlowParticipantsResponse;
import com.infobip.model.FlowParticipantsReportResponse;
import java.util.Objects;
import okhttp3.Call;

public class FlowApi {
    private final ApiClient apiClient;

    public FlowApi(ApiClient apiClient) {
        this.apiClient = Objects.requireNonNull(apiClient, "ApiClient must not be null!");
    }

    private RequestDefinition addFlowParticipantsDefinition(Long campaignId, FlowAddFlowParticipantsRequest flowAddFlowParticipantsRequest) {
        RequestDefinition.Builder builder = RequestDefinition.builder("POST", "/moments/1/flows/{campaignId}/participants").body(flowAddFlowParticipantsRequest).requiresAuthentication(true).accept("application/json").contentType("application/json");
        if (campaignId != null) {
            builder.addPathParameter(new Parameter("campaignId", campaignId));
        }
        return builder.build();
    }

    public AddFlowParticipantsRequest addFlowParticipants(Long campaignId, FlowAddFlowParticipantsRequest flowAddFlowParticipantsRequest) {
        return new AddFlowParticipantsRequest(campaignId, flowAddFlowParticipantsRequest);
    }

    private RequestDefinition getFlowParticipantsAddedReportDefinition(Long campaignId, String operationId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("GET", "/moments/1/flows/{campaignId}/participants/report").requiresAuthentication(true).accept("application/json");
        if (campaignId != null) {
            builder.addPathParameter(new Parameter("campaignId", campaignId));
        }
        if (operationId != null) {
            builder.addQueryParameter(new Parameter("operationId", operationId));
        }
        return builder.build();
    }

    public GetFlowParticipantsAddedReportRequest getFlowParticipantsAddedReport(Long campaignId, String operationId) {
        return new GetFlowParticipantsAddedReportRequest(campaignId, operationId);
    }

    private RequestDefinition removePeopleFromFlowDefinition(Long campaignId, String phone, String email, String externalId) {
        RequestDefinition.Builder builder = RequestDefinition.builder("DELETE", "/communication/1/flows/{campaignId}/participants").requiresAuthentication(true).accept("application/json");
        if (campaignId != null) {
            builder.addPathParameter(new Parameter("campaignId", campaignId));
        }
        if (phone != null) {
            builder.addQueryParameter(new Parameter("phone", phone));
        }
        if (email != null) {
            builder.addQueryParameter(new Parameter("email", email));
        }
        if (externalId != null) {
            builder.addQueryParameter(new Parameter("externalId", externalId));
        }
        return builder.build();
    }

    public RemovePeopleFromFlowRequest removePeopleFromFlow(Long campaignId) {
        return new RemovePeopleFromFlowRequest(campaignId);
    }

    public class RemovePeopleFromFlowRequest {
        private final Long campaignId;
        private String phone;
        private String email;
        private String externalId;

        private RemovePeopleFromFlowRequest(Long campaignId) {
            this.campaignId = Objects.requireNonNull(campaignId, "The required parameter 'campaignId' is missing.");
        }

        public RemovePeopleFromFlowRequest phone(String phone) {
            this.phone = phone;
            return this;
        }

        public RemovePeopleFromFlowRequest email(String email) {
            this.email = email;
            return this;
        }

        public RemovePeopleFromFlowRequest externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public void execute() throws ApiException {
            RequestDefinition removePeopleFromFlowDefinition = FlowApi.this.removePeopleFromFlowDefinition(this.campaignId, this.phone, this.email, this.externalId);
            FlowApi.this.apiClient.execute(removePeopleFromFlowDefinition);
        }

        public Call executeAsync(ApiCallback<Void> callback) {
            RequestDefinition removePeopleFromFlowDefinition = FlowApi.this.removePeopleFromFlowDefinition(this.campaignId, this.phone, this.email, this.externalId);
            return FlowApi.this.apiClient.executeAsync(removePeopleFromFlowDefinition, callback);
        }
    }

    public class GetFlowParticipantsAddedReportRequest {
        private final Long campaignId;
        private final String operationId;

        private GetFlowParticipantsAddedReportRequest(Long campaignId, String operationId) {
            this.campaignId = Objects.requireNonNull(campaignId, "The required parameter 'campaignId' is missing.");
            this.operationId = Objects.requireNonNull(operationId, "The required parameter 'operationId' is missing.");
        }

        public FlowParticipantsReportResponse execute() throws ApiException {
            RequestDefinition getFlowParticipantsAddedReportDefinition = FlowApi.this.getFlowParticipantsAddedReportDefinition(this.campaignId, this.operationId);
            return (FlowParticipantsReportResponse)FlowApi.this.apiClient.execute(getFlowParticipantsAddedReportDefinition, new TypeReference<FlowParticipantsReportResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<FlowParticipantsReportResponse> callback) {
            RequestDefinition getFlowParticipantsAddedReportDefinition = FlowApi.this.getFlowParticipantsAddedReportDefinition(this.campaignId, this.operationId);
            return FlowApi.this.apiClient.executeAsync(getFlowParticipantsAddedReportDefinition, new TypeReference<FlowParticipantsReportResponse>(){}.getType(), callback);
        }
    }

    public class AddFlowParticipantsRequest {
        private final Long campaignId;
        private final FlowAddFlowParticipantsRequest flowAddFlowParticipantsRequest;

        private AddFlowParticipantsRequest(Long campaignId, FlowAddFlowParticipantsRequest flowAddFlowParticipantsRequest) {
            this.campaignId = Objects.requireNonNull(campaignId, "The required parameter 'campaignId' is missing.");
            this.flowAddFlowParticipantsRequest = Objects.requireNonNull(flowAddFlowParticipantsRequest, "The required parameter 'flowAddFlowParticipantsRequest' is missing.");
        }

        public FlowAddFlowParticipantsResponse execute() throws ApiException {
            RequestDefinition addFlowParticipantsDefinition = FlowApi.this.addFlowParticipantsDefinition(this.campaignId, this.flowAddFlowParticipantsRequest);
            return (FlowAddFlowParticipantsResponse)FlowApi.this.apiClient.execute(addFlowParticipantsDefinition, new TypeReference<FlowAddFlowParticipantsResponse>(){}.getType());
        }

        public Call executeAsync(ApiCallback<FlowAddFlowParticipantsResponse> callback) {
            RequestDefinition addFlowParticipantsDefinition = FlowApi.this.addFlowParticipantsDefinition(this.campaignId, this.flowAddFlowParticipantsRequest);
            return FlowApi.this.apiClient.executeAsync(addFlowParticipantsDefinition, new TypeReference<FlowAddFlowParticipantsResponse>(){}.getType(), callback);
        }
    }
}

