/*
 * Decompiled with CFR 0.152.
 */
package com.infobip;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.infobip.ApiException;
import com.infobip.ApiExceptionDetails;
import com.infobip.ApiExceptionDetailsResolver;
import com.infobip.ApiExceptionWrapper;
import com.infobip.DeprecationChecker;
import com.infobip.Downloader;
import com.infobip.JSON;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Objects;
import okhttp3.Response;
import okhttp3.ResponseBody;

final class ResponseProcessor {
    private final Downloader downloader;
    private final JSON json;
    private final DeprecationChecker deprecationChecker;
    private final ApiExceptionDetailsResolver apiExceptionDetailsResolver = new ApiExceptionDetailsResolver();
    private final ErrorResponseSerializer errorResponseSerializer = new ErrorResponseSerializer();

    ResponseProcessor(Downloader downloader, JSON json, DeprecationChecker deprecationChecker) {
        this.downloader = Objects.requireNonNull(downloader);
        this.json = Objects.requireNonNull(json);
        this.deprecationChecker = Objects.requireNonNull(deprecationChecker);
    }

    <T> T processResponse(Response response, Type returnType) throws ApiException {
        Objects.requireNonNull(response);
        this.deprecationChecker.notice(response);
        if (response.isSuccessful()) {
            if (returnType == null) {
                ResponseBody responseBody = response.body();
                if (responseBody != null) {
                    responseBody.close();
                }
                return null;
            }
            try {
                return this.deserialize(response, returnType);
            }
            catch (Exception exception) {
                throw ApiException.becauseOfUnsuccessfulResponseBodyReading(ApiException.RequestContext.tryToReadFrom(response), exception);
            }
        }
        String rawResponseBody = null;
        ApiExceptionDetails details = null;
        ResponseBody responseBody = response.body();
        if (responseBody != null) {
            try {
                rawResponseBody = responseBody.string();
                details = (ApiExceptionDetails)this.errorResponseSerializer.deserialize(rawResponseBody, (Type)((Object)ApiExceptionDetails.class));
            }
            catch (Exception e) {
                try {
                    ApiExceptionWrapper wrapper = (ApiExceptionWrapper)this.errorResponseSerializer.deserialize(rawResponseBody, (Type)((Object)ApiExceptionWrapper.class));
                    details = this.apiExceptionDetailsResolver.resolveDetails(wrapper.getDetails());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        throw ApiException.becauseApiRequestFailed(ApiException.RequestContext.tryToReadFrom(response), rawResponseBody, details);
    }

    Downloader downloader() {
        return this.downloader;
    }

    JSON json() {
        return this.json;
    }

    private <T> T deserialize(Response response, Type returnType) throws IOException {
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            return null;
        }
        if (File.class == returnType) {
            return (T)this.downloader.downloadFile(response);
        }
        if (byte[].class == returnType) {
            return (T)responseBody.bytes();
        }
        if (String.class == returnType) {
            return (T)responseBody.string();
        }
        try (InputStream responseBodyStream = responseBody.byteStream();){
            Object t = this.json.deserialize(responseBodyStream, returnType);
            return t;
        }
    }

    private static final class ErrorResponseSerializer
    extends JSON {
        private ErrorResponseSerializer() {
        }

        @Override
        protected ObjectMapper configureObjectMapper() {
            return super.configureObjectMapper().enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        }
    }
}

