/*
 * Decompiled with CFR 0.152.
 */
package com.infobip;

import com.infobip.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class RequestDefinition {
    private final String method;
    private final String path;
    private final List<Parameter> pathParameters;
    private final List<Parameter> queryParameters;
    private final List<Parameter> headerParameters;
    private final List<Parameter> formParameters;
    private final Object body;
    private final boolean requiresAuthentication;
    private final String accept;
    private final String contentType;

    private RequestDefinition(Builder builder) {
        this.method = builder.method;
        this.path = builder.path;
        this.pathParameters = List.copyOf(builder.pathParameters);
        this.queryParameters = List.copyOf(builder.queryParameters);
        this.headerParameters = List.copyOf(builder.headerParameters);
        this.formParameters = List.copyOf(builder.formParameters);
        this.body = builder.body;
        this.requiresAuthentication = builder.requiresAuthentication;
        this.accept = builder.accept;
        this.contentType = builder.contentType;
    }

    public static Builder builder(String method, String path) {
        return new Builder(method, path);
    }

    public String method() {
        return this.method;
    }

    public String path() {
        return this.path;
    }

    public List<Parameter> pathParameters() {
        return this.pathParameters;
    }

    public List<Parameter> queryParameters() {
        return this.queryParameters;
    }

    public List<Parameter> headerParameters() {
        return this.headerParameters;
    }

    public List<Parameter> formParameters() {
        return this.formParameters;
    }

    public boolean requiresAuthentication() {
        return this.requiresAuthentication;
    }

    public Optional<Object> body() {
        return Optional.ofNullable(this.body);
    }

    public Optional<String> accept() {
        return Optional.ofNullable(this.accept);
    }

    public Optional<String> contentType() {
        return Optional.ofNullable(this.contentType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestDefinition that = (RequestDefinition)o;
        return this.requiresAuthentication == that.requiresAuthentication && this.method.equals(that.method) && this.path.equals(that.path) && this.queryParameters.equals(that.queryParameters) && this.headerParameters.equals(that.headerParameters) && this.formParameters.equals(that.formParameters) && Objects.equals(this.body, that.body) && Objects.equals(this.accept, that.accept) && Objects.equals(this.contentType, that.contentType);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.path, this.queryParameters, this.headerParameters, this.formParameters, this.body, this.requiresAuthentication, this.accept, this.contentType);
    }

    public String toString() {
        return "RequestDefinition{method='" + this.method + "', path='" + this.path + "', pathParameters=" + String.valueOf(this.pathParameters) + ", queryParameters=" + String.valueOf(this.queryParameters) + ", headerParameters=" + String.valueOf(this.headerParameters) + ", formParameters=" + String.valueOf(this.formParameters) + ", body=" + String.valueOf(this.body) + ", requiresAuthentication=" + this.requiresAuthentication + ", accept='" + this.accept + "', contentType='" + this.contentType + "'}";
    }

    public static class Builder {
        private final String path;
        private final String method;
        private final List<Parameter> pathParameters = new ArrayList<Parameter>();
        private final List<Parameter> queryParameters = new ArrayList<Parameter>();
        private final List<Parameter> headerParameters = new ArrayList<Parameter>();
        private final List<Parameter> formParameters = new ArrayList<Parameter>();
        private boolean requiresAuthentication;
        private Object body;
        private String accept;
        private String contentType;

        private Builder(String method, String path) {
            this.method = Objects.requireNonNull(method);
            this.path = Objects.requireNonNull(path);
        }

        public Builder addPathParameter(Parameter pathParameter) {
            this.pathParameters.add(Objects.requireNonNull(pathParameter));
            return this;
        }

        public Builder addQueryParameter(Parameter queryParameter) {
            this.queryParameters.add(Objects.requireNonNull(queryParameter));
            return this;
        }

        public Builder addHeaderParameter(Parameter headerParameter) {
            this.headerParameters.add(Objects.requireNonNull(headerParameter));
            return this;
        }

        public Builder addFormParameter(Parameter formParameter) {
            this.formParameters.add(Objects.requireNonNull(formParameter));
            return this;
        }

        public Builder requiresAuthentication(boolean requiresAuthentication) {
            this.requiresAuthentication = requiresAuthentication;
            return this;
        }

        public Builder body(Object body) {
            this.body = Objects.requireNonNull(body);
            return this;
        }

        public Builder accept(String accept) {
            this.accept = Objects.requireNonNull(accept);
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = Objects.requireNonNull(contentType);
            return this;
        }

        public RequestDefinition build() {
            return new RequestDefinition(this);
        }
    }
}

