/*
 * Decompiled with CFR 0.152.
 */
package com.infobip;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public final class BaseUrl {
    private static final BaseUrl API = BaseUrl.from("https://api.infobip.com");
    private final URL url;

    private BaseUrl(String url) {
        Objects.requireNonNull(url);
        String urlWithoutTrailingSlashes = url.trim().replaceFirst("/+$", "");
        try {
            this.url = new URL(urlWithoutTrailingSlashes);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Provided argument can't be recognized as a valid URL.", e);
        }
    }

    public static BaseUrl from(String baseUrl) {
        return new BaseUrl(baseUrl);
    }

    public static BaseUrl api() {
        return API;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseUrl baseUrl = (BaseUrl)o;
        return this.url.equals(baseUrl.url);
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }

    public String toString() {
        return "BaseUrl{url=" + String.valueOf(this.url) + "}";
    }
}

