/*
 * Decompiled with CFR 0.152.
 */
package com.iih5.smartorm.model;

import com.iih5.smartorm.dialect.DefaultDialect;
import com.iih5.smartorm.kit.StringKit;
import com.iih5.smartorm.model.DataException;
import com.iih5.smartorm.model.Db;
import com.iih5.smartorm.model.Page;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Model<M extends Model>
implements Serializable {
    JdbcTemplate jdbc = null;
    private StringBuffer limit = new StringBuffer();
    private Long pageNumber;
    private Integer pageSize;
    private StringBuffer order = new StringBuffer();
    protected String table;
    private transient Map<String, Object> attrs = new HashMap<String, Object>();
    private Set<String> modifyFlag = new HashSet<String>();
    private Object[] NULL_PARA_ARRAY = new Object[0];

    public Model() {
        this.jdbc = this.getJdbc();
    }

    public Model(Object copyBean) {
        BeanUtils.copyProperties((Object)copyBean, (Object)this);
        this.jdbc = this.getJdbc();
    }

    private JdbcTemplate getJdbc() {
        return Db.getJdbcTemplate();
    }

    private Set<String> getModifyFlag() {
        return this.modifyFlag;
    }

    public M use(String dataSource) {
        this.jdbc = Db.getJdbcTemplate(dataSource);
        return (M)this;
    }

    public M set(String attr, Object value) {
        this.attrs.put(attr, value);
        this.getModifyFlag().add(attr);
        return (M)this;
    }

    public M incr(String attr, Object value) {
        String number = String.valueOf(value);
        if (number.substring(0, 1).equals("-")) {
            this.set(attr, attr + number);
        } else {
            this.set(attr, attr + "+" + number);
        }
        return (M)this;
    }

    public M mult(String attr, Object value) {
        String number = String.valueOf(value);
        this.set(attr, attr + "*" + number);
        return (M)this;
    }

    public M minus(String attr, Object value) {
        String number = String.valueOf(value);
        this.set(attr, attr + "/" + number);
        return (M)this;
    }

    public Map<String, Object> getAttrs() {
        return this.attrs;
    }

    private void beanToAttrs() throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), this.getClass());
            Method methodReader = pd.getReadMethod();
            Object value = methodReader.invoke((Object)this, new Object[0]);
            if (value == null) continue;
            this.attrs.put(StringKit.toUnderscoreName(field.getName()), value);
            this.modifyFlag.add(StringKit.toUnderscoreName(field.getName()));
        }
    }

    public boolean insert() {
        try {
            this.beanToAttrs();
            StringBuilder sql = new StringBuilder();
            ArrayList<Object> paras = new ArrayList<Object>();
            DefaultDialect.getDialect().forModelSave(this.table, this.attrs, sql, paras);
            return this.jdbc.update(sql.toString(), paras.toArray()) >= 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Long insertAndReturnId() {
        if (this.insert()) {
            String sql = "SELECT LAST_INSERT_ID();";
            return (Long)this.jdbc.queryForObject(sql, new Object[0], Long.class);
        }
        return null;
    }

    public boolean delete(String conditions, Object[] conditionValues) {
        if (conditionValues == null || conditionValues.length == 0) {
            return false;
        }
        String sql = DefaultDialect.getDialect().deleteByCondition(this.table, conditions);
        return this.jdbc.update(sql, conditionValues) >= 0;
    }

    public boolean delete(Object cdtBean) {
        String sql = "delete from " + this.table + " where 1=1 " + StringKit.beanToSqlConditionStr(cdtBean);
        return this.jdbc.update(sql) >= 0;
    }

    public boolean delete(String conditions) {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ");
        sql.append(this.table);
        sql.append(" where ");
        sql.append(conditions);
        return this.jdbc.update(sql.toString()) >= 0;
    }

    public boolean deleteById(Object id) {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ");
        sql.append(this.table);
        sql.append(" where id= ");
        sql.append(id);
        return this.jdbc.update(sql.toString()) >= 0;
    }

    public boolean deleteByIds(List list) {
        String st1 = list.toString();
        String arr = st1.substring(st1.indexOf("[") + 1, st1.indexOf("]"));
        StringBuilder sql = new StringBuilder();
        sql.append("delete from ");
        sql.append(this.table);
        sql.append(" where id in ");
        sql.append("(");
        sql.append(arr);
        sql.append(")");
        return this.jdbc.update(sql.toString()) >= 0;
    }

    public boolean updateBy(String conditions, Object[] conditionValues) {
        try {
            this.beanToAttrs();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (this.getModifyFlag().isEmpty()) {
            return false;
        }
        StringBuilder sql = new StringBuilder();
        DefaultDialect.getDialect().forModelUpdate(this.table, " and " + conditions, this.attrs, this.getModifyFlag(), sql);
        return this.jdbc.update(sql.toString(), conditionValues) >= 0;
    }

    public boolean updateBy(String conditions) {
        return this.updateBy(conditions, new Object[0]);
    }

    public boolean updateById(Object id) {
        return this.updateBy("id=?", new Object[]{id});
    }

    public boolean updateBy(Object cdtBean) {
        try {
            this.beanToAttrs();
            if (this.getModifyFlag().isEmpty()) {
                return false;
            }
            StringBuilder sql = new StringBuilder();
            DefaultDialect.getDialect().forModelUpdate(this.table, StringKit.beanToSqlConditionStr(cdtBean), this.attrs, this.getModifyFlag(), sql);
            return this.jdbc.update(sql.toString()) >= 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean replaceBy(String condition, Object[] paras) {
        boolean rt = true;
        rt = this.findBy(condition, paras) == null ? this.insert() : this.updateBy(condition, paras);
        return rt;
    }

    public boolean replaceBy(String condition) {
        return this.replaceBy(condition, new Object[0]);
    }

    public boolean replaceById(Object id) {
        boolean rt = true;
        rt = this.findById(id) == null ? this.insert() : this.updateById(id);
        return rt;
    }

    public boolean replaceBy(Object cdtBean) {
        boolean rt = true;
        rt = this.findBy(cdtBean) == null ? this.insert() : this.updateBy(cdtBean);
        return rt;
    }

    public M findBy(String columns, String conditions, Object[] conditionParas) {
        List<M> result = this.findListBy(columns, conditions, conditionParas);
        if (result.size() > 1) {
            throw new DataException("\u8fd4\u56de\u591a\u4e8e1\u6761\u6570\u636e");
        }
        if (result.size() == 0) {
            return null;
        }
        return (M)((Model)result.get(0));
    }

    public M findBy(String conditions, Object[] conditionParas) {
        return this.findBy("*", conditions, conditionParas);
    }

    public M findBy(String conditions) {
        return this.findBy(conditions, new Object[0]);
    }

    public M findById(Object id) {
        return this.findBy("id=?", new Object[]{id});
    }

    public M findBy(Object cdtBean) {
        List<M> list = this.findListBy(cdtBean);
        if (list.size() > 1) {
            throw new DataException("\u8fd4\u56de\u591a\u4e8e1\u6761\u6570\u636e");
        }
        if (list.size() == 0) {
            return null;
        }
        return (M)((Model)list.get(0));
    }

    protected <T> List<T> queryList(String columns, String conditions, Object[] conditionParas) {
        String sql = DefaultDialect.getDialect().forModelFindBy(this.table, columns, conditions);
        if (this.order.length() > 0) {
            sql = sql + " " + this.order.toString();
        }
        if (this.limit.length() > 0) {
            sql = sql + " " + this.limit.toString();
        }
        final HashSet columnMeta = new HashSet();
        final HashMap fieldMap = new HashMap();
        return this.jdbc.query(sql, conditionParas, new RowMapper<T>(){

            public T mapRow(ResultSet rs, int rowNum) throws SQLException {
                try {
                    Model mModel;
                    Field[] fields;
                    if (columnMeta.size() <= 0) {
                        for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                            String column = rs.getMetaData().getColumnLabel(i + 1);
                            columnMeta.add(column);
                        }
                    }
                    if ((fields = (mModel = (Model)Model.this.getUsefulClass().newInstance()).getClass().getDeclaredFields()).length > 0) {
                        for (Field field : fields) {
                            String column = (String)fieldMap.get(field.getName());
                            if (column == null) {
                                column = StringKit.toUnderscoreName(field.getName());
                                fieldMap.put(field.getName(), column);
                            }
                            if (!columnMeta.contains(column)) continue;
                            Object value = rs.getObject(column);
                            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), mModel.getClass());
                            Method method = pd.getWriteMethod();
                            method.invoke((Object)mModel, value);
                        }
                    } else {
                        ResultSetMetaData rsmd = rs.getMetaData();
                        int columnCount = rsmd.getColumnCount();
                        for (int i = 1; i <= columnCount; ++i) {
                            Object value = rs.getObject(i);
                            if (value == null) continue;
                            Model.this.attrs.put(rsmd.getColumnLabel(i), value);
                        }
                    }
                    return mModel;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
    }

    public <T> List<T> queryForList(String column, String conditions, Object[] conditionParas, Class<T> claszz) {
        String sql = DefaultDialect.getDialect().forModelFindBy(this.table, column, " and " + conditions);
        if (this.order.length() > 0) {
            sql = sql + " " + this.order.toString();
        }
        if (this.limit.length() > 0) {
            sql = sql + " " + this.limit.toString();
        }
        if (!StringKit.isBaseDataType(claszz)) {
            throw new DataException("\u7c7b\u578b\u4e0d\u7b26\u5408\uff0c\u53ea\u80fd\u4f7f\u7528\u57fa\u672c\u7c7b\u578b");
        }
        return this.jdbc.queryForList(sql, conditionParas, claszz);
    }

    public <T> T queryForObject(String column, String conditions, Object[] conditionParas, Class<T> claszz) {
        List<T> list = this.queryForList(column, conditions, conditionParas, claszz);
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 0) {
            return null;
        }
        throw new DataException("\u4e0d\u6b621\u6761\u6570\u636e");
    }

    public List<M> findListBy(String columns, String conditions, Object[] conditionParas) {
        return this.queryList(columns, " and " + conditions, conditionParas);
    }

    public List<M> findListBy(String conditions, Object[] conditionParas) {
        return this.findListBy("*", conditions, conditionParas);
    }

    public List<M> findListBy(String conditions) {
        return this.findListBy(conditions, this.NULL_PARA_ARRAY);
    }

    public List<M> findListBy(Object cdtBean) {
        return this.queryList("*", StringKit.beanToSqlConditionStr(cdtBean), new Object[0]);
    }

    public Long findListCountBy(String conditions, Object[] conditionParas) {
        String sql = DefaultDialect.getDialect().forModelFindBy(this.table, " count(*) ", " and " + conditions);
        return (Long)this.jdbc.queryForObject(sql, conditionParas, Long.class);
    }

    public Long findListCountBy(Object cdtBean) {
        String sql = "select count(*) from " + this.table + " where 1=1 " + StringKit.beanToSqlConditionStr(cdtBean);
        return (Long)this.jdbc.queryForObject(sql, this.NULL_PARA_ARRAY, Long.class);
    }

    public M limit(Long pageNum, Integer pageSize) {
        this.pageNumber = pageNum;
        if (pageNum < 1L) {
            this.pageNumber = 1L;
        }
        this.pageSize = pageSize;
        Long start = (this.pageNumber - 1L) * (long)this.pageSize.intValue();
        this.limit.append(" limit ").append(start).append(", ").append(this.pageSize);
        return (M)this;
    }

    public M order(String column, String sortType) {
        this.order.append(" order by ").append(column).append(" ").append(sortType);
        return (M)this;
    }

    public Page<M> paginate(String columns, String conditions, Object[] paras) {
        Long size = this.findListCountBy(conditions, paras);
        Long totalRow = size;
        if (totalRow == 0L) {
            return new Page(new ArrayList(0), this.pageNumber, this.pageSize, 0L, 0L);
        }
        Long totalPage = totalRow / (long)this.pageSize.intValue();
        if (totalRow % (long)this.pageSize.intValue() != 0L) {
            Long l = totalPage;
            Long l2 = totalPage = Long.valueOf(totalPage + 1L);
        }
        if (this.pageNumber > totalPage) {
            return new Page(new ArrayList(0), this.pageNumber, this.pageSize, totalPage, totalRow);
        }
        List<M> list = this.findListBy(columns, conditions, paras);
        return new Page<M>(list, this.pageNumber, this.pageSize, totalPage, totalRow);
    }

    public Page<M> paginate(String conditions, Object[] paras) {
        return this.paginate("*", conditions, paras);
    }

    public Page<M> paginate(Object ctdBean) {
        Long size = this.findListCountBy(ctdBean);
        Long totalRow = size;
        if (totalRow == 0L) {
            return new Page(new ArrayList(0), this.pageNumber, this.pageSize, 0L, 0L);
        }
        Long totalPage = totalRow / (long)this.pageSize.intValue();
        if (totalRow % (long)this.pageSize.intValue() != 0L) {
            Long l = totalPage;
            Long l2 = totalPage = Long.valueOf(totalPage + 1L);
        }
        if (this.pageNumber > totalPage) {
            return new Page(new ArrayList(0), this.pageNumber, this.pageSize, totalPage, totalRow);
        }
        List<M> list = this.findListBy(ctdBean);
        return new Page<M>(list, this.pageNumber, this.pageSize, totalPage, totalRow);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Model)) {
            return false;
        }
        if (this.getUsefulClass() != ((Model)o).getUsefulClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return this.attrs.equals(((Model)o).attrs);
    }

    public int hashCode() {
        return (this.attrs == null ? 0 : this.attrs.hashCode()) ^ (this.getModifyFlag() == null ? 0 : this.getModifyFlag().hashCode());
    }

    private Class<? extends Model> getUsefulClass() {
        Class<?> c = this.getClass();
        return c.getName().indexOf("EnhancerByCGLIB") == -1 ? c : c.getSuperclass();
    }
}

