/*
 * Decompiled with CFR 0.152.
 */
package com.iih5.smartorm.model;

import com.iih5.smartorm.kit.SpringKit;
import com.iih5.smartorm.kit.StringKit;
import com.iih5.smartorm.model.DataException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbExecutor {
    private static Map<String, DbExecutor> map = new HashMap<String, DbExecutor>();
    private static String defaultDataSource = null;
    public JdbcTemplate jdbc = null;

    public static DbExecutor use(String dataSource) {
        DbExecutor executor = map.get(dataSource);
        if (executor == null) {
            executor = new DbExecutor();
            executor.jdbc = SpringKit.getJdbcTemplateByDataSource(dataSource);
            map.put(dataSource, executor);
        }
        return executor;
    }

    public static DbExecutor use() {
        DbExecutor executor;
        if (defaultDataSource == null) {
            String[] dbs = SpringKit.getApplicationContext().getBeanNamesForType(DataSource.class);
            defaultDataSource = dbs[0];
        }
        if ((executor = map.get(defaultDataSource)) == null) {
            executor = new DbExecutor();
            executor.jdbc = SpringKit.getJdbcTemplateByDataSource(defaultDataSource);
            map.put(defaultDataSource, executor);
        }
        return executor;
    }

    public JdbcTemplate getJdbcTemplate(String dataSource) {
        DbExecutor executor = map.get(dataSource);
        if (executor != null) {
            return executor.jdbc;
        }
        return null;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.getJdbcTemplate(defaultDataSource);
    }

    private <T> List<T> queryList(String sql, Object[] paras, final Class<T> claszz) {
        if (StringKit.isBaseDataType(claszz)) {
            return this.jdbc.queryForList(sql, paras, claszz);
        }
        final HashSet columnMeta = new HashSet();
        final HashMap fieldMap = new HashMap();
        return this.jdbc.query(sql, paras, new RowMapper<T>(){

            public T mapRow(ResultSet rs, int rowNum) throws SQLException {
                try {
                    Object mModel;
                    Field[] fields;
                    if (columnMeta.size() <= 0) {
                        for (int i = 0; i < rs.getMetaData().getColumnCount(); ++i) {
                            String column = rs.getMetaData().getColumnLabel(i + 1);
                            columnMeta.add(column);
                        }
                    }
                    if ((fields = (mModel = claszz.newInstance()).getClass().getDeclaredFields()).length > 0) {
                        for (Field field : fields) {
                            String column = (String)fieldMap.get(field.getName());
                            if (column == null) {
                                column = StringKit.toUnderscoreName(field.getName());
                                fieldMap.put(field.getName(), column);
                            }
                            if (!columnMeta.contains(column)) continue;
                            Object value = rs.getObject(column);
                            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), mModel.getClass());
                            Method method = pd.getWriteMethod();
                            method.invoke(mModel, value);
                        }
                    }
                    return mModel;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
    }

    public <T> List<T> findList(String sql, Object[] paras, Class<T> claszz) {
        return this.queryList(sql, paras, claszz);
    }

    public List<Map<String, Object>> findList(String sql, Object[] paras) {
        return this.jdbc.queryForList(sql, paras);
    }

    public <T> T find(String sql, Object[] paras, Class<T> claszz) {
        List<T> result = this.findList(sql, paras, claszz);
        if (result.size() > 1) {
            throw new DataException("\u8fd4\u56de\u591a\u4e8e1\u6761\u6570\u636e");
        }
        if (result.size() == 0) {
            return null;
        }
        return result.get(0);
    }

    public int update(String sql, Object[] paras) throws DataAccessException {
        return this.jdbc.update(sql, paras);
    }

    public int[] batchUpdate(String sql, List<Object[]> batchArgs) {
        return this.jdbc.batchUpdate(sql, batchArgs);
    }

    public void execute(String sql) {
        this.jdbc.execute(sql);
    }
}

