/*
 * Decompiled with CFR 0.152.
 */
package com.iih5.smartorm.model;

import com.iih5.smartorm.model.DbExecutor;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Db {
    private static DbExecutor defaultExecutor = null;

    public static DbExecutor use(String dataSource) {
        if (dataSource == null) {
            return defaultExecutor;
        }
        return DbExecutor.use(dataSource);
    }

    public static JdbcTemplate getJdbcTemplate(String dataSource) {
        return Db.use(dataSource).getJdbcTemplate();
    }

    public static JdbcTemplate getJdbcTemplate() {
        return defaultExecutor.getJdbcTemplate();
    }

    public static <T> T find(String sql, Object[] paras, Class<T> claszz) {
        return defaultExecutor.find(sql, paras, claszz);
    }

    public static <T> T find(String sql, Class<T> claszz) {
        return defaultExecutor.find(sql, new Object[0], claszz);
    }

    public static <T> List<T> findList(String sql, Object[] paras, Class<T> claszz) {
        return defaultExecutor.findList(sql, paras, claszz);
    }

    public static <T> List<T> findList(String sql, Class<T> claszz) {
        return defaultExecutor.findList(sql, new Object[0], claszz);
    }

    public static List<Map<String, Object>> findList(String sql, Object[] paras) {
        return defaultExecutor.findList(sql, paras);
    }

    public static int update(String sql, Object[] paras) throws DataAccessException {
        return defaultExecutor.update(sql, paras);
    }

    public static int[] batchUpdate(String sql, List<Object[]> batchArgs) {
        return defaultExecutor.batchUpdate(sql, batchArgs);
    }

    public static void execute(String sql) {
        defaultExecutor.execute(sql);
    }

    static {
        defaultExecutor = DbExecutor.use();
    }
}

