/*
 * Decompiled with CFR 0.152.
 */
package com.iih5.smartorm.kit;

import com.iih5.smartorm.generator.GeneratorTool;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;

public class StringKit {
    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isBlank(String str) {
        return str == null || "".equals(str.trim());
    }

    public static boolean notBlank(String str) {
        return str != null && !"".equals(str.trim());
    }

    public static boolean notBlank(String ... strings) {
        if (strings == null) {
            return false;
        }
        for (String str : strings) {
            if (str != null && !"".equals(str.trim())) continue;
            return false;
        }
        return true;
    }

    public static boolean notNull(Object ... paras) {
        if (paras == null) {
            return false;
        }
        for (Object obj : paras) {
            if (obj != null) continue;
            return false;
        }
        return true;
    }

    public static String toCamelCaseName(String underscore) {
        if (underscore.indexOf(95) == -1) {
            return underscore;
        }
        underscore = underscore.toLowerCase();
        char[] fromArray = underscore.toCharArray();
        char[] toArray = new char[fromArray.length];
        int j = 0;
        for (int i = 0; i < fromArray.length; ++i) {
            if (fromArray[i] == '_') {
                if (++i >= fromArray.length) continue;
                toArray[j++] = Character.toUpperCase(fromArray[i]);
                continue;
            }
            toArray[j++] = fromArray[i];
        }
        return new String(toArray, 0, j);
    }

    public static String toUnderscoreName(String camelCase) {
        StringBuilder result = new StringBuilder();
        if (camelCase != null && camelCase.length() > 0) {
            result.append(camelCase.substring(0, 1));
            for (int i = 1; i < camelCase.length(); ++i) {
                String s = camelCase.substring(i, i + 1);
                if (s.equals(s.toUpperCase()) && !Character.isDigit(s.charAt(0))) {
                    result.append("_");
                }
                result.append(s);
            }
        }
        return result.toString().toLowerCase();
    }

    public static String join(String[] stringArray) {
        StringBuilder sb = new StringBuilder();
        for (String s : stringArray) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(String[] stringArray, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(stringArray[i]);
        }
        return sb.toString();
    }

    public static String toModelNameByTable(String tableName) {
        if (GeneratorTool.isHashPrefix) {
            int index = tableName.indexOf("_");
            tableName = tableName.substring(index);
        }
        return StringKit.toCamelCaseName(tableName);
    }

    public static String beanToSqlConditionStr(Object cdtBean) {
        try {
            Field[] fields;
            StringBuffer condition = new StringBuffer();
            for (Field field : fields = cdtBean.getClass().getDeclaredFields()) {
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), cdtBean.getClass());
                Method methodReader = pd.getReadMethod();
                Object value = methodReader.invoke(cdtBean, new Object[0]);
                if (value == null) continue;
                if (value instanceof Integer || value instanceof Double || value instanceof BigDecimal || value instanceof Float || value instanceof Long || value instanceof BigInteger) {
                    condition.append(" and " + StringKit.toUnderscoreName(field.getName()) + "=" + value);
                    continue;
                }
                condition.append(" and " + StringKit.toUnderscoreName(field.getName()) + "='" + value + "'");
            }
            return condition.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean isBaseDataType(Class clazz) {
        try {
            return clazz.equals(String.class) || clazz.equals(Integer.class) || clazz.equals(Byte.class) || clazz.equals(Long.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Character.class) || clazz.equals(Short.class) || clazz.equals(BigDecimal.class) || clazz.equals(BigInteger.class) || clazz.equals(Boolean.class) || clazz.equals(Date.class) || clazz.isPrimitive();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

