/*
 * Decompiled with CFR 0.152.
 */
package com.iih5.smartorm.kit;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlXmlKit {
    static Logger logger = LoggerFactory.getLogger(SqlXmlKit.class);
    private static HashMap<String, Map<String, String>> resourcesMap = new HashMap();
    private static boolean debug = false;
    private static String sqlDir = "sql";

    public SqlXmlKit() {
        this.kk();
    }

    public SqlXmlKit(boolean isDebug) {
        debug = isDebug;
        this.kk();
    }

    private void kk() {
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource(sqlDir);
            if (url == null) {
                logger.warn("\u627e\u4e0d\u5230sql\u6587\u4ef6\u76ee\u5f55\uff01");
                return;
            }
            File dataDir = new File(url.toURI());
            this.init(dataDir);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8bfb\u53d6sql xml \u6587\u4ef6\u5f02\u5e38");
        }
    }

    public SqlXmlKit(String path, boolean isDebug) {
        debug = isDebug;
        sqlDir = path;
        this.init(new File(sqlDir));
    }

    private void init(File dataDir) {
        try {
            ArrayList<File> files = new ArrayList<File>();
            this.listDirectory(dataDir, files);
            for (File file : files) {
                if (!file.getName().contains(".xml")) continue;
                SAXReader reader = new SAXReader();
                Document document = reader.read(file);
                Element xmlRoot = document.getRootElement();
                HashMap<String, String> methods = new HashMap<String, String>();
                for (Object ebj : xmlRoot.elements("sql")) {
                    Element sql = (Element)ebj;
                    String text = sql.getText();
                    String rs = text.replaceAll("<!\\[CDATA\\[", "").replaceAll("\\]\\]>", "");
                    methods.put(sql.attribute("method").getValue(), rs);
                }
                resourcesMap.put(file.getName().replace(".xml", ""), methods);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void listDirectory(File path, List<File> files) {
        if (path.exists()) {
            if (path.isFile()) {
                files.add(path);
            } else {
                File[] list = path.listFiles();
                for (int i = 0; i < list.length; ++i) {
                    this.listDirectory(list[i], files);
                }
            }
        }
    }

    public static String getSQL(String className, String method) {
        String name = className;
        Map<String, String> m = resourcesMap.get(name);
        if (debug) {
            return SqlXmlKit.loadSqlByDebug(name, method);
        }
        return m.get(method);
    }

    public static String thisSQL() {
        String name = Thread.currentThread().getStackTrace()[2].getFileName().replace(".java", "");
        String method = Thread.currentThread().getStackTrace()[2].getMethodName();
        return SqlXmlKit.getSQL(name, method);
    }

    private static String loadSqlByDebug(String fileName, String method) {
        String path = sqlDir + "/" + fileName + ".xml";
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (in == null) {
            logger.warn("\u627e\u4e0d\u5230\u6587\u4ef6:" + path);
            return null;
        }
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(in);
            Element xmlRoot = document.getRootElement();
            for (Object ebj : xmlRoot.elements("sql")) {
                Element sql = (Element)ebj;
                String methodName = sql.attribute("method").getValue().trim();
                if (!method.equals(methodName)) continue;
                String text = sql.getText();
                String rs = text.replaceAll("<!\\[CDATA\\[", "").replaceAll("\\]\\]>", "");
                return rs;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

