/*
 * Decompiled with CFR 0.152.
 */
package com.iih5.smartorm.generator;

import com.iih5.smartorm.generator.ColumnMeta;
import com.iih5.smartorm.generator.TableMeta;
import com.iih5.smartorm.model.Db;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableMetaUtil {
    public static List<TableMeta> findTableMetaList(String dataSource) throws Exception {
        ArrayList<TableMeta> tableList = new ArrayList<TableMeta>();
        List<String> sets = null;
        sets = dataSource != null ? Db.use(dataSource).findList("show tables ;", new Object[0], String.class) : Db.findList("show tables ;", new Object[0], String.class);
        for (String name : sets) {
            String sql = " show full columns from " + name + " ;";
            TableMeta meta = new TableMeta();
            meta.name = name;
            Map<String, String> javaTypeMap = TableMetaUtil.toJavaTypeMap(name);
            List<Map<String, Object>> mpList = Db.use(dataSource).findList(sql, new Object[0]);
            for (Map<String, Object> mp : mpList) {
                ColumnMeta columnMeta = new ColumnMeta();
                columnMeta.name = (String)mp.get("Field");
                columnMeta.comment = (String)mp.get("Comment");
                columnMeta.dataType = javaTypeMap.get(columnMeta.name);
                meta.columnMetas.add(columnMeta);
            }
            tableList.add(meta);
        }
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> toJavaTypeMap(String tableName) {
        Connection connection = null;
        Statement stm = null;
        ResultSet rs = null;
        try {
            HashMap<String, String> javaType = new HashMap<String, String>();
            String sql = "select * from " + tableName + " where 1=2 ";
            connection = Db.getJdbcTemplate().getDataSource().getConnection();
            stm = connection.createStatement();
            rs = stm.executeQuery(sql);
            ResultSetMetaData rmd = rs.getMetaData();
            for (int i = 1; i <= rmd.getColumnCount(); ++i) {
                javaType.put(rmd.getColumnLabel(i), rmd.getColumnClassName(i));
            }
            HashMap<String, String> hashMap = javaType;
            return hashMap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                connection.close();
                rs.close();
                stm.close();
            }
            catch (SQLException e) {}
        }
        return null;
    }
}

