/*
 * Decompiled with CFR 0.152.
 */
package com.iih5.smartorm.generator;

import com.iih5.smartorm.generator.ColumnMeta;
import com.iih5.smartorm.generator.JavaKeyword;
import com.iih5.smartorm.generator.JavaType;
import com.iih5.smartorm.generator.TableMeta;
import com.iih5.smartorm.kit.StringKit;

public class ModelBuilder {
    private StringBuffer builder = new StringBuffer();
    private StringBuffer packageBuilder = new StringBuffer();
    private StringBuffer importBuilder;
    private StringBuffer classBuilder = new StringBuffer();
    private StringBuffer constructBuilder;
    private StringBuffer columnBuilder;
    private StringBuffer setMethodBuilder;
    private StringBuffer getMethodBuilder;

    public ModelBuilder() {
        this.importBuilder = new StringBuffer();
        this.constructBuilder = new StringBuffer();
        this.columnBuilder = new StringBuffer();
        this.setMethodBuilder = new StringBuffer();
        this.getMethodBuilder = new StringBuffer();
    }

    private void join() {
        this.builder.append(this.packageBuilder);
        this.builder.append("\n\n");
        this.builder.append(this.importBuilder);
        this.builder.append("\n");
        this.builder.append(this.classBuilder);
        this.builder.append("\n");
        this.builder.append(this.constructBuilder);
        this.builder.append("\n");
        this.builder.append(this.columnBuilder);
        this.builder.append("\n");
        this.builder.append(this.setMethodBuilder);
        this.builder.append("\n");
        this.builder.append(this.getMethodBuilder);
        this.builder.append("\n");
        this.builder.append("}\n");
    }

    private ModelBuilder createPackage(String pack) {
        this.packageBuilder.append("package " + pack + ";");
        return this;
    }

    private ModelBuilder createImport(String imp) {
        this.importBuilder.append("import " + imp + ";\n");
        return this;
    }

    private ModelBuilder createClass(String clas) {
        this.classBuilder.append("public class " + clas + " extends Model<" + clas + ">{");
        return this;
    }

    private ModelBuilder createConstruct(String clas, String tableName) {
        this.constructBuilder.append("    public " + clas + "(){");
        this.constructBuilder.append("\n       this.table=\"" + tableName + "\";");
        this.constructBuilder.append("\n    }");
        this.constructBuilder.append("\n    public " + clas + "(Object cdtBean){");
        this.constructBuilder.append("\n       super(cdtBean);\n");
        this.constructBuilder.append("       this.table=\"" + tableName + "\";");
        this.constructBuilder.append("\n    }");
        return this;
    }

    private ModelBuilder createColumn(String type, String column, String comment) {
        this.columnBuilder.append("    //" + comment + "\n");
        this.columnBuilder.append("    private " + type + " " + StringKit.firstCharToLowerCase(StringKit.toCamelCaseName(column)) + ";\n");
        return this;
    }

    private ModelBuilder createSetMethod(Object type, String column) {
        this.setMethodBuilder.append("    public void set");
        this.setMethodBuilder.append(StringKit.firstCharToUpperCase(StringKit.toCamelCaseName(column)) + "(" + type + " " + StringKit.toCamelCaseName(column) + ") { \n");
        this.setMethodBuilder.append("        this." + StringKit.toCamelCaseName(column) + " = " + StringKit.toCamelCaseName(column) + "; \n");
        this.setMethodBuilder.append("    }\n\n");
        return this;
    }

    private ModelBuilder createGetMethod(Object type, String column) {
        this.setMethodBuilder.append("    public " + type + " " + "get");
        this.setMethodBuilder.append(StringKit.firstCharToUpperCase(StringKit.toCamelCaseName(column)) + "() { \n");
        this.setMethodBuilder.append("        return " + StringKit.toCamelCaseName(column) + ";\n");
        this.setMethodBuilder.append("    }\n\n");
        return this;
    }

    public String doBuild(TableMeta tableMeta, String packageName) {
        this.createPackage(packageName);
        this.createImport("com.iih5.smartorm.model.Model");
        String className = StringKit.firstCharToUpperCase(StringKit.toModelNameByTable(tableMeta.name) + "Model");
        this.createClass(className);
        this.createConstruct(className, tableMeta.name);
        JavaType javaTypeM = new JavaType();
        for (ColumnMeta columnMeta : tableMeta.columnMetas) {
            String javaType = javaTypeM.getType(columnMeta.dataType);
            if (javaType == null) {
                throw new NullPointerException("\u627e\u4e0d\u5230 " + columnMeta.dataType + "\u5bf9\u5e94\u7684JavaType");
            }
            if (JavaKeyword.contains(columnMeta.name)) {
                throw new IllegalArgumentException("\u975e\u6cd5\u53c2\u6570\u540d:" + columnMeta.name);
            }
            this.createColumn(javaType, columnMeta.name, columnMeta.comment);
            this.createSetMethod(javaType, columnMeta.name);
            this.createGetMethod(javaType, columnMeta.name);
        }
        this.join();
        return this.builder.toString();
    }
}

