/*
 * Decompiled with CFR 0.152.
 */
package com.iih5.smartorm.generator;

import com.iih5.smartorm.generator.ModelBuilder;
import com.iih5.smartorm.generator.TableMeta;
import com.iih5.smartorm.generator.TableMetaUtil;
import com.iih5.smartorm.kit.StringKit;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class GeneratorTool {
    public static boolean isHashPrefix = true;

    public static void generator(String dataSource, String modelPackageName, String javaOutputDir) throws Exception {
        List<TableMeta> tableMetaList = TableMetaUtil.findTableMetaList(dataSource);
        for (TableMeta table : tableMetaList) {
            GeneratorTool.build(table, modelPackageName, javaOutputDir);
        }
    }

    public static void generator(String modelPackageName, String javaOutputDir) throws Exception {
        List<TableMeta> tableMetaList = TableMetaUtil.findTableMetaList(null);
        for (TableMeta table : tableMetaList) {
            GeneratorTool.build(table, modelPackageName, javaOutputDir);
        }
    }

    public static void generator(String modelPackageName, int projectType) throws Exception {
        String relativelyPath = System.getProperty("user.dir");
        relativelyPath = projectType == 1 ? relativelyPath + "/src/main/java" : relativelyPath + "/src";
        GeneratorTool.generator(modelPackageName, relativelyPath);
    }

    private static void build(TableMeta tableMeta, String modelPackageName, String javaOutputDir) throws Exception {
        StringBuffer absoluteDir = new StringBuffer();
        absoluteDir.append(javaOutputDir);
        absoluteDir.append("/");
        absoluteDir.append(modelPackageName.replaceAll("\\.", "/"));
        ModelBuilder builder = new ModelBuilder();
        String str = builder.doBuild(tableMeta, modelPackageName);
        GeneratorTool.writeToFile(str, tableMeta, absoluteDir.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeToFile(String content, TableMeta tableMeta, String outputDir) throws IOException {
        File dir = new File(outputDir);
        dir.mkdirs();
        String target = outputDir + File.separator + StringKit.firstCharToUpperCase(StringKit.toModelNameByTable(tableMeta.name)) + "Model.java";
        FileWriter fw = new FileWriter(target);
        try {
            fw.write(content);
        }
        finally {
            fw.close();
        }
    }
}

