/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v2.task;

import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.remote.PushCallBack;
import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.push.v2.NoRequiredRetryException;
import com.alibaba.nacos.naming.push.v2.PushConfig;
import com.alibaba.nacos.naming.push.v2.PushDataWrapper;
import com.alibaba.nacos.naming.push.v2.hook.PushResult;
import com.alibaba.nacos.naming.push.v2.hook.PushResultHookHolder;
import com.alibaba.nacos.naming.push.v2.task.PushDelayTask;
import com.alibaba.nacos.naming.push.v2.task.PushDelayTaskExecuteEngine;
import com.alibaba.nacos.naming.utils.ServiceUtil;
import java.util.Collection;

public class PushExecuteTask
extends AbstractExecuteTask {
    private final Service service;
    private final PushDelayTaskExecuteEngine delayTaskEngine;
    private final PushDelayTask delayTask;

    public PushExecuteTask(Service service, PushDelayTaskExecuteEngine delayTaskEngine, PushDelayTask delayTask) {
        this.service = service;
        this.delayTaskEngine = delayTaskEngine;
        this.delayTask = delayTask;
    }

    public void run() {
        try {
            PushDataWrapper wrapper = this.generatePushData();
            for (String each : this.getTargetClientIds()) {
                Client client = this.delayTaskEngine.getClientManager().getClient(each);
                if (null == client) continue;
                Subscriber subscriber = this.delayTaskEngine.getClientManager().getClient(each).getSubscriber(this.service);
                this.delayTaskEngine.getPushExecutor().doPushWithCallback(each, subscriber, wrapper, new NamingPushCallback(each, subscriber, wrapper.getOriginalData(), this.delayTask.isPushToAll()));
            }
        }
        catch (Exception e) {
            Loggers.PUSH.error("Push task for service" + this.service.getGroupedServiceName() + " execute failed ", (Throwable)e);
            this.delayTaskEngine.addTask(this.service, new PushDelayTask(this.service, 1000L));
        }
    }

    private PushDataWrapper generatePushData() {
        ServiceInfo serviceInfo = this.delayTaskEngine.getServiceStorage().getPushData(this.service);
        ServiceMetadata serviceMetadata = this.delayTaskEngine.getMetadataManager().getServiceMetadata(this.service).orElse(null);
        serviceInfo = ServiceUtil.selectInstancesWithHealthyProtection(serviceInfo, serviceMetadata, false, true);
        return new PushDataWrapper(serviceInfo);
    }

    private Collection<String> getTargetClientIds() {
        return this.delayTask.isPushToAll() ? this.delayTaskEngine.getIndexesManager().getAllClientsSubscribeService(this.service) : this.delayTask.getTargetClients();
    }

    private class NamingPushCallback
    implements PushCallBack {
        private final String clientId;
        private final Subscriber subscriber;
        private final ServiceInfo serviceInfo;
        private final long executeStartTime;
        private final boolean isPushToAll;

        private NamingPushCallback(String clientId, Subscriber subscriber, ServiceInfo serviceInfo, boolean isPushToAll) {
            this.clientId = clientId;
            this.subscriber = subscriber;
            this.serviceInfo = serviceInfo;
            this.isPushToAll = isPushToAll;
            this.executeStartTime = System.currentTimeMillis();
        }

        public long getTimeout() {
            return PushConfig.getInstance().getPushTaskTimeout();
        }

        public void onSuccess() {
            long pushFinishTime = System.currentTimeMillis();
            long pushCostTimeForNetWork = pushFinishTime - this.executeStartTime;
            long pushCostTimeForAll = pushFinishTime - PushExecuteTask.this.delayTask.getLastProcessTime();
            long serviceLevelAgreementTime = pushFinishTime - PushExecuteTask.this.service.getLastUpdatedTime();
            if (this.isPushToAll) {
                Loggers.PUSH.info("[PUSH-SUCC] {}ms, all delay time {}ms, SLA {}ms, {}, DataSize={}, target={}", new Object[]{pushCostTimeForNetWork, pushCostTimeForAll, serviceLevelAgreementTime, PushExecuteTask.this.service, this.serviceInfo.getHosts().size(), this.subscriber.getIp()});
            } else {
                Loggers.PUSH.info("[PUSH-SUCC] {}ms, all delay time {}ms for subscriber {}, {}, DataSize={}", new Object[]{pushCostTimeForNetWork, pushCostTimeForAll, this.subscriber.getIp(), PushExecuteTask.this.service, this.serviceInfo.getHosts().size()});
            }
            PushResult result = PushResult.pushSuccess(PushExecuteTask.this.service, this.clientId, this.serviceInfo, this.subscriber, pushCostTimeForNetWork, pushCostTimeForAll, serviceLevelAgreementTime, this.isPushToAll);
            PushResultHookHolder.getInstance().pushSuccess(result);
        }

        public void onFail(Throwable e) {
            long pushCostTime = System.currentTimeMillis() - this.executeStartTime;
            Loggers.PUSH.error("[PUSH-FAIL] {}ms, {}, reason={}, target={}", new Object[]{pushCostTime, PushExecuteTask.this.service, e.getMessage(), this.subscriber.getIp()});
            if (!(e instanceof NoRequiredRetryException)) {
                Loggers.PUSH.error("Reason detail: ", e);
                PushExecuteTask.this.delayTaskEngine.addTask(PushExecuteTask.this.service, new PushDelayTask(PushExecuteTask.this.service, PushConfig.getInstance().getPushTaskRetryDelay(), this.clientId));
            }
            PushResult result = PushResult.pushFailed(PushExecuteTask.this.service, this.clientId, this.serviceInfo, this.subscriber, pushCostTime, e, this.isPushToAll);
            PushResultHookHolder.getInstance().pushFailed(result);
        }
    }
}

