/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.client.manager;

import com.alibaba.nacos.naming.core.v2.client.Client;
import com.alibaba.nacos.naming.core.v2.client.ClientAttributes;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.core.v2.client.manager.impl.ConnectionBasedClientManager;
import com.alibaba.nacos.naming.core.v2.client.manager.impl.EphemeralIpPortClientManager;
import com.alibaba.nacos.naming.core.v2.client.manager.impl.PersistentIpPortClientManager;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.stereotype.Component;

@Component(value="clientManager")
public class ClientManagerDelegate
implements ClientManager {
    private final ConnectionBasedClientManager connectionBasedClientManager;
    private final EphemeralIpPortClientManager ephemeralIpPortClientManager;
    private final PersistentIpPortClientManager persistentIpPortClientManager;
    private static final String SUFFIX = "false";

    public ClientManagerDelegate(ConnectionBasedClientManager connectionBasedClientManager, EphemeralIpPortClientManager ephemeralIpPortClientManager, PersistentIpPortClientManager persistentIpPortClientManager) {
        this.connectionBasedClientManager = connectionBasedClientManager;
        this.ephemeralIpPortClientManager = ephemeralIpPortClientManager;
        this.persistentIpPortClientManager = persistentIpPortClientManager;
    }

    @Override
    public boolean clientConnected(String clientId, ClientAttributes attributes) {
        return this.getClientManagerById(clientId).clientConnected(clientId, attributes);
    }

    @Override
    public boolean clientConnected(Client client) {
        return this.getClientManagerById(client.getClientId()).clientConnected(client);
    }

    @Override
    public boolean syncClientConnected(String clientId, ClientAttributes attributes) {
        return this.getClientManagerById(clientId).syncClientConnected(clientId, attributes);
    }

    @Override
    public boolean clientDisconnected(String clientId) {
        return this.getClientManagerById(clientId).clientDisconnected(clientId);
    }

    @Override
    public Client getClient(String clientId) {
        return this.getClientManagerById(clientId).getClient(clientId);
    }

    @Override
    public boolean contains(String clientId) {
        return this.connectionBasedClientManager.contains(clientId) || this.ephemeralIpPortClientManager.contains(clientId) || this.persistentIpPortClientManager.contains(clientId);
    }

    @Override
    public Collection<String> allClientId() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.connectionBasedClientManager.allClientId());
        result.addAll(this.ephemeralIpPortClientManager.allClientId());
        result.addAll(this.persistentIpPortClientManager.allClientId());
        return result;
    }

    @Override
    public boolean isResponsibleClient(Client client) {
        return this.getClientManagerById(client.getClientId()).isResponsibleClient(client);
    }

    @Override
    public boolean verifyClient(String clientId) {
        return this.getClientManagerById(clientId).verifyClient(clientId);
    }

    private ClientManager getClientManagerById(String clientId) {
        if (this.isConnectionBasedClient(clientId)) {
            return this.connectionBasedClientManager;
        }
        return clientId.endsWith(SUFFIX) ? this.persistentIpPortClientManager : this.ephemeralIpPortClientManager;
    }

    private boolean isConnectionBasedClient(String clientId) {
        return !clientId.contains("#");
    }
}

