/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.consistency.RecordListener;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Instances;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteEventListener;
import com.alibaba.nacos.naming.healthcheck.ClientBeatCheckTask;
import com.alibaba.nacos.naming.healthcheck.ClientBeatProcessor;
import com.alibaba.nacos.naming.healthcheck.HealthCheckReactor;
import com.alibaba.nacos.naming.healthcheck.RsInfo;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.pojo.Record;
import com.alibaba.nacos.naming.push.UdpPushService;
import com.alibaba.nacos.naming.selector.NoneSelector;
import com.alibaba.nacos.naming.selector.Selector;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Service
extends com.alibaba.nacos.api.naming.pojo.Service
implements Record,
RecordListener<Instances> {
    private static final String SERVICE_NAME_SYNTAX = "[0-9a-zA-Z@\\.:_-]+";
    @JsonIgnore
    private ClientBeatCheckTask clientBeatCheckTask = new ClientBeatCheckTask(this);
    private int finalizeCount = 0;
    private String token;
    private List<String> owners = new ArrayList<String>();
    private Boolean resetWeight = false;
    private Boolean enabled = true;
    private Selector selector = new NoneSelector();
    private String namespaceId;
    private long ipDeleteTimeout = 30000L;
    private volatile long lastModifiedMillis = 0L;
    private volatile String checksum;
    private long pushCacheMillis = 0L;
    private Map<String, Cluster> clusterMap = new HashMap<String, Cluster>();

    public Service() {
    }

    public Service(String name) {
        super(name);
    }

    @JsonIgnore
    public UdpPushService getPushService() {
        return (UdpPushService)ApplicationUtils.getBean(UdpPushService.class);
    }

    public long getIpDeleteTimeout() {
        return this.ipDeleteTimeout;
    }

    public void setIpDeleteTimeout(long ipDeleteTimeout) {
        this.ipDeleteTimeout = ipDeleteTimeout;
    }

    public void processClientBeat(RsInfo rsInfo) {
        ClientBeatProcessor clientBeatProcessor = new ClientBeatProcessor();
        clientBeatProcessor.setService(this);
        clientBeatProcessor.setRsInfo(rsInfo);
        HealthCheckReactor.scheduleNow(clientBeatProcessor);
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public long getLastModifiedMillis() {
        return this.lastModifiedMillis;
    }

    public void setLastModifiedMillis(long lastModifiedMillis) {
        this.lastModifiedMillis = lastModifiedMillis;
    }

    public Boolean getResetWeight() {
        return this.resetWeight;
    }

    public void setResetWeight(Boolean resetWeight) {
        this.resetWeight = resetWeight;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    @Override
    public boolean interests(String key) {
        return KeyBuilder.matchInstanceListKey(key, this.namespaceId, this.getName());
    }

    @Override
    public boolean matchUnlistenKey(String key) {
        return KeyBuilder.matchInstanceListKey(key, this.namespaceId, this.getName());
    }

    @Override
    public void onChange(String key, Instances value) throws Exception {
        Loggers.SRV_LOG.info("[NACOS-RAFT] datum is changed, key: {}, value: {}", (Object)key, (Object)value);
        for (Instance instance : value.getInstanceList()) {
            if (instance == null) {
                throw new RuntimeException("got null instance " + key);
            }
            if (instance.getWeight() > 10000.0) {
                instance.setWeight(10000.0);
            }
            if (!(instance.getWeight() < 0.01) || !(instance.getWeight() > 0.0)) continue;
            instance.setWeight(0.01);
        }
        this.updateIPs(value.getInstanceList(), KeyBuilder.matchEphemeralInstanceListKey(key));
        this.recalculateChecksum();
    }

    @Override
    public void onDelete(String key) throws Exception {
        boolean isEphemeral = KeyBuilder.matchEphemeralInstanceListKey(key);
        for (Cluster each : this.clusterMap.values()) {
            each.updateIps(Collections.emptyList(), isEphemeral);
        }
    }

    public int healthyInstanceCount() {
        int healthyCount = 0;
        for (Instance instance : this.allIPs()) {
            if (!instance.isHealthy()) continue;
            ++healthyCount;
        }
        return healthyCount;
    }

    public boolean triggerFlag() {
        return (double)this.healthyInstanceCount() * 1.0 / (double)this.allIPs().size() <= (double)this.getProtectThreshold();
    }

    public void updateIPs(Collection<Instance> instances, boolean ephemeral) {
        HashMap<String, AbstractList> ipMap = new HashMap<String, AbstractList>(this.clusterMap.size());
        for (String string : this.clusterMap.keySet()) {
            ipMap.put(string, new ArrayList());
        }
        for (Instance instance : instances) {
            try {
                LinkedList<Instance> clusterIPs;
                if (instance == null) {
                    Loggers.SRV_LOG.error("[NACOS-DOM] received malformed ip: null");
                    continue;
                }
                if (StringUtils.isEmpty((String)instance.getClusterName())) {
                    instance.setClusterName("DEFAULT");
                }
                if (!this.clusterMap.containsKey(instance.getClusterName())) {
                    Loggers.SRV_LOG.warn("cluster: {} not found, ip: {}, will create new cluster with default configuration.", (Object)instance.getClusterName(), (Object)instance.toJson());
                    Cluster cluster = new Cluster(instance.getClusterName(), this);
                    cluster.init();
                    this.getClusterMap().put(instance.getClusterName(), cluster);
                }
                if ((clusterIPs = (LinkedList<Instance>)ipMap.get(instance.getClusterName())) == null) {
                    clusterIPs = new LinkedList<Instance>();
                    ipMap.put(instance.getClusterName(), clusterIPs);
                }
                clusterIPs.add(instance);
            }
            catch (Exception e) {
                Loggers.SRV_LOG.error("[NACOS-DOM] failed to process ip: " + instance, (Throwable)e);
            }
        }
        for (Map.Entry entry : ipMap.entrySet()) {
            List entryIPs = (List)entry.getValue();
            this.clusterMap.get(entry.getKey()).updateIps(entryIPs, ephemeral);
        }
        this.setLastModifiedMillis(System.currentTimeMillis());
        this.getPushService().serviceChanged(this);
        ((DoubleWriteEventListener)((Object)ApplicationUtils.getBean(DoubleWriteEventListener.class))).doubleWriteToV2(this, ephemeral);
        StringBuilder stringBuilder = new StringBuilder();
        for (Instance instance : this.allIPs()) {
            stringBuilder.append(instance.toIpAddr()).append('_').append(instance.isHealthy()).append(',');
        }
        Loggers.EVT_LOG.info("[IP-UPDATED] namespace: {}, service: {}, ips: {}", new Object[]{this.getNamespaceId(), this.getName(), stringBuilder.toString()});
    }

    public void init() {
        HealthCheckReactor.scheduleCheck(this.clientBeatCheckTask);
        for (Map.Entry<String, Cluster> entry : this.clusterMap.entrySet()) {
            entry.getValue().setService(this);
            entry.getValue().init();
        }
    }

    public void destroy() throws Exception {
        for (Map.Entry<String, Cluster> entry : this.clusterMap.entrySet()) {
            entry.getValue().destroy();
        }
        HealthCheckReactor.cancelCheck(this.clientBeatCheckTask);
        ((DoubleWriteEventListener)((Object)ApplicationUtils.getBean(DoubleWriteEventListener.class))).doubleWriteMetadataToV2(this, this.allIPs(false).isEmpty(), true);
    }

    public boolean isEmpty() {
        for (Map.Entry<String, Cluster> entry : this.clusterMap.entrySet()) {
            Cluster cluster = entry.getValue();
            if (cluster.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public List<Instance> allIPs() {
        ArrayList<Instance> result = new ArrayList<Instance>();
        for (Map.Entry<String, Cluster> entry : this.clusterMap.entrySet()) {
            result.addAll(entry.getValue().allIPs());
        }
        return result;
    }

    public List<Instance> allIPs(boolean ephemeral) {
        ArrayList<Instance> result = new ArrayList<Instance>();
        for (Map.Entry<String, Cluster> entry : this.clusterMap.entrySet()) {
            result.addAll(entry.getValue().allIPs(ephemeral));
        }
        return result;
    }

    public List<Instance> allIPs(List<String> clusters) {
        ArrayList<Instance> result = new ArrayList<Instance>();
        for (String cluster : clusters) {
            Cluster clusterObj = this.clusterMap.get(cluster);
            if (clusterObj == null) continue;
            result.addAll(clusterObj.allIPs());
        }
        return result;
    }

    public List<Instance> srvIPs(List<String> clusters) {
        if (CollectionUtils.isEmpty(clusters)) {
            clusters = new ArrayList<String>();
            clusters.addAll(this.clusterMap.keySet());
        }
        return this.allIPs(clusters);
    }

    public String toJson() {
        return JacksonUtils.toJson((Object)this);
    }

    @JsonIgnore
    public String getServiceString() {
        HashMap<String, Object> serviceObject = new HashMap<String, Object>(10);
        Service service = this;
        serviceObject.put("name", service.getName());
        List<Instance> ips = service.allIPs();
        int invalidIpCount = 0;
        int ipCount = 0;
        for (Instance instance : ips) {
            if (!instance.isHealthy()) {
                ++invalidIpCount;
            }
            ++ipCount;
        }
        serviceObject.put("ipCount", ipCount);
        serviceObject.put("invalidIPCount", invalidIpCount);
        serviceObject.put("owners", service.getOwners());
        serviceObject.put("token", service.getToken());
        serviceObject.put("protectThreshold", Float.valueOf(service.getProtectThreshold()));
        ArrayList clustersList = new ArrayList();
        for (Map.Entry<String, Cluster> entry : service.getClusterMap().entrySet()) {
            Cluster cluster = entry.getValue();
            HashMap<String, Object> clusters = new HashMap<String, Object>(10);
            clusters.put("name", cluster.getName());
            clusters.put("healthChecker", cluster.getHealthChecker());
            clusters.put("defCkport", cluster.getDefCkport());
            clusters.put("defIPPort", cluster.getDefIPPort());
            clusters.put("useIPPort4Check", cluster.isUseIPPort4Check());
            clusters.put("sitegroup", cluster.getSitegroup());
            clustersList.add(clusters);
        }
        serviceObject.put("clusters", clustersList);
        try {
            return JacksonUtils.toJson(serviceObject);
        }
        catch (Exception exception) {
            throw new RuntimeException("Service toJson failed", exception);
        }
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public List<String> getOwners() {
        return this.owners;
    }

    public void setOwners(List<String> owners) {
        this.owners = owners;
    }

    public Map<String, Cluster> getClusterMap() {
        return this.clusterMap;
    }

    public void setClusterMap(Map<String, Cluster> clusterMap) {
        this.clusterMap = clusterMap;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public void update(Service vDom) {
        if (!StringUtils.equals((String)this.token, (String)vDom.getToken())) {
            Loggers.SRV_LOG.info("[SERVICE-UPDATE] service: {}, token: {} -> {}", new Object[]{this.getName(), this.token, vDom.getToken()});
            this.token = vDom.getToken();
        }
        if (!ListUtils.isEqualList(this.owners, vDom.getOwners())) {
            Loggers.SRV_LOG.info("[SERVICE-UPDATE] service: {}, owners: {} -> {}", new Object[]{this.getName(), this.owners, vDom.getOwners()});
            this.owners = vDom.getOwners();
        }
        if (this.getProtectThreshold() != vDom.getProtectThreshold()) {
            Loggers.SRV_LOG.info("[SERVICE-UPDATE] service: {}, protectThreshold: {} -> {}", new Object[]{this.getName(), Float.valueOf(this.getProtectThreshold()), Float.valueOf(vDom.getProtectThreshold())});
            this.setProtectThreshold(vDom.getProtectThreshold());
        }
        if (this.resetWeight.booleanValue() != vDom.getResetWeight().booleanValue()) {
            Loggers.SRV_LOG.info("[SERVICE-UPDATE] service: {}, resetWeight: {} -> {}", new Object[]{this.getName(), this.resetWeight, vDom.getResetWeight()});
            this.resetWeight = vDom.getResetWeight();
        }
        if (this.enabled.booleanValue() != vDom.getEnabled().booleanValue()) {
            Loggers.SRV_LOG.info("[SERVICE-UPDATE] service: {}, enabled: {} -> {}", new Object[]{this.getName(), this.enabled, vDom.getEnabled()});
            this.enabled = vDom.getEnabled();
        }
        this.selector = vDom.getSelector();
        this.setMetadata(vDom.getMetadata());
        this.updateOrAddCluster(vDom.getClusterMap().values());
        this.remvDeadClusters(this, vDom);
        Loggers.SRV_LOG.info("cluster size, new: {}, old: {}", (Object)this.getClusterMap().size(), (Object)vDom.getClusterMap().size());
        this.recalculateChecksum();
        ((DoubleWriteEventListener)((Object)ApplicationUtils.getBean(DoubleWriteEventListener.class))).doubleWriteMetadataToV2(this, vDom.allIPs(false).isEmpty(), false);
    }

    @Override
    public String getChecksum() {
        if (StringUtils.isEmpty((String)this.checksum)) {
            this.recalculateChecksum();
        }
        return this.checksum;
    }

    public synchronized void recalculateChecksum() {
        List<Instance> ips = this.allIPs();
        StringBuilder ipsString = new StringBuilder();
        ipsString.append(this.getServiceString());
        if (Loggers.SRV_LOG.isDebugEnabled()) {
            Loggers.SRV_LOG.debug("service to json: " + this.getServiceString());
        }
        if (CollectionUtils.isNotEmpty(ips)) {
            Collections.sort(ips);
        }
        for (Instance ip : ips) {
            String string = ip.getIp() + ":" + ip.getPort() + "_" + ip.getWeight() + "_" + ip.isHealthy() + "_" + ip.getClusterName();
            ipsString.append(string);
            ipsString.append(',');
        }
        this.checksum = MD5Utils.md5Hex((String)ipsString.toString(), (String)"UTF-8");
    }

    private void updateOrAddCluster(Collection<Cluster> clusters) {
        for (Cluster cluster : clusters) {
            Cluster oldCluster = this.clusterMap.get(cluster.getName());
            if (oldCluster != null) {
                oldCluster.setService(this);
                oldCluster.update(cluster);
                continue;
            }
            cluster.init();
            cluster.setService(this);
            this.clusterMap.put(cluster.getName(), cluster);
        }
    }

    private void remvDeadClusters(Service oldDom, Service newDom) {
        Collection<Cluster> oldClusters = oldDom.getClusterMap().values();
        Collection<Cluster> newClusters = newDom.getClusterMap().values();
        List deadClusters = (List)CollectionUtils.subtract(oldClusters, newClusters);
        for (Cluster cluster : deadClusters) {
            oldDom.getClusterMap().remove(cluster.getName());
            cluster.destroy();
        }
    }

    public int getFinalizeCount() {
        return this.finalizeCount;
    }

    public void setFinalizeCount(int finalizeCount) {
        this.finalizeCount = finalizeCount;
    }

    public void addCluster(Cluster cluster) {
        this.clusterMap.put(cluster.getName(), cluster);
    }

    public void validate() {
        if (!this.getName().matches(SERVICE_NAME_SYNTAX)) {
            throw new IllegalArgumentException("dom name can only have these characters: 0-9a-zA-Z-._:, current: " + this.getName());
        }
        for (Cluster cluster : this.clusterMap.values()) {
            cluster.validate();
        }
    }
}

